
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.component;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * A checkbox that is used as a boolean table cell.
 * This class can be used as both a cell renderer and a cell editor if
 * desired.
 * The corresponding value in the table <b>must</b> be of type
 * <tt>Boolean</tt>.
 */
public class CheckBoxRenderer extends AbstractCellEditor
        implements TableCellRenderer, TableCellEditor, ItemListener {
    /**
     * The renderer checkbox.
     */
    private JCheckBox renderer;
    /**
     * The editor checkbox.
     */
    private JCheckBox editor;
    /**
     * Are we currently editing the table cell?
     */
    private boolean isEditing;

    /**
     * Creates a new checkbox renderer/editor.
     */
    public CheckBoxRenderer() {
        isEditing = false;
        renderer = new JCheckBox();
        renderer.setHorizontalAlignment(SwingConstants.CENTER);
        editor = new JCheckBox();
        editor.setHorizontalAlignment(SwingConstants.CENTER);
        editor.addItemListener(this);
    }

    /**
     * Called when the checkbox has changed state.
     *
     * @param e the state changing event.
     */
    public void itemStateChanged(ItemEvent e) {
        if (isEditing)
            stopCellEditing();
    }

    /**
     * Returns the component that does the rendering.
     *
     * @param table the table in which a cell is being rendered.
     * @param value the value of the table cell being rendered.
     * @param isSelected whether or not the table cell is currently
     * selected.
     * @param hasFocus whether or not the table cell currently has the
     * focus.
     * @param row the row of the table cell being rendered.
     * @param column the column of the table cell being rendered.
     * @return the component that does the rendering.
     */
    public Component getTableCellRendererComponent(JTable table,
            Object value, boolean isSelected, boolean hasFocus,
            int row, int column) {
        renderer.setSelected(((Boolean)value).booleanValue());
        return renderer;
    }

    /**
     * Returns the component that does the editing.
     *
     * @param table the table in which a cell is being edited.
     * @param value the value of the table cell being edited.
     * @param isSelected whether or not the table cell is currently
     * selected.
     * @param row the row of the table cell being edited.
     * @param column the column of the table cell being edited.
     * @return the component that does the editing.
     */
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {
        editor.setSelected(((Boolean)value).booleanValue());
        isEditing = true;
        return editor;
    }

    /**
     * Returns the value contained in the cell editor.
     *
     * @return the value contained in the cell editor.
     */
    public Object getCellEditorValue() {
        return new Boolean(editor.isSelected());
    }

    /**
     * Prepares the component for editing as requested by the given
     * event.
     *
     * @param e the event that caused editing to begin.
     * @return <tt>true</tt> if and only if the table cell being edited
     * should be selected.
     */
    public boolean shouldSelectCell(EventObject e) {
        editor.requestFocus();
        return false;
    }

    /**
     * Stops editing the table cell and stores any changes.
     *
     * @return <tt>true</tt> if and only if editing was successfully
     * stopped.
     */
    public boolean stopCellEditing() {
        isEditing = false;
        return super.stopCellEditing();
    }

    /**
     * Cancels editing the table cell and disregards any changes.
     */
    public void cancelCellEditing() {
        isEditing = false;
        super.cancelCellEditing();
    }
}

