package org.biojava.utils.bytecode;

/**
 * Instructions which retrieve a long from the constant pool.
 *
 * @author Thomas Down
 * @author Matthew Pocock 
 */

class LongConstantInstruction implements Instruction {
  private final long val;
  
  LongConstantInstruction(long val) {
    this.val = val;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(ByteCode.op_ldc2_w);
    ctx.writeShort(ctx.getConstants().resolveLong(val));
  }
  
  public int stackDepth() {
    return stackDelta();
  }
  
  public int stackDelta() {
    return 1;
  }
}
