/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xinclude;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Monitor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.logger.Logger;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ProcessorException;
import org.apache.cocoon.xml.util.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XIncludeProcessor
extends AbstractActor
implements Processor,
Status {
    protected boolean debug = false;
    public static final String XMLBASE_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLBASE_ATTRIBUTE = "base";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/1999/XML/xinclude";
    public static final String XINCLUDE_HREF_ATTRIBUTE = "href";
    public static final String XINCLUDE_PARSE_ATTRIBUTE = "parse";
    public static final int BUFFER_SIZE = 1024;
    protected Parser parser;
    protected Logger logger;
    protected Object context;
    protected Monitor monitor;
    protected Hashtable monitored_table;

    public String getStatus() {
        return "XInclude Processor";
    }

    public boolean hasChanged(Object object) {
        String key = Utils.encode((HttpServletRequest)object);
        if (this.monitored_table.containsKey(key)) {
            return this.monitor.hasChanged(key);
        }
        return false;
    }

    public void init(Director director) {
        super.init(director);
        this.parser = (Parser)director.getActor("parser");
        this.logger = (Logger)director.getActor("logger");
        this.context = director.getActor("context");
        this.monitor = new Monitor(10);
        this.monitored_table = new Hashtable();
    }

    public Document process(Document document, Dictionary parameters) throws Exception {
        XIncludeProcessorWorker worker = new XIncludeProcessorWorker(this, document, parameters);
        worker.process();
        return worker.document;
    }

    class XIncludeElement {
        Element element;
        Element parent;
        String href;
        String parse;
        Object base;
        String suffix;
        String xpath = null;

        XIncludeElement(Element element, Element parent, String href, String parse, Object base) {
            this.element = element;
            this.parent = parent;
            this.parse = parse;
            this.base = base;
            int index = href.indexOf(35);
            if (index < 0) {
                this.suffix = "";
                this.href = href;
            } else {
                this.suffix = href.substring(index + 1);
                this.href = href.substring(0, index);
                if (this.suffix.startsWith("xpointer(") && this.suffix.endsWith(")")) {
                    this.xpath = this.suffix.substring(9, this.suffix.length() - 1);
                }
            }
        }
    }

    class XIncludeProcessorWorker {
        boolean debug;
        XIncludeProcessor processor;
        Document document;
        Object current_xmlbase;
        Stack xmlbase_stack = new Stack();
        Vector xinclude_elements = new Vector();
        Object monitor_key;
        HttpServletRequest request;

        XIncludeProcessorWorker(XIncludeProcessor processor, Document document, Dictionary parameters) throws Exception {
            this.processor = processor;
            this.debug = processor.debug;
            this.document = document;
            this.request = (HttpServletRequest)parameters.get("request");
            this.monitor_key = Utils.encode(this.request);
            String basepath = Utils.getBasepath(this.request, XIncludeProcessor.this.context);
            this.current_xmlbase = new File(basepath);
        }

        void process() throws Exception {
            Element element = this.document.getDocumentElement();
            element.appendChild(this.document.createComment("Processed by XInclude"));
            this.scan(element, null);
            Enumeration e = this.xinclude_elements.elements();
            while (e.hasMoreElements()) {
                XIncludeElement xinclude = (XIncludeElement)e.nextElement();
                Object object = this.processXIncludeElement(xinclude);
                if (object instanceof Node) {
                    Node node = (Node)object;
                    xinclude.parent.replaceChild(node, xinclude.element);
                    if (node.getNodeType() != 1) continue;
                    this.xmlbase_stack.push(xinclude.base);
                    this.scan((Element)node, xinclude.parent);
                    this.xmlbase_stack.pop();
                    continue;
                }
                if (!(object instanceof Node[])) continue;
                Node[] ary = (Node[])object;
                int i = 0;
                while (i < ary.length) {
                    xinclude.parent.insertBefore(ary[i], xinclude.element);
                    ++i;
                }
                xinclude.parent.removeChild(xinclude.element);
                int i2 = 0;
                while (i2 < ary.length) {
                    this.xmlbase_stack.push(xinclude.base);
                    if (ary[i2].getNodeType() == 1) {
                        this.scan((Element)ary[i2], xinclude.parent);
                    }
                    this.xmlbase_stack.pop();
                    ++i2;
                }
            }
        }

        Object processXIncludeElement(XIncludeElement xinclude) throws Exception {
            Object content = null;
            String system_id = null;
            Serializable local = null;
            try {
                if (xinclude.href.equals("")) {
                    if (xinclude.xpath == null) {
                        throw new ProcessorException("Invalid xinclude element: " + xinclude + ": no href, no valid suffix");
                    }
                    NodeList list = XPathAPI.selectNodeList(this.document, xinclude.xpath);
                    int length = list.getLength();
                    Node[] ary = new Node[length];
                    int i = 0;
                    while (i < length) {
                        ary[i] = list.item(i).cloneNode(true);
                        ++i;
                    }
                    return ary;
                }
                if (xinclude.href.charAt(0) == '/') {
                    local = new File(Utils.getRootpath(this.request, XIncludeProcessor.this.context), xinclude.href);
                    system_id = ((File)local).getAbsolutePath();
                    content = new FileReader((File)local);
                } else if (xinclude.href.indexOf("://") >= 0) {
                    local = new URL(xinclude.href);
                    system_id = local.toString();
                    content = ((URL)local).getContent();
                } else if (xinclude.base instanceof URL) {
                    local = new URL((URL)xinclude.base, xinclude.href);
                    system_id = local.toString();
                    content = ((URL)local).getContent();
                } else if (xinclude.base instanceof File) {
                    local = new File((File)xinclude.base, xinclude.href);
                    system_id = ((File)local).getAbsolutePath();
                    content = new FileReader((File)local);
                }
                this.processor.monitored_table.put(this.monitor_key, "");
                this.processor.monitor.watch(this.monitor_key, local);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ProcessorException("Invalid xinclude element: " + xinclude + ": malformed URL");
            }
            Node[] result = null;
            if (xinclude.parse.equals("text")) {
                if (content instanceof Reader) {
                    Reader reader = (Reader)content;
                    char[] ary = new char[1024];
                    StringBuffer sb = new StringBuffer();
                    if (reader != null) {
                        int read;
                        while ((read = reader.read(ary)) != -1) {
                            sb.append(ary, 0, read);
                        }
                        reader.close();
                    }
                    result = this.document.createTextNode(sb.toString());
                } else if (content instanceof InputStream) {
                    InputStream input = (InputStream)content;
                    InputStreamReader reader = new InputStreamReader(input);
                    char[] ary = new char[1024];
                    StringBuffer sb = new StringBuffer();
                    if (reader != null) {
                        int read;
                        while ((read = reader.read(ary)) != -1) {
                            sb.append(ary, 0, read);
                        }
                        reader.close();
                    }
                    result = this.document.createTextNode(sb.toString());
                }
            } else if (xinclude.parse.equals("xml")) {
                InputSource input = new InputSource(system_id);
                Document included_document = null;
                try {
                    included_document = XIncludeProcessor.this.parser.parse(input, false);
                    this.stripDocumentTypeNodes(included_document.getDocumentElement());
                }
                catch (Exception exception) {}
                if (xinclude.xpath != null) {
                    NodeList list = XPathAPI.selectNodeList(included_document, xinclude.xpath);
                    int length = list.getLength();
                    Node[] ary = new Node[length];
                    int i = 0;
                    while (i < length) {
                        ary[i] = this.document.importNode(list.item(i), true);
                        ++i;
                    }
                    result = ary;
                } else {
                    result = this.document.importNode(included_document.getDocumentElement(), true);
                }
            }
            return result;
        }

        void scan(Element element, Element parent) throws Exception {
            String name = element.getLocalName();
            String uri = element.getNamespaceURI();
            String prefix = element.getPrefix();
            boolean xmlbase_attribute = false;
            if (element.hasAttributeNS(XIncludeProcessor.XMLBASE_NAMESPACE_URI, XIncludeProcessor.XMLBASE_ATTRIBUTE)) {
                this.xmlbase_stack.push(this.current_xmlbase);
                this.current_xmlbase = new URL(element.getAttributeNS(XIncludeProcessor.XMLBASE_NAMESPACE_URI, XIncludeProcessor.XMLBASE_ATTRIBUTE));
                xmlbase_attribute = true;
            }
            if (!this.scanForXInclude(element, parent)) {
                Node child = element.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        this.scan((Element)child, element);
                    }
                    child = child.getNextSibling();
                }
            }
            if (xmlbase_attribute) {
                this.current_xmlbase = this.xmlbase_stack.pop();
            }
        }

        boolean scanForXInclude(Element element, Element parent) {
            if (element.hasAttributeNS(XIncludeProcessor.XINCLUDE_NAMESPACE_URI, XIncludeProcessor.XINCLUDE_HREF_ATTRIBUTE) && element.hasAttributeNS(XIncludeProcessor.XINCLUDE_NAMESPACE_URI, XIncludeProcessor.XINCLUDE_PARSE_ATTRIBUTE)) {
                String href = element.getAttributeNS(XIncludeProcessor.XINCLUDE_NAMESPACE_URI, XIncludeProcessor.XINCLUDE_HREF_ATTRIBUTE);
                String parse = element.getAttributeNS(XIncludeProcessor.XINCLUDE_NAMESPACE_URI, XIncludeProcessor.XINCLUDE_PARSE_ATTRIBUTE);
                this.xinclude_elements.addElement(new XIncludeElement(element, parent, href, parse, this.current_xmlbase));
                return true;
            }
            return false;
        }

        void stripDocumentTypeNodes(Node node) {
            Node child = node.getFirstChild();
            while (child != null) {
                Node next = child.getNextSibling();
                if (child.getNodeType() == 10) {
                    node.removeChild(child);
                } else if (child.getNodeType() == 1) {
                    this.stripDocumentTypeNodes(child);
                }
                child = next;
            }
        }
    }
}

