/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library;

import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.cocoon.framework.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class XSPContextLibrary {
    public static Element getAttribute(ServletContext context, String name, Document document) {
        Object value = context.getAttribute(name);
        Element element = document.createElement("context:attribute");
        element.setAttribute("name", name);
        if (value != null) {
            if (value instanceof XObject) {
                DocumentFragment fragment = document.createDocumentFragment();
                ((XObject)value).toDOM(fragment);
                element.appendChild(fragment);
            } else {
                element.appendChild(document.createTextNode(value.toString()));
            }
        }
        return element;
    }

    public static String[] getAttributeNames(ServletContext context) {
        Vector<Object> v = new Vector<Object>();
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            v.addElement(context.getAttribute((String)e.nextElement()));
        }
        Object[] attributeNames = new String[v.size()];
        v.copyInto(attributeNames);
        return attributeNames;
    }

    public static Element getAttributeNames(ServletContext context, Document document) {
        String[] attributeNames = XSPContextLibrary.getAttributeNames(context);
        Element element = document.createElement("context:attribute-names");
        int i = 0;
        while (i < attributeNames.length) {
            Element nameElement = document.createElement("context:attribute-name");
            nameElement.appendChild(document.createTextNode(attributeNames[i]));
            element.appendChild(nameElement);
            ++i;
        }
        return element;
    }

    public static Element getInitParameter(ServletContext context, String name, Document document) {
        String value = context.getInitParameter(name);
        Element element = document.createElement("context:init-parameter");
        element.setAttribute("name", name);
        if (value != null) {
            element.appendChild(document.createTextNode(value));
        }
        return element;
    }

    public static String[] getInitParameterNames(ServletContext context) {
        Vector<String> v = new Vector<String>();
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            v.addElement(context.getInitParameter((String)e.nextElement()));
        }
        Object[] attributeNames = new String[v.size()];
        v.copyInto(attributeNames);
        return attributeNames;
    }

    public static Element getInitParameterNames(ServletContext context, Document document) {
        String[] attributeNames = XSPContextLibrary.getInitParameterNames(context);
        Element element = document.createElement("context:attribute-names");
        int i = 0;
        while (i < attributeNames.length) {
            Element nameElement = document.createElement("context:attribute-name");
            nameElement.appendChild(document.createTextNode(attributeNames[i]));
            element.appendChild(nameElement);
            ++i;
        }
        return element;
    }

    public static Element getMajorVersion(ServletContext context, Document document) {
        Element element = document.createElement("context:major-version");
        element.appendChild(document.createTextNode(String.valueOf(context.getMajorVersion())));
        return element;
    }

    public static Element getMimeType(ServletContext context, String file, Document document) {
        Element element = document.createElement("context:mime-type");
        element.appendChild(document.createTextNode(context.getMimeType(file)));
        return element;
    }

    public static Element getMinorVersion(ServletContext context, Document document) {
        Element element = document.createElement("context:minor-version");
        element.appendChild(document.createTextNode(String.valueOf(context.getMinorVersion())));
        return element;
    }

    public static Element getRealPath(ServletContext context, String path, Document document) {
        Element element = document.createElement("context:real-path");
        element.appendChild(document.createTextNode(context.getRealPath(path).replace('\\', '/')));
        return element;
    }

    public static Element getServerInfo(ServletContext context, Document document) {
        Element element = document.createElement("context:real-server-info");
        element.appendChild(document.createTextNode(context.getServerInfo()));
        return element;
    }
}

