/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.DeepBytecodeHook;
import org.mozilla.javascript.DeepCallHook;
import org.mozilla.javascript.DeepErrorReporterHook;
import org.mozilla.javascript.DeepExecuteHook;
import org.mozilla.javascript.DeepNewObjectHook;
import org.mozilla.javascript.DeepScriptHook;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.ListenerCollection;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.SourceTextManager;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public final class Context {
    public static String languageVersionProperty;
    public static String errorReporterProperty;
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    static final String defaultResource = "org.mozilla.javascript.resources.Messages";
    static final boolean printTrees = false;
    private static Class codegenClass;
    private static ClassNameHelper nameHelper;
    private static boolean requireSecurityDomain;
    static final boolean useJSObject = false;
    NativeCall currentActivation;
    Hashtable iterating;
    Object interpreterSecurityDomain;
    Scriptable ctorScope;
    int version;
    int errorCount;
    static boolean isCachingEnabled;
    private SecuritySupport securitySupport;
    private ErrorReporter errorReporter;
    private Thread currentThread;
    private static Hashtable threadContexts;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingSource = true;
    private boolean compileFunctionsWithDynamicScopeFlag;
    private int optimizationLevel;
    private SourceTextManager debug_stm;
    private DeepScriptHook debug_scriptHook;
    private DeepCallHook debug_callHook;
    private DeepExecuteHook debug_executeHook;
    private DeepNewObjectHook debug_newObjectHook;
    private DeepBytecodeHook debug_bytecodeHook;
    private DeepErrorReporterHook debug_errorReporterHook;
    private static final byte debugLevel = 0;
    private int enterCount;
    private ListenerCollection listeners;
    private Hashtable hashtable;
    int interpreterLine;
    String interpreterSourceFile;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeFunction;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeObject;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeError;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeGlobal;
    static /* synthetic */ Class class$org$mozilla$javascript$Interpreter;

    static {
        Object object;
        languageVersionProperty = "language version";
        errorReporterProperty = "error reporter";
        try {
            codegenClass = Class.forName("org.mozilla.javascript.optimizer.Codegen");
            object = Class.forName("org.mozilla.javascript.optimizer.OptClassNameHelper");
            nameHelper = (ClassNameHelper)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            codegenClass = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            codegenClass = null;
        }
        catch (InstantiationException instantiationException) {
            codegenClass = null;
        }
        requireSecurityDomain = true;
        object = "org.mozilla.javascript.resources.Security";
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.mozilla.javascript.resources.Security");
            String string = resourceBundle.getString("security.requireSecurityDomain");
            requireSecurityDomain = string.equals("true");
        }
        catch (MissingResourceException missingResourceException) {
            requireSecurityDomain = true;
        }
        catch (SecurityException securityException) {
            requireSecurityDomain = true;
        }
        isCachingEnabled = true;
        threadContexts = new Hashtable(11);
    }

    public Context() {
        this.setLanguageVersion(0);
        this.generatingDebug = true;
        this.optimizationLevel = codegenClass != null ? 0 : -1;
    }

    public Context(SecuritySupport securitySupport) {
        this();
        this.securitySupport = securitySupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerCollection();
        }
        this.listeners.addListener(propertyChangeListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Object compile(Scriptable scriptable, Reader reader, String string, int n, Object object, boolean bl) throws IOException {
        TokenStream tokenStream = new TokenStream(reader, scriptable, string, n);
        return this.compile(scriptable, tokenStream, object, bl);
    }

    private Object compile(Scriptable scriptable, TokenStream tokenStream, Object object, boolean bl) throws IOException {
        Object object2;
        Interpreter interpreter = this.optimizationLevel == -1 ? new Interpreter() : this.getCompiler();
        this.errorCount = 0;
        IRFactory iRFactory = interpreter.createIRFactory(tokenStream, nameHelper, scriptable);
        Parser parser = new Parser(iRFactory);
        Node node = (Node)parser.parse(tokenStream);
        if (node == null) {
            return null;
        }
        node = interpreter.transform(node, tokenStream, scriptable);
        if (bl) {
            object2 = node.getFirstChild();
            if (object2 == null) {
                return null;
            }
            node = (Node)((Node)object2).getProp(5);
            if (node == null) {
                return null;
            }
        }
        object2 = interpreter.compile(this, scriptable, node, object, this.securitySupport, nameHelper);
        return this.errorCount == 0 ? object2 : null;
    }

    public Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        StringReader stringReader = new StringReader(string);
        try {
            return (Function)this.compile(scriptable, stringReader, string2, n, object, true);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return (Script)this.compile(scriptable, reader, string, n, object, false);
    }

    public String decompileFunction(Function function, int n) {
        if (function instanceof NativeFunction) {
            return ((NativeFunction)function).decompile(n, true, false);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public String decompileFunctionBody(Function function, int n) {
        if (function instanceof NativeFunction) {
            return ((NativeFunction)function).decompile(n, true, true);
        }
        return "[native code]\n";
    }

    public String decompileScript(Script script, Scriptable scriptable, int n) {
        NativeScript nativeScript = (NativeScript)script;
        nativeScript.initScript(scriptable);
        return nativeScript.decompile(n, true, false);
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context context) {
        Thread thread = Thread.currentThread();
        Context context2 = (Context)threadContexts.get(thread);
        if (context2 != null) {
            Context context3 = context2;
            synchronized (context3) {
                ++context2.enterCount;
            }
            return context2;
        }
        if (context != null) {
            Context context4 = context;
            synchronized (context4) {
                if (context.currentThread == null) {
                    context.currentThread = thread;
                    threadContexts.put(thread, context);
                    ++context.enterCount;
                    Context context5 = context;
                    Object var5_6 = null;
                    return context5;
                }
            }
        }
        context2 = new Context();
        context2.currentThread = thread;
        threadContexts.put(thread, context2);
        context2.enterCount = 1;
        return context2;
    }

    public Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException, JavaScriptException {
        Script script = this.compileReader(scriptable, reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) throws JavaScriptException {
        try {
            StringReader stringReader = new StringReader(string);
            return this.evaluateReader(scriptable, stringReader, string2, n, object);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public static void exit() {
        Context context = Context.getCurrentContext();
        if (context != null) {
            Context context2 = context;
            synchronized (context2) {
                if (--context.enterCount == 0) {
                    threadContexts.remove(context.currentThread);
                    context.currentThread = null;
                }
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        Class clazz = class$java$beans$PropertyChangeListener != null ? class$java$beans$PropertyChangeListener : (class$java$beans$PropertyChangeListener = Context.class$("java.beans.PropertyChangeListener"));
        Object[] objectArray = this.listeners.getListeners(clazz);
        int n = 0;
        while (n < objectArray.length) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)objectArray[n];
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
            ++n;
        }
    }

    public DeepBytecodeHook getBytecodeHook() {
        return this.debug_bytecodeHook;
    }

    public DeepCallHook getCallHook() {
        return this.debug_callHook;
    }

    private Interpreter getCompiler() {
        if (codegenClass == null) {
            return new Interpreter();
        }
        try {
            return (Interpreter)codegenClass.newInstance();
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        throw new RuntimeException("Malformed optimizer package");
    }

    static Context getContext() {
        Thread thread = Thread.currentThread();
        Context context = (Context)threadContexts.get(thread);
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    public static Context getCurrentContext() {
        Thread thread = Thread.currentThread();
        return (Context)threadContexts.get(thread);
    }

    public int getDebugLevel() {
        return 0;
    }

    public Object[] getElements(Scriptable scriptable) {
        double d = NativeArray.getLengthProperty(scriptable);
        if (d != d) {
            return null;
        }
        int n = (int)d;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = scriptable.get(n2, scriptable);
            objectArray[n2] = object == Scriptable.NOT_FOUND ? Undefined.instance : object;
            ++n2;
        }
        return objectArray;
    }

    public ErrorReporter getErrorReporter() {
        if (this.debug_errorReporterHook != null) {
            return this.debug_errorReporterHook;
        }
        if (this.errorReporter == null) {
            this.errorReporter = new DefaultErrorReporter();
        }
        return this.errorReporter;
    }

    public DeepErrorReporterHook getErrorReporterHook() {
        return this.debug_errorReporterHook;
    }

    public DeepExecuteHook getExecuteHook() {
        return this.debug_executeHook;
    }

    public String getImplementationVersion() {
        return "JavaScript-Java 1.5 release 1 2000 03 15";
    }

    public Object getInterpreterSecurityDomain() {
        return this.interpreterSecurityDomain;
    }

    public int getLanguageVersion() {
        return this.version;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context != null ? context.getLocale() : Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(defaultResource, locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    public DeepNewObjectHook getNewObjectHook() {
        return this.debug_newObjectHook;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    RegExpProxy getRegExpProxy() {
        if (this.regExpProxy == null) {
            try {
                Class<?> clazz = Class.forName("org.mozilla.javascript.regexp.RegExpImpl");
                this.regExpProxy = (RegExpProxy)clazz.newInstance();
                return this.regExpProxy;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return this.regExpProxy;
    }

    public DeepScriptHook getScriptHook() {
        return this.debug_scriptHook;
    }

    Object getSecurityDomainForStackDepth(int n) {
        Object object = null;
        if (this.securitySupport != null) {
            Class[] classArray = this.securitySupport.getClassContext();
            if (n != -1) {
                int n2 = n + 1;
                object = this.getSecurityDomainFromClass(classArray[n2]);
            } else {
                int n3 = 1;
                while (n3 < classArray.length) {
                    object = this.getSecurityDomainFromClass(classArray[n3]);
                    if (object != null) break;
                    ++n3;
                }
            }
        }
        if (object != null) {
            return object;
        }
        if (requireSecurityDomain) {
            throw new SecurityException("Required security context not found");
        }
        return null;
    }

    Object getSecurityDomainFromClass(Class clazz) {
        if (clazz == (class$org$mozilla$javascript$Interpreter != null ? class$org$mozilla$javascript$Interpreter : (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")))) {
            return this.interpreterSecurityDomain;
        }
        return this.securitySupport.getSecurityDomain(clazz);
    }

    SecuritySupport getSecuritySupport() {
        return this.securitySupport;
    }

    static String getSourcePositionFromStack(int[] nArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == ':') {
                n3 = n4;
            } else if (c == '(') {
                n = n4;
            } else if (c == ')') {
                n2 = n4;
            } else if (c == '\n' && n != -1 && n2 != -1 && n3 != -1) {
                String string2 = string.substring(n + 1, n3);
                if (string2.endsWith(".js")) {
                    String string3 = string.substring(n3 + 1, n2);
                    try {
                        nArray[0] = Integer.parseInt(string3);
                        return string2;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                n3 = -1;
                n2 = -1;
                n = -1;
            }
            ++n4;
        }
        Context context = Context.getCurrentContext();
        if (context.interpreterLine > 0 && context.interpreterSourceFile != null) {
            nArray[0] = context.interpreterLine;
            return context.interpreterSourceFile;
        }
        return null;
    }

    public SourceTextManager getSourceTextManager() {
        return this.debug_stm;
    }

    public String getTargetClassFileName() {
        return nameHelper == null ? null : nameHelper.getTargetClassFileName();
    }

    public String getTargetPackage() {
        return nameHelper == null ? null : nameHelper.getTargetPackage();
    }

    public Object getThreadLocal(Object object) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(object);
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        try {
            Object object;
            if (scriptableObject == null) {
                scriptableObject = new NativeObject();
            }
            ScriptableObject.defineClass(scriptableObject, class$org$mozilla$javascript$NativeFunction != null ? class$org$mozilla$javascript$NativeFunction : (class$org$mozilla$javascript$NativeFunction = Context.class$("org.mozilla.javascript.NativeFunction")), bl);
            ScriptableObject.defineClass(scriptableObject, class$org$mozilla$javascript$NativeObject != null ? class$org$mozilla$javascript$NativeObject : (class$org$mozilla$javascript$NativeObject = Context.class$("org.mozilla.javascript.NativeObject")), bl);
            Scriptable scriptable = ScriptableObject.getObjectPrototype(scriptableObject);
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptableObject);
            scriptable2.setPrototype(scriptable);
            if (scriptableObject.getPrototype() == null) {
                scriptableObject.setPrototype(scriptable);
            }
            ScriptableObject.defineClass(scriptableObject, class$org$mozilla$javascript$NativeError != null ? class$org$mozilla$javascript$NativeError : (class$org$mozilla$javascript$NativeError = Context.class$("org.mozilla.javascript.NativeError")), bl);
            ScriptableObject.defineClass(scriptableObject, class$org$mozilla$javascript$NativeGlobal != null ? class$org$mozilla$javascript$NativeGlobal : (class$org$mozilla$javascript$NativeGlobal = Context.class$("org.mozilla.javascript.NativeGlobal")), bl);
            String[] stringArray = new String[]{"NativeArray", "Array", "NativeString", "String", "NativeBoolean", "Boolean", "NativeNumber", "Number", "NativeDate", "Date", "NativeMath", "Math", "NativeCall", "Call", "NativeWith", "With", "regexp.NativeRegExp", "RegExp", "NativeScript", "Script"};
            int n = 0;
            while (n < stringArray.length) {
                try {
                    if (bl) {
                        object = Class.forName("org.mozilla.javascript." + stringArray[n]);
                        ScriptableObject.defineClass(scriptableObject, (Class)object, bl);
                    } else {
                        object = "org.mozilla.javascript." + stringArray[n];
                        new LazilyLoadedCtor(scriptableObject, stringArray[n + 1], (String)object, 0);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
                n += 2;
            }
            object = "org.mozilla.javascript.JavaAdapter";
            try {
                object = System.getProperty((String)object, (String)object);
            }
            catch (SecurityException securityException) {}
            try {
                Class<?> clazz = Class.forName((String)object);
                ScriptableObject.defineClass(scriptableObject, clazz, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {}
            NativeJavaPackage.init(scriptableObject);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapException(invocationTargetException);
        }
        catch (ClassDefinitionException classDefinitionException) {
            throw WrappedException.wrapException(classDefinitionException);
        }
        catch (PropertyException propertyException) {
            throw WrappedException.wrapException(propertyException);
        }
        return scriptableObject;
    }

    public boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public boolean isInterpreterClass(Class clazz) {
        return clazz == (class$org$mozilla$javascript$Interpreter != null ? class$org$mozilla$javascript$Interpreter : (class$org$mozilla$javascript$Interpreter = Context.class$("org.mozilla.javascript.Interpreter")));
    }

    public static boolean isSecurityDomainRequired() {
        return requireSecurityDomain;
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    public Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    public Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        NativeArray nativeArray = new NativeArray(objectArray);
        this.newArrayHelper(scriptable, nativeArray);
        return nativeArray;
    }

    private void newArrayHelper(Scriptable scriptable, Scriptable scriptable2) {
        scriptable2.setParentScope(scriptable);
        Object object = ScriptRuntime.getTopLevelProp(scriptable, "Array");
        if (object != null && object instanceof Scriptable) {
            Scriptable scriptable3 = (Scriptable)object;
            scriptable2.setPrototype((Scriptable)scriptable3.get("prototype", scriptable3));
        }
    }

    public Scriptable newObject(Scriptable scriptable) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, "Object", null);
    }

    public Scriptable newObject(Scriptable scriptable, String string) throws PropertyException, NotAFunctionException, JavaScriptException {
        return this.newObject(scriptable, string, null);
    }

    public Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) throws PropertyException, NotAFunctionException, JavaScriptException {
        Object object = ScriptRuntime.getTopLevelProp(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            Object[] objectArray2 = new Object[]{string};
            String string2 = Context.getMessage("msg.ctor.not.found", objectArray2);
            throw new PropertyException(string2);
        }
        if (!(object instanceof Function)) {
            Object[] objectArray3 = new Object[]{string};
            String string3 = Context.getMessage("msg.not.ctor", objectArray3);
            throw new NotAFunctionException(string3);
        }
        Function function = (Function)object;
        return function.construct(this, function.getParentScope(), objectArray == null ? ScriptRuntime.emptyArgs : objectArray);
    }

    public void putThreadLocal(Object object, Object object2) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(object, object2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removeListener(propertyChangeListener);
    }

    public static void reportError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
        } else {
            throw new EvaluatorException(string);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            ++context.errorCount;
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string);
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        context.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public DeepBytecodeHook setBytecodeHook(DeepBytecodeHook deepBytecodeHook) {
        DeepBytecodeHook deepBytecodeHook2 = this.debug_bytecodeHook;
        this.debug_bytecodeHook = deepBytecodeHook;
        return deepBytecodeHook2;
    }

    public static void setCachingEnabled(boolean bl) {
        if (isCachingEnabled && !bl) {
            FunctionObject.methodsCache = null;
            JavaMembers.classTable = null;
        }
        isCachingEnabled = bl;
    }

    public DeepCallHook setCallHook(DeepCallHook deepCallHook) {
        DeepCallHook deepCallHook2 = this.debug_callHook;
        this.debug_callHook = deepCallHook;
        return deepCallHook2;
    }

    public void setCompileFunctionsWithDynamicScope(boolean bl) {
        this.compileFunctionsWithDynamicScopeFlag = bl;
    }

    public int setDebugLevel(int n) {
        int n2 = 0;
        if (n < 0) {
            n = 0;
        } else if (n > 9) {
            n = 9;
        }
        if (n > 0) {
            this.setOptimizationLevel(0);
        }
        return n2;
    }

    public ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.debug_errorReporterHook != null) {
            return this.debug_errorReporterHook.setErrorReporter(errorReporter);
        }
        ErrorReporter errorReporter2 = this.errorReporter;
        if (this.listeners != null && this.errorReporter != errorReporter) {
            this.firePropertyChange(errorReporterProperty, this.errorReporter, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public DeepErrorReporterHook setErrorReporterHook(DeepErrorReporterHook deepErrorReporterHook) {
        DeepErrorReporterHook deepErrorReporterHook2 = this.debug_errorReporterHook;
        this.debug_errorReporterHook = deepErrorReporterHook;
        return deepErrorReporterHook2;
    }

    public DeepExecuteHook setExecuteHook(DeepExecuteHook deepExecuteHook) {
        DeepExecuteHook deepExecuteHook2 = this.debug_executeHook;
        this.debug_executeHook = deepExecuteHook;
        return deepExecuteHook2;
    }

    public void setGeneratingDebug(boolean bl) {
        if (bl) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }

    public void setLanguageVersion(int n) {
        if (this.listeners != null && n != this.version) {
            this.firePropertyChange(languageVersionProperty, new Integer(this.version), new Integer(n));
        }
        this.version = n;
    }

    public Locale setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public DeepNewObjectHook setNewObjectHook(DeepNewObjectHook deepNewObjectHook) {
        DeepNewObjectHook deepNewObjectHook2 = this.debug_newObjectHook;
        this.debug_newObjectHook = deepNewObjectHook;
        return deepNewObjectHook2;
    }

    public void setOptimizationLevel(int n) {
        if (n < 0) {
            n = -1;
        } else if (n > 9) {
            n = 9;
        }
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public DeepScriptHook setScriptHook(DeepScriptHook deepScriptHook) {
        DeepScriptHook deepScriptHook2 = this.debug_scriptHook;
        this.debug_scriptHook = deepScriptHook;
        return deepScriptHook2;
    }

    public SourceTextManager setSourceTextManager(SourceTextManager sourceTextManager) {
        SourceTextManager sourceTextManager2 = this.debug_stm;
        this.debug_stm = sourceTextManager;
        return sourceTextManager2;
    }

    public void setTargetClassFileName(String string) {
        if (nameHelper != null) {
            nameHelper.setTargetClassFileName(string);
        }
    }

    public void setTargetExtends(Class clazz) {
        if (nameHelper != null) {
            nameHelper.setTargetExtends(clazz);
        }
    }

    public void setTargetImplements(Class[] classArray) {
        if (nameHelper != null) {
            nameHelper.setTargetImplements(classArray);
        }
    }

    public void setTargetPackage(String string) {
        if (nameHelper != null) {
            nameHelper.setTargetPackage(string);
        }
    }

    public synchronized boolean stringIsCompilableUnit(String string) {
        StringReader stringReader = new StringReader(string);
        TokenStream tokenStream = new TokenStream(stringReader, null, null, 1);
        DeepErrorReporterHook deepErrorReporterHook = this.setErrorReporterHook(null);
        ErrorReporter errorReporter = this.setErrorReporter(new DefaultErrorReporter());
        boolean bl = false;
        try {
            try {
                IRFactory iRFactory = new IRFactory(tokenStream, null);
                Parser parser = new Parser(iRFactory);
                parser.parse(tokenStream);
            }
            catch (IOException iOException) {
                bl = true;
            }
            catch (EvaluatorException evaluatorException) {
                bl = true;
            }
            Object var8_9 = null;
            this.setErrorReporter(errorReporter);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.setErrorReporter(errorReporter);
            this.setErrorReporterHook(deepErrorReporterHook);
            throw throwable;
        }
        this.setErrorReporterHook(deepErrorReporterHook);
        return !bl || !tokenStream.eof();
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object, null);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable, Class clazz) {
        if (object == null && clazz != null) {
            return null;
        }
        return ScriptRuntime.toObject(scriptable, object, clazz);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }
}

