/*
 * Decompiled with CFR 0.152.
 */
package uk.co.weft.maybeupload;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.co.weft.maybeupload.MaybeUploadRequestWrapper;

public abstract class MaybeUploadServlet
extends HttpServlet {
    protected String uploadDirPath = "/tmp";
    protected String uploadDirURL = null;
    protected boolean allowOverwrite = false;
    protected boolean silentlyRename = true;
    private File uploadDir;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";

    protected void doDelete(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doDelete((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doGet(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doGet((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doHead(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = maybeUploadRequestWrapper.getProtocol();
        String string2 = "HTTP method HEAD not supported";
        if (string.endsWith("1.1")) {
            httpServletResponse.sendError(405, string2);
        } else {
            httpServletResponse.sendError(400, string2);
        }
    }

    protected void doOptions(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doOptions((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doPost(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doPost((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doPut(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doPut((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    protected void doTrace(MaybeUploadRequestWrapper maybeUploadRequestWrapper, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.doTrace((HttpServletRequest)maybeUploadRequestWrapper, httpServletResponse);
    }

    public File getUploadDir() {
        return this.uploadDir;
    }

    public String getUploadURL() {
        return this.uploadDirURL;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getInitParameter("upload_dir_path");
        if (string != null) {
            this.uploadDirPath = string;
        }
        if ((string = servletConfig.getInitParameter("upload_dir_url")) != null) {
            this.uploadDirURL = string;
        }
        if ((string = servletConfig.getInitParameter("allow_overwrite")) != null) {
            this.allowOverwrite = Boolean.valueOf(string);
        }
        if ((string = servletConfig.getInitParameter("silently_rename")) != null) {
            this.silentlyRename = Boolean.valueOf(string);
        }
        this.uploadDir = new File(this.uploadDirPath);
        if (!this.uploadDir.isDirectory() || !this.uploadDir.canWrite()) {
            throw new UnavailableException("Cannot write to upload directory " + this.uploadDirPath);
        }
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        MaybeUploadRequestWrapper maybeUploadRequestWrapper = new MaybeUploadRequestWrapper(httpServletRequest, this.uploadDir, this.allowOverwrite, this.silentlyRename);
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            long l = this.getLastModified(httpServletRequest);
            if (l == -1L) {
                this.doGet(maybeUploadRequestWrapper, httpServletResponse);
            } else {
                long l2 = httpServletRequest.getDateHeader(HEADER_IFMODSINCE);
                if (l2 < l / 1000L * 1000L) {
                    this.maybeSetLastModified(httpServletResponse, l);
                    this.doGet(maybeUploadRequestWrapper, httpServletResponse);
                } else {
                    httpServletResponse.setStatus(304);
                }
            }
        } else if (string.equals(METHOD_HEAD)) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_POST)) {
            this.doPost(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_OPTIONS)) {
            this.doOptions(maybeUploadRequestWrapper, httpServletResponse);
        } else if (string.equals(METHOD_TRACE)) {
            this.doTrace(maybeUploadRequestWrapper, httpServletResponse);
        } else {
            httpServletResponse.sendError(501, new String("HTTP Method [" + string + "] is not implemented"));
        }
    }
}

