/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.component;

import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.ComponentManager;
import org.apache.avalon.Composer;
import org.apache.avalon.Context;
import org.apache.avalon.Contextualizable;
import org.apache.avalon.Disposable;
import org.apache.avalon.Initializable;
import org.apache.avalon.Loggable;
import org.apache.avalon.Startable;
import org.apache.avalon.Stoppable;
import org.apache.avalon.ThreadSafe;
import org.apache.avalon.component.DefaultComponentSelector;
import org.apache.avalon.component.RoleManager;
import org.apache.avalon.configuration.Configurable;
import org.apache.avalon.configuration.Configuration;
import org.apache.excalibur.pool.ObjectFactory;

public class DefaultComponentFactory
extends AbstractLoggable
implements ObjectFactory,
ThreadSafe {
    private Class m_componentClass;
    private Context m_context;
    private ComponentManager m_componentManager;
    private Configuration m_configuration;
    private RoleManager m_roles;

    public Object newInstance() throws Exception {
        Object t = this.m_componentClass.newInstance();
        this.getLogger().debug("ComponentFactory creating new instance of " + this.m_componentClass.getName() + ".");
        if (t instanceof Loggable) {
            ((Loggable)t).setLogger(this.getLogger());
        }
        if (t instanceof Contextualizable) {
            ((Contextualizable)t).contextualize(this.m_context);
        }
        if (t instanceof Composer) {
            ((Composer)t).compose(this.m_componentManager);
        }
        if (t instanceof DefaultComponentSelector) {
            ((DefaultComponentSelector)t).setRoleManager(this.m_roles);
        }
        if (t instanceof Configurable) {
            ((Configurable)t).configure(this.m_configuration);
        }
        if (t instanceof Initializable) {
            ((Initializable)t).init();
        }
        if (t instanceof Startable) {
            ((Startable)t).start();
        }
        return t;
    }

    public final Class getCreatedClass() {
        return this.m_componentClass;
    }

    public final void decommission(Object object) throws Exception {
        this.getLogger().debug("ComponentFactory decommissioning instance of " + this.m_componentClass.getName() + ".");
        if (object instanceof Stoppable) {
            ((Stoppable)object).stop();
        }
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
        }
    }

    public DefaultComponentFactory(Class clazz, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roleManager) {
        this.m_componentClass = clazz;
        this.m_configuration = configuration;
        this.m_componentManager = componentManager;
        this.m_context = context;
        this.m_roles = roleManager;
    }
}

