/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Component;
import org.apache.avalon.ComponentManager;
import org.apache.avalon.Context;
import org.apache.avalon.Contextualizable;
import org.apache.avalon.Disposable;
import org.apache.avalon.component.ComponentException;
import org.apache.avalon.component.DefaultComponentHandler;
import org.apache.avalon.component.DefaultComponentSelector;
import org.apache.avalon.component.DefaultRoleManager;
import org.apache.avalon.component.RoleManager;
import org.apache.avalon.configuration.Configurable;
import org.apache.avalon.configuration.Configuration;
import org.apache.avalon.configuration.ConfigurationException;
import org.apache.avalon.configuration.DefaultConfiguration;

public class DefaultComponentManager
extends AbstractLoggable
implements ComponentManager,
Configurable,
Contextualizable,
Disposable {
    private Context m_context;
    private Map m_componentMapping;
    private Map m_componentHandlers = Collections.synchronizedMap(new HashMap());
    private RoleManager m_roles;
    private boolean m_disposed;

    public void contextualize(Context context) {
        if (this.m_context == null) {
            this.m_context = context;
        }
    }

    public synchronized void dispose() {
        this.m_disposed = true;
        Iterator<Object> iterator = this.m_componentHandlers.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            DefaultComponentHandler defaultComponentHandler = (DefaultComponentHandler)this.m_componentHandlers.get(k);
            defaultComponentHandler.dispose();
            arrayList.add(k);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.m_componentHandlers.remove(iterator.next());
        }
        arrayList.clear();
    }

    public Component lookup(String string) throws ComponentException {
        Object object;
        Object object2;
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed ComponentManager");
        }
        if (string == null) {
            String string2 = "ComponentManager Attempted to retrieve component with null role.";
            this.getLogger().error("ComponentManager Attempted to retrieve component with null role.");
            throw new ComponentException("ComponentManager Attempted to retrieve component with null role.");
        }
        DefaultComponentHandler defaultComponentHandler = (DefaultComponentHandler)this.m_componentHandlers.get(string);
        if (defaultComponentHandler == null) {
            this.getLogger().debug("Could not find ComponentHandler, attempting to create one for role: " + string);
            try {
                object2 = this.m_roles.getDefaultClassNameForRole(string);
                Class<?> clazz = this.getClass().getClassLoader().loadClass((String)object2);
                object = new DefaultConfiguration("", "-");
                defaultComponentHandler = new DefaultComponentHandler(clazz, (Configuration)object, this, this.m_context, this.m_roles);
                defaultComponentHandler.setLogger(this.getLogger());
                defaultComponentHandler.init();
            }
            catch (Exception exception) {
                String string3 = "ComponentManager Could not find component for role: " + string;
                this.getLogger().error(string3, (Throwable)exception);
                throw new ComponentException(string3, exception);
            }
            this.m_componentHandlers.put(string, defaultComponentHandler);
        }
        object2 = null;
        try {
            object2 = defaultComponentHandler.get();
            if (object2 instanceof DefaultComponentSelector) {
                ((DefaultComponentSelector)object2).setRoleManager(this.m_roles);
            }
        }
        catch (IllegalStateException illegalStateException) {
            defaultComponentHandler.init();
            try {
                object2 = defaultComponentHandler.get();
            }
            catch (Exception exception) {
                String string4 = "Could not access the Component for role: " + string;
                throw new ComponentException(string4, exception);
            }
        }
        catch (Exception exception) {
            object = "Could not access the Component for role: " + string;
            throw new ComponentException((String)object, exception);
        }
        this.m_componentMapping.put(object2, defaultComponentHandler);
        return object2;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Object object;
        if (this.m_roles == null) {
            object = new DefaultRoleManager();
            ((AbstractLoggable)object).setLogger(this.getLogger());
            ((DefaultRoleManager)object).configure(configuration);
            this.m_roles = object;
        }
        object = configuration.getChildren();
        int n = 0;
        while (n < ((Object)object).length) {
            String string = object[n].getName();
            if (!string.equals("role")) {
                String string2 = object[n].getAttribute("role", "");
                String string3 = object[n].getAttribute("class", "");
                if (string2.equals("")) {
                    string2 = this.m_roles.getRoleForName(string);
                }
                if (string2 != null && !string2.equals("")) {
                    if (string3.equals("")) {
                        string3 = this.m_roles.getDefaultClassNameForRole(string2);
                    }
                    try {
                        this.getLogger().debug("Adding component (" + string2 + " = " + string3 + ")");
                        Class<?> clazz = this.getClass().getClassLoader().loadClass(string3);
                        this.addComponent(string2, clazz, (Configuration)object[n]);
                    }
                    catch (Exception exception) {
                        String string4 = "Could not get class " + string3 + " for role " + string2 + " on configuration element " + object[n].getName();
                        this.getLogger().error(string4, (Throwable)exception);
                        throw new ConfigurationException(string4, exception);
                    }
                }
            }
            ++n;
        }
    }

    public void setRoleManager(RoleManager roleManager) {
        if (this.m_roles == null) {
            this.m_roles = roleManager;
        }
    }

    public void release(Component component) {
        if (component == null) {
            return;
        }
        DefaultComponentHandler defaultComponentHandler = (DefaultComponentHandler)this.m_componentMapping.get(component);
        if (defaultComponentHandler != null) {
            defaultComponentHandler.put(component);
            this.m_componentMapping.remove(component);
        }
    }

    public void addComponent(String string, Class clazz, Configuration configuration) throws ComponentException {
        try {
            DefaultComponentHandler defaultComponentHandler = new DefaultComponentHandler(clazz, configuration, this, this.m_context, this.m_roles);
            defaultComponentHandler.setLogger(this.getLogger());
            this.m_componentHandlers.put(string, defaultComponentHandler);
        }
        catch (Exception exception) {
            throw new ComponentException("Could not set up Component for role: " + string, exception);
        }
    }

    public void addComponentInstance(String string, Object object) {
        try {
            DefaultComponentHandler defaultComponentHandler = new DefaultComponentHandler((Component)object);
            defaultComponentHandler.setLogger(this.getLogger());
            this.m_componentHandlers.put(string, defaultComponentHandler);
        }
        catch (Exception exception) {
            this.getLogger().warn("Could not set up Component for role: " + string, (Throwable)exception);
        }
    }

    public DefaultComponentManager() {
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }
}

