/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Circuit {
    protected Hashtable m_map = new Hashtable();

    public void addNode(String string) {
        if (this.m_map.get(string) == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            this.m_map.put(string, circuit.new Node(string));
        }
    }

    public void removeNode(String string) {
        String string2 = null;
        Enumeration enumeration = this.m_map.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.equals(string)) continue;
            try {
                this.unlink(string2, string);
            }
            catch (CircuitException circuitException) {
                // empty catch block
            }
            try {
                this.unlink(string, string2);
            }
            catch (CircuitException circuitException) {
                // empty catch block
            }
        }
        this.m_map.remove(string);
    }

    public void link(String string, String string2) throws CircuitException {
        Node node = null;
        Node node2 = (Node)this.m_map.get(string);
        Node node3 = (Node)this.m_map.get(string2);
        if (node2 == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Unknown node " + string);
        }
        if (node3 == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Unknown node " + string2);
        }
        if (node2.isChildOf(node3)) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Loop! Node " + string + " is already child of node " + string2);
        }
        Enumeration enumeration = this.m_map.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            if (!node.isChildOf(node3)) continue;
            node.m_parents.addAll(node2.m_parents);
        }
    }

    public void unlink(String string, String string2) throws CircuitException {
        Node node = (Node)this.m_map.get(string2);
        Node node2 = (Node)this.m_map.get(string);
        if (node.m_parents.contains(node2)) {
            Node node3 = null;
            Enumeration enumeration = this.m_map.elements();
            while (enumeration.hasMoreElements()) {
                node3 = (Node)enumeration.nextElement();
                if (!node3.m_parents.contains(node)) continue;
                node3.m_parents.removeAll(node2.m_parents);
            }
        } else {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Node " + string + " is not parent of node " + string2);
        }
    }

    public Vector getAncestors() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        Node node = null;
        Enumeration enumeration = this.m_map.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            node = (Node)this.m_map.get(string);
            if (1 != node.m_parents.size()) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public String getAncestor() {
        String string = null;
        Node node = null;
        Enumeration enumeration = this.m_map.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            node = (Node)this.m_map.get(string);
            if (1 != node.m_parents.size()) continue;
            return string;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Node node = null;
        Enumeration enumeration = this.m_map.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            node = (Node)this.m_map.get(string);
            stringBuffer.append(string + "(" + (node.m_parents.size() - 1) + ") ");
        }
        return stringBuffer.toString();
    }

    protected final class Node {
        protected Vector m_parents = new Vector(5);
        protected String m_name;

        protected boolean isChildOf(Node node) {
            return this.m_parents.contains(node);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.m_parents.elements();
            stringBuffer.append(this.m_name + "[");
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(((Node)enumeration.nextElement()).m_name + " ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected Node(String string) {
            this.m_parents.addElement(this);
            this.m_name = string;
        }
    }

    public final class CircuitException
    extends RuntimeException {
        public CircuitException() {
        }

        public CircuitException(String string) {
            super(string);
        }
    }
}

