/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.renderable.AffineRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.renderable.RasterRable;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.filter.GraphicsNodeRableFactory;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class SVGFeImageElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public static final String PROTOCOL_DATA = "data:";

    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        Object object;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        SVGElement sVGElement = (SVGElement)element;
        String string = XLinkSupport.getXLinkHref(sVGElement);
        if (string == null) {
            throw new MissingAttributeException(Messages.formatMessage("feImage.xlinkHref.required", null));
        }
        Rectangle2D rectangle2D2 = rectangle2D;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        Filter filter2 = null;
        if (string.startsWith(PROTOCOL_DATA)) {
            filter2 = RasterRable.create(string, null, null);
        } else {
            object = (SVGDocument)element.getOwnerDocument();
            URL uRL = ((SVGOMDocument)object).getURLObject();
            URL uRL2 = null;
            try {
                uRL2 = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalAttributeValueException(Messages.formatMessage("feImage.xlinkHref.badURL", null));
            }
            try {
                URIResolver uRIResolver = new URIResolver((SVGDocument)object, bridgeContext.getDocumentLoader());
                Node node = uRIResolver.getNode(uRL2.toString());
                if (node == null) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("feImage.xlinkHref.badURL", null));
                }
                Element element3 = node.getNodeType() == 9 ? ((SVGDocument)node).getRootElement() : (Element)node;
                if (element3 == null) {
                    throw new IllegalAttributeValueException(Messages.formatMessage("feImage.xlinkHref.badURL", null));
                }
                GraphicsNode graphicsNode2 = bridgeContext.getGVTBuilder().build(bridgeContext, element3);
                GraphicsNodeRableFactory graphicsNodeRableFactory = bridgeContext.getGraphicsNodeRableFactory();
                filter2 = graphicsNodeRableFactory.createGraphicsNodeRable(graphicsNode2, graphicsNodeRenderContext);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(rectangle2D3.getX(), rectangle2D3.getY());
                filter2 = new AffineRable8Bit(filter2, affineTransform);
            }
            catch (Exception exception) {
                filter2 = RasterRable.create(uRL2, null, null);
                Rectangle2D rectangle2D4 = filter2.getBounds2D();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(rectangle2D3.getX(), rectangle2D3.getY());
                affineTransform.scale(rectangle2D3.getWidth() / rectangle2D4.getWidth(), rectangle2D3.getHeight() / rectangle2D4.getHeight());
                affineTransform.translate(-rectangle2D4.getX(), -rectangle2D4.getY());
                filter2 = new AffineRable8Bit(filter2, affineTransform);
            }
        }
        filter2 = new PadRable8Bit(filter2, rectangle2D3, PadMode.ZERO_PAD);
        object = element.getAttributeNS(null, "result");
        if (object != null && ((String)object).trim().length() > 0) {
            map.put(object, filter2);
        }
        return filter2;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

