/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import java.io.StringReader;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory
implements ValueFactory,
ValueConstants {
    protected static final ValueFactory IMMUTABLE_FACTORY = new AbstractValueFactory(null){

        public String getPropertyName() {
            return "";
        }

        public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
            throw CSSDOMExceptionFactory.createDOMException((short)7, "immutable.value", new Object[0]);
        }
    };
    protected Parser parser;

    protected AbstractValueFactory(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public ImmutableValue createValue(String string) throws DOMException {
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(inputSource);
            return this.createValue(lexicalUnit);
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, exception.getMessage(), new Object[0]);
        }
    }

    public void createCSSValue(LexicalUnit lexicalUnit, CSSOMStyleDeclaration cSSOMStyleDeclaration, String string) throws DOMException {
        cSSOMStyleDeclaration.setPropertyCSSValue(this.getPropertyName(), this.createCSSValue(this.createValue(lexicalUnit)), string);
    }

    public ImmutableValue createFloatValue(short s, float f) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)9, "bad.unit.type", new Object[]{new Integer(s)});
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)9, "bad.unit.type", new Object[]{new Integer(s)});
    }

    protected CSSOMValue createCSSValue(ImmutableValue immutableValue) {
        return new CSSOMValue(this, immutableValue);
    }

    public abstract String getPropertyName();

    public abstract ImmutableValue createValue(LexicalUnit var1) throws DOMException;

    protected class URIFactory
    extends AbstractValueFactory {
        public URIFactory(Parser parser) {
            super(parser);
        }

        public String getPropertyName() {
            return null;
        }

        public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
            if (lexicalUnit.getLexicalUnitType() != 24) {
                throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType())});
            }
            return new ImmutableString(20, lexicalUnit.getStringValue());
        }

        public ImmutableValue createStringValue(short s, String string) throws DOMException {
            if (s != 20) {
                throw CSSDOMExceptionFactory.createDOMException((short)9, "bad.unit.type", new Object[]{new Integer(s)});
            }
            return new ImmutableString(s, string);
        }
    }

    protected class StringFactory
    extends AbstractValueFactory {
        public StringFactory(Parser parser) {
            super(parser);
        }

        public String getPropertyName() {
            return null;
        }

        public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
            if (lexicalUnit.getLexicalUnitType() != 36) {
                throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType())});
            }
            return new ImmutableString(19, lexicalUnit.getStringValue());
        }

        public ImmutableValue createStringValue(short s, String string) throws DOMException {
            if (s != 19) {
                throw CSSDOMExceptionFactory.createDOMException((short)9, "bad.unit.type", new Object[]{new Integer(s)});
            }
            return new ImmutableString(s, string);
        }
    }
}

