/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.util.Iterator;
import java.util.Stack;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;

public class GraphicsNodeTreeIterator
implements Iterator {
    GraphicsNode root;
    GraphicsNode current = null;
    Iterator currentIter;
    Stack iterStack;
    Stack nodeStack;
    int icount = 0;

    public GraphicsNodeTreeIterator(GraphicsNode graphicsNode) {
        this.root = graphicsNode;
        if (graphicsNode instanceof CompositeGraphicsNode) {
            this.currentIter = ((CompositeGraphicsNode)graphicsNode).getChildren().iterator();
        }
        this.iterStack = new Stack();
        this.nodeStack = new Stack();
    }

    public boolean hasNext() {
        return this.current != this.root;
    }

    public Object next() {
        if (this.currentIter.hasNext()) {
            this.current = (GraphicsNode)this.currentIter.next();
            while (this.current instanceof CompositeGraphicsNode) {
                this.iterStack.push(this.currentIter);
                this.nodeStack.push(this.current);
                this.currentIter = ((CompositeGraphicsNode)this.current).getChildren().iterator();
                if (this.currentIter.hasNext()) {
                    this.current = (GraphicsNode)this.currentIter.next();
                    continue;
                }
                this.currentIter = (Iterator)this.iterStack.pop();
                this.current = (GraphicsNode)this.nodeStack.pop();
                break;
            }
        } else if (!this.iterStack.empty()) {
            do {
                this.currentIter = (Iterator)this.iterStack.pop();
                this.current = (GraphicsNode)this.nodeStack.pop();
            } while (!this.currentIter.hasNext() && !this.iterStack.isEmpty());
        } else {
            this.current = this.root;
        }
        ++this.icount;
        return this.current;
    }

    public void remove() {
    }
}

