/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageHandlerPNGEncoder
extends AbstractImageHandlerEncoder {
    public static final String USAGE = "java org.apache.batik.svggen.ImageHandlerPNGEncoder <imageDir> <urlRoot>";

    public ImageHandlerPNGEncoder(String string, String string2) {
        super(string, string2);
    }

    public final String getSuffix() {
        return ".png";
    }

    public final String getPrefix() {
        return "pngImage";
    }

    public void encodeImage(BufferedImage bufferedImage, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder((OutputStream)fileOutputStream, null);
            pNGImageEncoder.encode(bufferedImage);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            throw new Error("Could not write imageFile: " + file.getName());
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        ImageHandlerPNGEncoder imageHandlerPNGEncoder = new ImageHandlerPNGEncoder(string, string2);
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "image");
        BufferedImage bufferedImage = new BufferedImage(60, 40, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.green);
        graphics2D.fillRect(0, 0, 20, 40);
        graphics2D.setPaint(Color.red);
        graphics2D.fillRect(40, 0, 60, 40);
        graphics2D.dispose();
        imageHandlerPNGEncoder.handleImage(bufferedImage, element);
        System.out.println("Generated xlink:href is : " + element.getAttributeNS(null, "xlink:href"));
        System.exit(0);
    }
}

