/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.Ellipse2D;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGEllipse
extends SVGGraphicObjectConverter {
    public SVGEllipse(Document document) {
        super(document);
    }

    public Element toSVG(Ellipse2D ellipse2D) {
        if (ellipse2D.getWidth() == ellipse2D.getHeight()) {
            return this.toSVGCircle(ellipse2D);
        }
        return this.toSVGEllipse(ellipse2D);
    }

    private Element toSVGCircle(Ellipse2D ellipse2D) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "circle");
        element.setAttributeNS(null, "cx", SVGGraphicObjectConverter.doubleString(ellipse2D.getX() + ellipse2D.getWidth() / 2.0));
        element.setAttributeNS(null, "cy", SVGGraphicObjectConverter.doubleString(ellipse2D.getY() + ellipse2D.getHeight() / 2.0));
        element.setAttributeNS(null, "r", SVGGraphicObjectConverter.doubleString(ellipse2D.getWidth() / 2.0));
        return element;
    }

    private Element toSVGEllipse(Ellipse2D ellipse2D) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "ellipse");
        element.setAttributeNS(null, "cx", SVGGraphicObjectConverter.doubleString(ellipse2D.getX() + ellipse2D.getWidth() / 2.0));
        element.setAttributeNS(null, "cy", SVGGraphicObjectConverter.doubleString(ellipse2D.getY() + ellipse2D.getHeight() / 2.0));
        element.setAttributeNS(null, "rx", SVGGraphicObjectConverter.doubleString(ellipse2D.getWidth() / 2.0));
        element.setAttributeNS(null, "ry", SVGGraphicObjectConverter.doubleString(ellipse2D.getHeight() / 2.0));
        return element;
    }

    public static void main(String[] stringArray) throws Exception {
        Ellipse2D[] ellipse2DArray = new Ellipse2D[]{new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 100.0f), new Ellipse2D.Double(40.0, 40.0, 240.0, 240.0), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 200.0f), new Ellipse2D.Float(40.0f, 100.0f, 240.0f, 200.0f)};
        Document document = TestUtil.getDocumentPrototype();
        SVGEllipse sVGEllipse = new SVGEllipse(document);
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < ellipse2DArray.length) {
            element.appendChild(sVGEllipse.toSVG(ellipse2DArray[n]));
            ++n;
        }
        TestUtil.trace(element, System.out);
    }
}

