/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Iterator;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLinearGradient
extends AbstractSVGConverter {
    public SVGLinearGradient(Document document) {
        super(document);
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return this.toSVG((GradientPaint)paint);
    }

    public SVGPaintDescriptor toSVG(GradientPaint gradientPaint) {
        SVGPaintDescriptor sVGPaintDescriptor = (SVGPaintDescriptor)this.descMap.get(gradientPaint);
        if (sVGPaintDescriptor == null) {
            Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
            element.setAttributeNS(null, "gradientUnits", "userSpaceOnUse");
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            element.setAttributeNS(null, "x1", "" + AbstractSVGConverter.doubleString(point2D.getX()));
            element.setAttributeNS(null, "y1", "" + AbstractSVGConverter.doubleString(point2D.getY()));
            element.setAttributeNS(null, "x2", "" + AbstractSVGConverter.doubleString(point2D2.getX()));
            element.setAttributeNS(null, "y2", "" + AbstractSVGConverter.doubleString(point2D2.getY()));
            String string = "pad";
            if (gradientPaint.isCyclic()) {
                string = "reflect";
            }
            element.setAttributeNS(null, "spreadMethod", string);
            Element element2 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "stop");
            element2.setAttributeNS(null, "offset", "0%");
            SVGPaintDescriptor sVGPaintDescriptor2 = SVGColor.toSVG(gradientPaint.getColor1());
            element2.setAttributeNS(null, "stop-color", sVGPaintDescriptor2.getPaintValue());
            element2.setAttributeNS(null, "stop-opacity", sVGPaintDescriptor2.getOpacityValue());
            element.appendChild(element2);
            element2 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "stop");
            element2.setAttributeNS(null, "offset", "100%");
            sVGPaintDescriptor2 = SVGColor.toSVG(gradientPaint.getColor2());
            element2.setAttributeNS(null, "stop-color", sVGPaintDescriptor2.getPaintValue());
            element2.setAttributeNS(null, "stop-opacity", sVGPaintDescriptor2.getOpacityValue());
            element.appendChild(element2);
            element.setAttributeNS(null, "id", SVGIDGenerator.generateID("linearGradient"));
            StringBuffer stringBuffer = new StringBuffer("url(");
            stringBuffer.append("#");
            stringBuffer.append(element.getAttributeNS(null, "id"));
            stringBuffer.append(")");
            sVGPaintDescriptor = new SVGPaintDescriptor(stringBuffer.toString(), "1", element);
            this.descMap.put(gradientPaint, sVGPaintDescriptor);
            this.defSet.add(element);
        }
        return sVGPaintDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Element element;
        Document document = TestUtil.getDocumentPrototype();
        GradientPaint gradientPaint = new GradientPaint(20.0f, 20.0f, Color.black, 300.0f, 300.0f, new Color(220, 230, 240), true);
        SVGLinearGradient sVGLinearGradient = new SVGLinearGradient(document);
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        SVGPaintDescriptor sVGPaintDescriptor = sVGLinearGradient.toSVG(gradientPaint);
        Iterator iterator = sVGLinearGradient.getDefinitionSet().iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            element3.appendChild(element);
        }
        element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        element.setAttributeNS(null, "fill", sVGPaintDescriptor.getPaintValue());
        element.setAttributeNS(null, "fill-opacity", sVGPaintDescriptor.getOpacityValue());
        element2.appendChild(element3);
        element2.appendChild(element);
        TestUtil.trace(element2, System.out);
    }
}

