#
# Note that this is NOT a relocatable package
#
%define ver      0.98rc1
%define rel      1
%define prefix   /usr/local
%define name	 exult
%define bindir	 ${exec_prefix}/bin
%define datadir	 ${prefix}/share
%define gimpdir  

Summary: Ultima VII Engine
Name: %name
Version: %ver
Release: %rel
Copyright: GPL
Group: Amusements/Games
Source: http://download.sourceforge.net/projects/exult/exult-%{ver}.tar.gz
BuildRoot: /var/tmp/exult
Obsoletes: exult
Packager: Tristan Tarrant <nadir@users.sourceforge.net>
URL: http://exult.sourceforge.net
Prereq: /sbin/install-info
Prefix: %{prefix}
Docdir: %{prefix}/doc

%description
Exult: an implementation of the Ultima VII engine for modern Operating Systems.

%package tools
Summary: Tools and utilities for playing with Exult/Ultima VII data files
Group: Amusements/Games

%description tools
Exult Tools: a set of utilities for playing with Exult/Ultima VII data files.
Included in the tools are: expack (archiver), ucxt (decompiler), ucc (compiler),
splitshp (frame splitter), shp2pcx (shape converter)

%package gimp-plugin
Summary: A GIMP plugin for loading/saving SHP files
Group: Applications/Graphics

%description gimp-plugin
Exult GIMP Plugin: a file plugin for the GIMP which allows loading and saving 
of Ultima VII SHP files. 

%package studio
Summary: A GTK+-based environment for editing Exult worlds
Group: Amusements/Games

%description studio
ExultStudio: a GTK+-based environment for editing Exult worlds

%changelog

* Wed Dec 05 2001  Tristan Tarrant <nadir@users.sourceforge.net>

- subpackages are here !!!

* Thu Nov 29 2001  Tristan Tarrant <nadir@users.sourceforge.net>

- allow setting of bindir and datadir
- build exult only (will be fixed with the addition of subpackages)
- added README.1ST
- optimizer flags should be set for CXXFLAGS too

* Mon Jun 25 2001  Willem Jan Palenstijn <wjpalenstijn@users.sourceforge.net>

- added exult_bg.flx, exult_si.flx
- removed explicit SDL req. (proper SDL version is added automatically)

* Tue Nov 7 2000  Tristan Tarrant <nadir@users.sourceforge.net>

- A few fixes

* Sat Sep 9 2000  Tristan Tarrant <nadir@users.sourceforge.net>

- Install exult.flx in the right place

* Tue Jul 11 2000  Tristan Tarrant <nadir@users.sourceforge.net>

- Created the .spec file

* Fri Feb 9 2000  Tristan Tarrant <nadir@users.sourceforge.net>

- Disable GIMP plugin by default.
- Include FAQ
%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  ./autogen.sh
fi
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --bindir=%bindir --datadir=%datadir --sysconfdir=$RPM_BUILD_ROOT/etc --enable-gimp-plugin --enable-exult-studio-support --enable-tools --enable-exult-studio

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} bindir=$RPM_BUILD_ROOT%{bindir} datadir=$RPM_BUILD_ROOT%{datadir} GIMP_PLUGIN_PREFIX=$RPM_BUILD_ROOT%{gimpdir} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README FAQ README.1ST
%{bindir}/exult
%{datadir}/exult/exult_bg.flx
%{datadir}/exult/exult_si.flx
%{datadir}/exult/midisfx.flx
%{datadir}/exult/exult.flx

%files tools
%defattr(-, root, root)
%doc tools/expack.txt
%{bindir}/expack
%{bindir}/ucxt
%{bindir}/ucc
%{bindir}/splitshp
%{bindir}/shp2pcx
%{datadir}/exult/opcodes.txt

%files gimp-plugin
%defattr(-, root, root)
%{gimpdir}/u7shp

%files studio
%defattr(-, root, root)
%{bindir}/exult_studio
%{datadir}/exult/exult_studio.glade
