package com.ibm.bsf.util.event.generator;

import java.util.*;;

public class AdapterClassLoader extends ClassLoader
{
  private static Hashtable classCache = new Hashtable();
  private Class c;

  public AdapterClassLoader()
  {
    super();
  }

  // Not in JDK 1.1, only in JDK 1.2.
//  public AdapterClassLoader(ClassLoader loader)
//  {
//    super(loader);
//  }

  final protected void put(String name, Class c)
  {
    classCache.put(name, c);
  }

  final protected Class get(String name)
  {
    return (Class)classCache.get(name);
  }

  public synchronized Class defineClass(String name, byte[] b)
  {
    if ((c = getLoadedClass(name)) == null)
    {
      c = defineClass(name, b, 0, b.length);
      put(name, c);
    }
    else
    {
      System.err.println("AdapterClassLoader: " + c +
                         " previously loaded. Can not redefine class.");
    }

    return c;
  }

  public synchronized Class getLoadedClass(String name)
  {
    Class c = findLoadedClass(name);

    if (c == null)
    {
      try
      {
        c = findSystemClass(name);
      }
      catch (ClassNotFoundException e)
      {
      }
    }

    if (c == null)
    {
      c = findClass(name);
    }

    return c;
  }

  final protected Class findClass(String name)
  {
    return get(name);
  }

  protected synchronized Class loadClass(String name, boolean resolve)
    throws ClassNotFoundException
  {
    Class c = getLoadedClass(name);

    if (c != null && resolve)
    {
      resolveClass(c);
    }

    return c;
  }
}