/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.activescript;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.engines.activescript.COMIDispatchBean;
import com.ibm.bsf.engines.activescript.JavaBean;
import com.ibm.bsf.engines.activescript.JavaBeanAddEventListener;
import com.ibm.bsf.engines.activescript.vbEmpty;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.EngineUtils;
import java.util.Hashtable;
import java.util.Vector;

public class ActiveScriptEngine
extends BSFEngineImpl
implements JavaBeanAddEventListener {
    static BSFException dllLoadException = null;
    static final String libName = "bsfactivescriptengine";
    static final String LANG_VBSCRIPT = "vbscript";
    static final String LANG_PERLSCRIPT = "perlscript";
    static final String LANG_JSCRIPT = "jscript";
    byte[] css = null;
    BSFManager bsfmgr = null;
    private Hashtable evalRet = null;
    protected String lang = null;

    static {
        try {
            System.loadLibrary(libName);
        }
        catch (SecurityException securityException) {
            dllLoadException = new BSFException(BSFException.REASON_OTHER_ERROR, "SecurityException loading library:bsfactivescriptengine " + securityException.getMessage(), securityException);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            dllLoadException = new BSFException(BSFException.REASON_OTHER_ERROR, "UnsatisfiedLinkError loading library:bsfactivescriptengine " + unsatisfiedLinkError.getMessage(), unsatisfiedLinkError);
        }
    }

    public void addEventListener(Object object, String string, String string2, String string3) throws BSFException {
        EngineUtils.addEventListener(object, string, string2, this, this.bsfmgr, "ActiveScriptEngine", 0, 0, string3);
    }

    public final int bindMember(Object object, String string, short s) throws Exception {
        return JavaBean.bindMember(object.getClass(), string, s);
    }

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(object.toString());
        stringBuffer.append(".");
        stringBuffer.append(string);
        stringBuffer.append("(");
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n].toString());
                if (n < objectArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        stringBuffer.append(")");
        return this.eval("<internal>", -1, -1, stringBuffer.toString());
    }

    private final Object callBeanMethod(Object object, String string, Object[] objectArray) throws BSFException {
        if (object.equals(this) && string.equals("callMethodViaBSF")) {
            return this.callMethodViaBSF((Object[])objectArray[0]);
        }
        if (object.equals(this) && string.equals("createBean")) {
            return this.createBean((Object[])objectArray[0]);
        }
        return EngineUtils.callBeanMethod(object, string, objectArray);
    }

    public final Object callMethod(Object object, int n, Object[] objectArray) throws Exception {
        return JavaBean.callMethod(this, object, n, objectArray);
    }

    final Object callMethodViaBSF(Object[] objectArray) throws BSFException {
        Object[] objectArray2 = new Object[objectArray.length - 2];
        if (objectArray.length > 2) {
            System.arraycopy(objectArray, 2, objectArray2, 0, objectArray.length - 2);
        }
        return EngineUtils.callBeanMethod(objectArray[0], (String)objectArray[1], objectArray2);
    }

    public static final Throwable createBSFException(int n, String string, Throwable throwable) {
        if (throwable != null) {
            return new BSFException(n, string, throwable);
        }
        return new BSFException(n, string);
    }

    public final Object createBean(Object[] objectArray) throws BSFException {
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (objectArray.length > 1) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        }
        return EngineUtils.createBean((String)objectArray[0], objectArray2);
    }

    public final void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.isVBScript()) {
            this.exec("<declareBean>", 0, 0, "SET " + bSFDeclaredBean.name + "=bsf.lookupBean(\"" + bSFDeclaredBean.name + "\") 'via declareBean");
        } else if (this.isJScript()) {
            this.exec("<declareBean>", 0, 0, "var " + bSFDeclaredBean.name + "=bsf.lookupBean(\"" + bSFDeclaredBean.name + "\"); //via declareBean");
        } else if (this.isPerlScript()) {
            this.exec("<declareBean>", 0, 0, "$" + bSFDeclaredBean.name + "=$bsf->lookupBean('" + bSFDeclaredBean.name + "'); #via declareBean");
        } else {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, String.valueOf(this.lang) + " does not support declareBean.");
        }
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        if (!this.isPerlScript()) {
            return this.nativeEval(this.css, string, n, n2, object.toString(), true);
        }
        Integer n3 = new Integer(Thread.currentThread().hashCode());
        this.nativeEval(this.css, "<bsf perl declare>", n, n2, "$bsf->setEvalRet(" + object.toString() + "); #via eval", false);
        Object v = this.evalRet.get(n3);
        if (v == this.evalRet) {
            v = null;
        }
        this.evalRet.put(n3, this.evalRet);
        return v;
    }

    public void exec(String string, int n, int n2, Object object) throws BSFException {
        ActiveScriptEngine activeScriptEngine = this;
        synchronized (activeScriptEngine) {
            if (this.terminated()) {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "Exec or eval called after engine termination!");
            }
        }
        this.nativeEval(this.css, string, n, n2, object.toString(), false);
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        if (dllLoadException != null) {
            throw dllLoadException;
        }
        Object object = this;
        synchronized (object) {
            if (this.lang != null) {
                this.lang = string;
                throw new BSFException(BSFException.REASON_OTHER_ERROR, "Engine " + this + " initialized again");
            }
            this.lang = string;
        }
        super.initialize(bSFManager, string, vector);
        if (this.isPerlScript()) {
            this.evalRet = new Hashtable();
        }
        this.bsfmgr = bSFManager;
        this.nativeInit(this.lang, null, null);
        if (this.css == null) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "Engine " + this + " failed to initialize native interface properly.");
        }
        if (vector.size() != 0) {
            object = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (this.isVBScript()) {
                object = "SET ";
                string2 = "=bsf.lookupBean(\"";
                string3 = "\")";
                string4 = ":";
                string5 = "";
            } else if (this.isJScript()) {
                object = "var ";
                string2 = "=bsf.lookupBean(\"";
                string3 = "\")";
                string5 = string4 = ";";
            } else if (this.isPerlScript()) {
                object = "$";
                string2 = "=$bsf->lookupBean('";
                string3 = "')";
                string5 = string4 = ";";
            } else {
                throw new BSFException(BSFException.REASON_OTHER_ERROR, String.valueOf(this.lang) + " does not support undeclareBean.");
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                BSFDeclaredBean bSFDeclaredBean = (BSFDeclaredBean)vector.elementAt(n2);
                stringBuffer.append(String.valueOf(object) + bSFDeclaredBean.name + string2 + bSFDeclaredBean.name + string3 + (n2 < n - 1 ? string4 : string5));
                ++n2;
            }
            this.exec("<declareBean>", 0, 0, stringBuffer.toString());
        }
    }

    protected final boolean isCaseSensitive() {
        return this.isVBScript();
    }

    protected final boolean isJScript() {
        return this.lang.equalsIgnoreCase(LANG_JSCRIPT);
    }

    protected final boolean isPerlScript() {
        return this.lang.equalsIgnoreCase(LANG_PERLSCRIPT);
    }

    protected final boolean isVBScript() {
        return this.lang.equalsIgnoreCase(LANG_VBSCRIPT);
    }

    public final Object lookupBean(String string) {
        return this.bsfmgr.lookupBean(string);
    }

    private native Object nativeEval(byte[] var1, String var2, int var3, int var4, String var5, boolean var6) throws BSFException;

    static native void nativeIdispatchAddRef(byte[] var0) throws BSFException;

    static native void nativeIdispatchDeleteRef(byte[] var0) throws BSFException;

    private native void nativeInit(String var1, String var2, Object[] var3) throws BSFException;

    private native byte[] nativeObjectToVariant(byte[] var1, Object var2) throws BSFException;

    private native byte[] nativeStingToBString(String var1) throws BSFException;

    private native void nativeTerminate(byte[] var1);

    private final byte[] objectToVariant(Object object) throws BSFException {
        byte[] byArray = new byte[16];
        if (object == null) {
            byArray[0] = 1;
            byArray[1] = 0;
        } else if (object instanceof Boolean) {
            byte by;
            byArray[0] = 11;
            byArray[1] = 0;
            byArray[8] = by = (byte)((Boolean)object != false ? 255 : 0);
            byArray[9] = by;
            byArray[10] = by;
            byArray[11] = by;
        } else if (object instanceof Integer) {
            byArray[0] = 3;
            byArray[1] = 0;
            int n = (Integer)object;
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof String) {
            byArray[0] = 8;
            byArray[1] = 0;
        } else if (object instanceof Long) {
            byArray[0] = 5;
            byArray[1] = 0;
            long l = Double.doubleToLongBits(((Long)object).longValue());
            byArray[8] = (byte)l;
            byArray[9] = (byte)(l >>> 8 & 0xFFL);
            byArray[10] = (byte)(l >>> 16 & 0xFFL);
            byArray[11] = (byte)(l >>> 24 & 0xFFL);
            byArray[12] = (byte)(l >>> 32 & 0xFFL);
            byArray[13] = (byte)(l >>> 40 & 0xFFL);
            byArray[14] = (byte)(l >>> 48 & 0xFFL);
            byArray[15] = (byte)(l >>> 56 & 0xFFL);
        } else if (object instanceof Short) {
            byArray[0] = 2;
            byArray[1] = 0;
            int n = ((Short)object).intValue();
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof Float) {
            byArray[0] = 4;
            byArray[1] = 0;
            int n = Float.floatToIntBits(((Float)object).floatValue());
            byArray[8] = (byte)n;
            byArray[9] = (byte)(n >>> 8 & 0xFF);
            byArray[10] = (byte)(n >>> 16 & 0xFF);
            byArray[11] = (byte)(n >>> 24 & 0xFF);
        } else if (object instanceof Double) {
            byArray[0] = 5;
            byArray[1] = 0;
            long l = Double.doubleToLongBits((Double)object);
            byArray[8] = (byte)l;
            byArray[9] = (byte)(l >>> 8 & 0xFFL);
            byArray[10] = (byte)(l >>> 16 & 0xFFL);
            byArray[11] = (byte)(l >>> 24 & 0xFFL);
            byArray[12] = (byte)(l >>> 32 & 0xFFL);
            byArray[13] = (byte)(l >>> 40 & 0xFFL);
            byArray[14] = (byte)(l >>> 48 & 0xFFL);
            byArray[15] = (byte)(l >>> 56 & 0xFFL);
        } else if (object instanceof Byte) {
            byte by;
            byArray[0] = 17;
            byArray[1] = 0;
            byArray[8] = by = ((Byte)object).byteValue();
        } else if (object instanceof Character) {
            byte by;
            byArray[0] = 17;
            byArray[1] = 0;
            byArray[8] = by = (byte)((Character)object).charValue();
        } else if (object instanceof Void) {
            byArray[0] = 1;
            byArray[1] = 0;
        } else if (object.getClass().isArray()) {
            ArrayInfo arrayInfo = new ArrayInfo(object);
            byArray = arrayInfo.toVariant();
        } else {
            byArray[0] = 9;
            byArray[1] = 0;
            byte[] byArray2 = null;
            if (object instanceof COMIDispatchBean) {
                byArray2 = ((COMIDispatchBean)object).getIDispatchInterface();
                System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
            } else if (object instanceof vbEmpty) {
                byArray[0] = 0;
                byArray[1] = 0;
            } else {
                byArray2 = this.nativeObjectToVariant(this.css, object);
                System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
            }
        }
        return byArray;
    }

    public final void setEvalRet(Object object) {
        this.evalRet.put(new Integer(Thread.currentThread().hashCode()), object != null ? object : this.evalRet);
    }

    public synchronized void terminate() {
        if (!this.terminated()) {
            byte[] byArray = this.css;
            this.css = null;
            this.bsfmgr = null;
            this.evalRet = null;
            this.lang = null;
            this.nativeTerminate(byArray);
            super.terminate();
        }
    }

    private final boolean terminated() {
        return this.css == null;
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        if (this.isVBScript()) {
            this.exec("<undeclareBean>", 0, 0, "SET " + bSFDeclaredBean.name + "=Nothing 'via undeclareBean");
        } else if (this.isJScript()) {
            this.exec("<undeclareBean>", 0, 0, String.valueOf(bSFDeclaredBean.name) + "=null; // via undeclareBean");
        } else if (this.isPerlScript()) {
            this.exec("<undeclareBean>", 0, 0, "undef " + bSFDeclaredBean.name + " ; #via undeclareBean");
        } else {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, String.valueOf(this.lang) + " does not support undeclareBean.");
        }
    }

    class ArrayInfo {
        protected Object arrayObject = null;
        protected boolean investigated = false;
        public int maxDepth = 0;
        public char type = '\u0000';
        public int[] maxDimArray = null;
        public int[] dimOffset = null;

        ArrayInfo(Object object) {
            if (object.getClass().isArray()) {
                String string = object.getClass().toString();
                this.maxDepth = string.indexOf(91);
                if (this.maxDepth != -1) {
                    this.arrayObject = object;
                    string = string.substring(this.maxDepth);
                    this.maxDepth = 0;
                    while (string.charAt(this.maxDepth) == '[') {
                        ++this.maxDepth;
                    }
                    this.type = string.charAt(this.maxDepth);
                    this.maxDimArray = new int[this.maxDepth];
                    this.dimOffset = new int[this.maxDepth];
                    this.investigate(object, 0);
                    this.dimOffset[0] = 1;
                    int n = 1;
                    while (n < this.maxDepth) {
                        this.dimOffset[n] = this.dimOffset[n - 1] * this.maxDimArray[n - 1];
                        ++n;
                    }
                }
            }
        }

        protected void investigate(Object object, int n) {
            block26: {
                int n2;
                block25: {
                    if (this.investigated) {
                        return;
                    }
                    if (object == null) {
                        return;
                    }
                    if ((n2 = ++n) != this.maxDepth) break block25;
                    switch (this.type) {
                        case 'Z': {
                            boolean[] blArray = (boolean[])object;
                            if (blArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = blArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'B': {
                            byte[] byArray = (byte[])object;
                            if (byArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = byArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'C': {
                            char[] cArray = (char[])object;
                            if (cArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = cArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'S': {
                            short[] sArray = (short[])object;
                            if (sArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = sArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'I': {
                            int[] nArray = (int[])object;
                            if (nArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = nArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'J': {
                            long[] lArray = (long[])object;
                            if (lArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = lArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'F': {
                            float[] fArray = (float[])object;
                            if (fArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = fArray.length;
                                break;
                            }
                            break block26;
                        }
                        case 'D': {
                            double[] dArray = (double[])object;
                            if (dArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = dArray.length;
                                break;
                            }
                            break block26;
                        }
                        default: {
                            Object[] objectArray = (Object[])object;
                            if (objectArray.length > this.maxDimArray[n2 - 1]) {
                                this.maxDimArray[n2 - 1] = objectArray.length;
                                break;
                            }
                            break block26;
                        }
                    }
                    break block26;
                }
                Object[] objectArray = (Object[])object;
                if (objectArray.length > this.maxDimArray[n - 1]) {
                    this.maxDimArray[n - 1] = objectArray.length;
                }
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3].getClass().isArray()) {
                        this.investigate(objectArray[n3], n2);
                    }
                    ++n3;
                }
            }
            if (n == 1) {
                this.investigated = true;
            }
        }

        private int setVariantData(Object object, byte[] byArray, int n, int n2, int[] nArray) throws BSFException {
            if (++n2 != this.maxDepth) {
                Object[] objectArray = (Object[])object;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3] != null) {
                        nArray[n2 - 1] = n3;
                        int n4 = n2;
                        while (n4 < this.maxDepth) {
                            nArray[n4++] = 0;
                        }
                        this.setVariantData(objectArray[n3], byArray, n, n2, nArray);
                    }
                    ++n3;
                }
            } else {
                switch (this.type) {
                    case 'Z': {
                        int n5;
                        boolean[] blArray = (boolean[])object;
                        int n6 = n;
                        int n7 = 0;
                        while (n7 < n2 - 1) {
                            n6 += nArray[n7] * this.dimOffset[n7] * 16;
                            ++n7;
                        }
                        int n8 = 0;
                        while (n8 < blArray.length) {
                            byte by;
                            n5 = n6 + n8 * this.dimOffset[n2 - 1] * 16;
                            byArray[n5] = 11;
                            byArray[n5 + 1] = 0;
                            byArray[n5 + 2] = by = (byte)(blArray[n8] ? 255 : 0);
                            byArray[n5 + 3] = by;
                            byArray[n5 + 4] = by;
                            byArray[n5 + 5] = by;
                            ++n8;
                        }
                        while (n8 < this.maxDimArray[n2 - 1]) {
                            n5 = n6 + n8 * this.dimOffset[n2 - 1] * 16;
                            byArray[n5 + 1] = 0;
                            byArray[n5] = 0;
                            ++n8;
                        }
                        break;
                    }
                    case 'B': {
                        int n9;
                        byte[] byArray2 = (byte[])object;
                        int n10 = n;
                        int n11 = 0;
                        while (n11 < n2 - 1) {
                            n10 += nArray[n11] * this.dimOffset[n11] * 16;
                            ++n11;
                        }
                        int n12 = 0;
                        while (n12 < byArray2.length) {
                            n9 = n10 + n12 * this.dimOffset[n2 - 1] * 16;
                            byArray[n9] = 17;
                            byArray[n9 + 1] = 0;
                            byte by = byArray2[n12];
                            byArray[n9 + 8] = by;
                            byArray[n9 + 11] = 0;
                            byArray[n9 + 10] = 0;
                            byArray[n9 + 9] = 0;
                            ++n12;
                        }
                        while (n12 < this.maxDimArray[n2 - 1]) {
                            n9 = n10 + n12 * this.dimOffset[n2 - 1] * 16;
                            byArray[n9 + 1] = 0;
                            byArray[n9] = 0;
                            ++n12;
                        }
                        break;
                    }
                    case 'C': {
                        int n13;
                        char[] cArray = (char[])object;
                        int n14 = n;
                        int n15 = 0;
                        while (n15 < n2 - 1) {
                            n14 += nArray[n15] * this.dimOffset[n15] * 16;
                            ++n15;
                        }
                        int n16 = 0;
                        while (n16 < cArray.length) {
                            byte by;
                            n13 = n14 + n16 * this.dimOffset[n2 - 1] * 16;
                            byArray[n13] = 17;
                            byArray[n13 + 1] = 0;
                            byArray[n13 + 8] = by = (byte)((Character)object).charValue();
                            byArray[n13 + 11] = 0;
                            byArray[n13 + 10] = 0;
                            byArray[n13 + 9] = 0;
                            ++n16;
                        }
                        while (n16 < this.maxDimArray[n2 - 1]) {
                            n13 = n14 + n16 * this.dimOffset[n2 - 1] * 16;
                            byArray[n13 + 1] = 0;
                            byArray[n13] = 0;
                            ++n16;
                        }
                        break;
                    }
                    case 'S': {
                        int n17;
                        short[] sArray = (short[])object;
                        int n18 = n;
                        int n19 = 0;
                        while (n19 < n2 - 1) {
                            n18 += nArray[n19] * this.dimOffset[n19] * 16;
                            ++n19;
                        }
                        int n20 = 0;
                        while (n20 < sArray.length) {
                            n17 = n18 + n20 * this.dimOffset[n2 - 1] * 16;
                            byArray[n17] = 2;
                            byArray[n17 + 1] = 0;
                            short s = sArray[n20];
                            byArray[n17 + 8] = (byte)s;
                            byArray[n17 + 9] = (byte)(s >>> 8 & 0xFF);
                            byArray[n17 + 10] = (byte)(s >>> 16 & 0xFF);
                            byArray[n17 + 11] = (byte)(s >>> 24 & 0xFF);
                            ++n20;
                        }
                        while (n20 < this.maxDimArray[n2 - 1]) {
                            n17 = n18 + n20 * this.dimOffset[n2 - 1] * 16;
                            byArray[n17 + 1] = 0;
                            byArray[n17] = 0;
                            ++n20;
                        }
                        break;
                    }
                    case 'I': {
                        int n21;
                        int[] nArray2 = (int[])object;
                        int n22 = n;
                        int n23 = 0;
                        while (n23 < n2 - 1) {
                            n22 += nArray[n23] * this.dimOffset[n23] * 16;
                            ++n23;
                        }
                        int n24 = 0;
                        while (n24 < nArray2.length) {
                            n21 = n22 + n24 * this.dimOffset[n2 - 1] * 16;
                            byArray[n21] = 3;
                            byArray[n21 + 1] = 0;
                            int n25 = nArray2[n24];
                            byArray[n21 + 8] = (byte)n25;
                            byArray[n21 + 9] = (byte)(n25 >>> 8 & 0xFF);
                            byArray[n21 + 10] = (byte)(n25 >>> 16 & 0xFF);
                            byArray[n21 + 11] = (byte)(n25 >>> 24 & 0xFF);
                            ++n24;
                        }
                        while (n24 < this.maxDimArray[n2 - 1]) {
                            n21 = n22 + n24 * this.dimOffset[n2 - 1] * 16;
                            byArray[n21 + 1] = 0;
                            byArray[n21] = 0;
                            ++n24;
                        }
                        break;
                    }
                    case 'J': {
                        int n26;
                        long[] lArray = (long[])object;
                        int n27 = n;
                        int n28 = 0;
                        while (n28 < n2 - 1) {
                            n27 += nArray[n28] * this.dimOffset[n28] * 16;
                            ++n28;
                        }
                        int n29 = 0;
                        while (n29 < lArray.length) {
                            n26 = n27 + n29 * this.dimOffset[n2 - 1] * 16;
                            byArray[n26] = 5;
                            byArray[n26 + 1] = 0;
                            long l = Double.doubleToLongBits(lArray[n29]);
                            byArray[n26 + 8] = (byte)l;
                            byArray[n26 + 9] = (byte)(l >>> 8 & 0xFFL);
                            byArray[n26 + 10] = (byte)(l >>> 16 & 0xFFL);
                            byArray[n26 + 11] = (byte)(l >>> 24 & 0xFFL);
                            byArray[n26 + 12] = (byte)(l >>> 32 & 0xFFL);
                            byArray[n26 + 13] = (byte)(l >>> 40 & 0xFFL);
                            byArray[n26 + 14] = (byte)(l >>> 48 & 0xFFL);
                            byArray[n26 + 15] = (byte)(l >>> 56 & 0xFFL);
                            ++n29;
                        }
                        while (n29 < this.maxDimArray[n2 - 1]) {
                            n26 = n27 + n29 * this.dimOffset[n2 - 1] * 16;
                            byArray[n26 + 1] = 0;
                            byArray[n26] = 0;
                            ++n29;
                        }
                        break;
                    }
                    case 'F': {
                        int n30;
                        float[] fArray = (float[])object;
                        int n31 = n;
                        int n32 = 0;
                        while (n32 < n2 - 1) {
                            n31 += nArray[n32] * this.dimOffset[n32] * 16;
                            ++n32;
                        }
                        int n33 = 0;
                        while (n33 < fArray.length) {
                            n30 = n31 + n33 * this.dimOffset[n2 - 1] * 16;
                            byArray[n30] = 4;
                            byArray[n30 + 1] = 0;
                            int n34 = Float.floatToIntBits(fArray[n33]);
                            byArray[n30 + 8] = (byte)n34;
                            byArray[n30 + 9] = (byte)(n34 >>> 8 & 0xFF);
                            byArray[n30 + 10] = (byte)(n34 >>> 16 & 0xFF);
                            byArray[n30 + 11] = (byte)(n34 >>> 24 & 0xFF);
                            ++n33;
                        }
                        while (n33 < this.maxDimArray[n2 - 1]) {
                            n30 = n31 + n33 * this.dimOffset[n2 - 1] * 16;
                            byArray[n30 + 1] = 0;
                            byArray[n30] = 0;
                            ++n33;
                        }
                        break;
                    }
                    case 'D': {
                        int n35;
                        double[] dArray = (double[])object;
                        int n36 = n;
                        int n37 = 0;
                        while (n37 < n2 - 1) {
                            n36 += nArray[n37] * this.dimOffset[n37] * 16;
                            ++n37;
                        }
                        int n38 = 0;
                        while (n38 < dArray.length) {
                            n35 = n36 + n38 * this.dimOffset[n2 - 1] * 16;
                            byArray[n35] = 5;
                            byArray[n35 + 1] = 0;
                            long l = Double.doubleToLongBits(dArray[n38]);
                            byArray[n35 + 8] = (byte)l;
                            byArray[n35 + 9] = (byte)(l >>> 8 & 0xFFL);
                            byArray[n35 + 10] = (byte)(l >>> 16 & 0xFFL);
                            byArray[n35 + 11] = (byte)(l >>> 24 & 0xFFL);
                            byArray[n35 + 12] = (byte)(l >>> 32 & 0xFFL);
                            byArray[n35 + 13] = (byte)(l >>> 40 & 0xFFL);
                            byArray[n35 + 14] = (byte)(l >>> 48 & 0xFFL);
                            byArray[n35 + 15] = (byte)(l >>> 56 & 0xFFL);
                            ++n38;
                        }
                        while (n38 < this.maxDimArray[n2 - 1]) {
                            n35 = n36 + n38 * this.dimOffset[n2 - 1] * 16;
                            byArray[n35 + 1] = 0;
                            byArray[n35] = 0;
                            ++n38;
                        }
                        break;
                    }
                    default: {
                        int n39;
                        Object[] objectArray = (Object[])object;
                        int n40 = n;
                        int n41 = 0;
                        while (n41 < n2 - 1) {
                            n40 += nArray[n41] * this.dimOffset[n41] * 16;
                            ++n41;
                        }
                        int n42 = 0;
                        while (n42 < objectArray.length) {
                            n39 = n40 + n42 * this.dimOffset[n2 - 1] * 16;
                            if (objectArray[n42] == null) {
                                byArray[n39] = 1;
                                byArray[n39 + 1] = 0;
                            } else if (objectArray[n42] instanceof Boolean) {
                                byte by;
                                byArray[n39] = 11;
                                byArray[n39 + 1] = 0;
                                byArray[n39 + 8] = by = (byte)((Boolean)objectArray[n42] != false ? 255 : 0);
                                byArray[n39 + 9] = by;
                                byArray[n39 + 10] = by;
                                byArray[n39 + 11] = by;
                            } else if (objectArray[n42] instanceof Integer) {
                                byArray[n39] = 3;
                                byArray[n39 + 1] = 0;
                                int n43 = (Integer)objectArray[n42];
                                byArray[n39 + 8] = (byte)n43;
                                byArray[n39 + 9] = (byte)(n43 >>> 8 & 0xFF);
                                byArray[n39 + 10] = (byte)(n43 >>> 16 & 0xFF);
                                byArray[n39 + 11] = (byte)(n43 >>> 24 & 0xFF);
                            } else if (objectArray[n42] instanceof String) {
                                byte[] byArray3 = ActiveScriptEngine.this.nativeStingToBString((String)objectArray[n42]);
                                byArray[n39] = 8;
                                byArray[n39 + 1] = 0;
                                byArray[n39 + 8] = byArray3[0];
                                byArray[n39 + 9] = byArray3[1];
                                byArray[n39 + 10] = byArray3[2];
                                byArray[n39 + 11] = byArray3[3];
                            } else if (objectArray[n42] instanceof Long) {
                                byArray[n39] = 5;
                                byArray[n39 + 1] = 0;
                                long l = Double.doubleToLongBits(((Long)objectArray[n42]).longValue());
                                byArray[n39 + 8] = (byte)l;
                                byArray[n39 + 9] = (byte)(l >>> 8 & 0xFFL);
                                byArray[n39 + 10] = (byte)(l >>> 16 & 0xFFL);
                                byArray[n39 + 11] = (byte)(l >>> 24 & 0xFFL);
                                byArray[n39 + 12] = (byte)(l >>> 32 & 0xFFL);
                                byArray[n39 + 13] = (byte)(l >>> 40 & 0xFFL);
                                byArray[n39 + 14] = (byte)(l >>> 48 & 0xFFL);
                                byArray[n39 + 15] = (byte)(l >>> 56 & 0xFFL);
                            } else if (objectArray[n42] instanceof Short) {
                                byArray[n39] = 2;
                                byArray[n39 + 1] = 0;
                                int n44 = ((Short)objectArray[n42]).intValue();
                                byArray[n39 + 8] = (byte)n44;
                                byArray[n39 + 9] = (byte)(n44 >>> 8 & 0xFF);
                                byArray[n39 + 10] = (byte)(n44 >>> 16 & 0xFF);
                                byArray[n39 + 11] = (byte)(n44 >>> 24 & 0xFF);
                            } else if (objectArray[n42] instanceof Float) {
                                byArray[n39] = 4;
                                byArray[n39 + 1] = 0;
                                int n45 = Float.floatToIntBits(((Float)objectArray[n42]).floatValue());
                                byArray[n39 + 8] = (byte)n45;
                                byArray[n39 + 9] = (byte)(n45 >>> 8 & 0xFF);
                                byArray[n39 + 10] = (byte)(n45 >>> 16 & 0xFF);
                                byArray[n39 + 11] = (byte)(n45 >>> 24 & 0xFF);
                            } else if (objectArray[n42] instanceof Double) {
                                byArray[n39] = 5;
                                byArray[n39 + 1] = 0;
                                long l = Double.doubleToLongBits((Double)objectArray[n42]);
                                byArray[n39 + 8] = (byte)l;
                                byArray[n39 + 9] = (byte)(l >>> 8 & 0xFFL);
                                byArray[n39 + 10] = (byte)(l >>> 16 & 0xFFL);
                                byArray[n39 + 11] = (byte)(l >>> 24 & 0xFFL);
                                byArray[n39 + 12] = (byte)(l >>> 32 & 0xFFL);
                                byArray[n39 + 13] = (byte)(l >>> 40 & 0xFFL);
                                byArray[n39 + 14] = (byte)(l >>> 48 & 0xFFL);
                                byArray[n39 + 15] = (byte)(l >>> 56 & 0xFFL);
                            } else if (objectArray[n42] instanceof Byte) {
                                byte by;
                                byArray[n39] = 17;
                                byArray[n39 + 1] = 0;
                                byArray[n39 + 8] = by = ((Byte)objectArray[n42]).byteValue();
                            } else if (objectArray[n42] instanceof Character) {
                                byte by;
                                byArray[n39] = 17;
                                byArray[n39 + 1] = 0;
                                byArray[n39 + 8] = by = (byte)((Character)objectArray[n42]).charValue();
                            } else if (objectArray[n42] instanceof Void) {
                                byArray[n39] = 1;
                                byArray[n39 + 1] = 0;
                            } else {
                                byte[] byArray4 = null;
                                byArray[n39] = 9;
                                byArray[n39 + 1] = 0;
                                byArray4 = object instanceof COMIDispatchBean ? ((COMIDispatchBean)objectArray[n42]).getIDispatchInterface() : ActiveScriptEngine.this.nativeObjectToVariant(ActiveScriptEngine.this.css, objectArray[n42]);
                                System.arraycopy(byArray4, 0, byArray, n39 + 8, byArray4.length);
                            }
                            ++n42;
                        }
                        while (n42 < this.maxDimArray[n2 - 1]) {
                            n39 = n40 + n42 * this.dimOffset[n2 - 1] * 16;
                            byArray[n39 + 1] = 0;
                            byArray[n39] = 0;
                            ++n42;
                        }
                        break;
                    }
                }
            }
            return n;
        }

        public String toString() {
            if (this.maxDepth == 0) {
                return "Not an array";
            }
            String string = "type=" + this.type + ",maxDepth=" + this.maxDepth + "maxDimArray=\n";
            int n = 0;
            while (n < this.maxDepth) {
                string = String.valueOf(string) + "[" + n + "]" + "=" + this.maxDimArray[n] + ";\n";
                ++n;
            }
            return string;
        }

        byte[] toVariant() throws BSFException {
            this.investigate(this.arrayObject, 0);
            int n = this.maxDimArray[0];
            int n2 = 1;
            while (n2 < this.maxDepth) {
                n *= this.maxDimArray[n2];
                ++n2;
            }
            int n3 = 32 + 8 * this.maxDepth + n * 16;
            byte[] byArray = new byte[n3];
            byArray[0] = 12;
            byArray[1] = 32;
            byArray[16] = (byte)this.maxDepth;
            byArray[17] = (byte)(this.maxDepth >>> 8 & 0xFF);
            byArray[18] = -110;
            byArray[19] = 8;
            byArray[20] = 16;
            byArray[23] = 0;
            byArray[22] = 0;
            byArray[21] = 0;
            byArray[27] = 0;
            byArray[26] = 0;
            byArray[25] = 0;
            byArray[24] = 0;
            int n4 = 0;
            int n5 = 32;
            n4 = this.maxDepth - 1;
            while (n4 >= 0) {
                byArray[n5++] = (byte)this.maxDimArray[n4];
                byArray[n5++] = (byte)(this.maxDimArray[n4] >>> 8 & 0xFF);
                byArray[n5++] = (byte)(this.maxDimArray[n4] >>> 16 & 0xFF);
                byArray[n5++] = (byte)(this.maxDimArray[n4] >>> 24 & 0xFF);
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                --n4;
            }
            byArray[31] = 0;
            byArray[30] = 0;
            byArray[29] = 0;
            byArray[28] = 0;
            byArray[28] = (byte)n5;
            byArray[29] = (byte)(n5 >>> 8 & 0xFF);
            byArray[30] = (byte)(n5 >>> 16 & 0xFF);
            byArray[31] = (byte)(n5 >>> 24 & 0xFF);
            this.setVariantData(this.arrayObject, byArray, n5, 0, new int[this.maxDepth]);
            return byArray;
        }
    }
}

