/**************************************************************
*   
*   Creation Date: <1999-12-31 20:32:35 samuel>
*   Time-stamp: <2000/12/31 04:15:36 samuel>
*   
*	<video_module.h>
*	
*	Video module interface
*   
*   Copyright (C) 1999, 2000 Samuel Rydh
*   
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*   
**************************************************************/

#ifndef _H_VIDEO_MODULE
#define _H_VIDEO_MODULE

struct video_module;
struct video_desc;

typedef void (*setcmap_fp)( char *cmap );
typedef int (*vopen_fp)( struct video_desc *vmode);
typedef void (*vclose_fp)( void );
typedef void (*vrefresh_fp)( void );
typedef int (*vinit_fp)( struct video_module *m );
typedef void (*vcleanup_fp)( struct video_module *m );


typedef struct video_module
{
	const char	*name;
	
	vinit_fp	vinit;
	vcleanup_fp	vcleanup;

	vopen_fp	vopen;
	vclose_fp	vclose;
	vrefresh_fp	vrefresh;
	setcmap_fp	setcmap;

	struct video_desc *modes;	/* modes supported by this driver */

	struct video_module *next;
} video_module_t;

typedef struct video_desc {
	int	offs;			/* offs to actual fb data (from page boundary) */
        int 	rowbytes;
        int 	w;			/* width */
        int 	h;			/* height */
	int 	depth;
	int	refresh;		/* Hz * 65536 (for verbose information only) */
	void	*module_data;		/* private field (fbdev info for instance) */

	/* fields to be filled in by vopen */
	char	*lvbase;		/* page-aligned linux address of mapping */
	ulong	map_base;		/* mapping address to be used instead of lvbase if nonzero */
	int	mmu_flags;		/* "special" MMU options (for acceleration etc) */

	/* next supported video mode */
	struct video_desc *next;	/* next */
} video_desc_t;

extern void 	video_module_become( video_module_t *m );
extern int 	video_module_yield( video_module_t *yielder, int may_fail );

extern char 	*get_vmode_str( video_desc_t *vm, char *buf, int size );

static inline int
std_depth( int depth ) {
	switch( depth ){
	case 16: 
		return 15;
	case 24: 
		return 32; }
	return depth;
}

#define FBBUF_SIZE( vm ) \
	(((vm)->rowbytes * (vm)->h + (vm)->offs + 0xfff) & ~0xfff)

#endif   /* _H_VIDEO */
