/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.action.ItemAction;
import prefuse.visual.VisualItem;

public class PolarLocationAnimator
extends ItemAction {
    private Point2D m_anchor = new Point2D.Double();
    private String m_linear = null;
    private double ax;
    private double ay;
    private double sx;
    private double sy;
    private double ex;
    private double ey;
    private double x;
    private double y;
    private double dt1;
    private double dt2;
    private double sr;
    private double st;
    private double er;
    private double et;
    private double r;
    private double t;
    private double stt;
    private double ett;

    public PolarLocationAnimator() {
    }

    public PolarLocationAnimator(String group) {
        super(group);
    }

    public PolarLocationAnimator(String group, String linearGroup) {
        super(group);
        this.m_linear = linearGroup;
    }

    private void setAnchor() {
        Display d = this.getVisualization().getDisplay(0);
        this.m_anchor.setLocation(d.getWidth() / 2, d.getHeight() / 2);
        d.getAbsoluteCoordinate(this.m_anchor, this.m_anchor);
        this.ax = this.m_anchor.getX();
        this.ay = this.m_anchor.getY();
    }

    public void run(double frac) {
        this.setAnchor();
        super.run(frac);
    }

    public void process(VisualItem item, double frac) {
        if (this.m_linear != null && item.isInGroup(this.m_linear)) {
            double s = item.getStartX();
            item.setX(s + frac * (item.getEndX() - s));
            s = item.getStartY();
            item.setY(s + frac * (item.getEndY() - s));
            return;
        }
        this.sx = item.getStartX() - this.ax;
        this.sy = item.getStartY() - this.ay;
        this.ex = item.getEndX() - this.ax;
        this.ey = item.getEndY() - this.ay;
        this.sr = Math.sqrt(this.sx * this.sx + this.sy * this.sy);
        this.st = Math.atan2(this.sy, this.sx);
        this.er = Math.sqrt(this.ex * this.ex + this.ey * this.ey);
        this.et = Math.atan2(this.ey, this.ex);
        this.stt = this.st < 0.0 ? this.st + Math.PI * 2 : this.st;
        this.ett = this.et < 0.0 ? this.et + Math.PI * 2 : this.et;
        this.dt1 = this.et - this.st;
        this.dt2 = this.ett - this.stt;
        this.t = Math.abs(this.dt1) < Math.abs(this.dt2) ? this.st + frac * this.dt1 : this.stt + frac * this.dt2;
        this.r = this.sr + frac * (this.er - this.sr);
        this.x = Math.round(this.ax + this.r * Math.cos(this.t));
        this.y = Math.round(this.ay + this.r * Math.sin(this.t));
        item.setX(this.x);
        item.setY(this.y);
    }
}

