/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MemberInfoObfuscator;

public class MappingKeeper
implements MappingProcessor {
    private ClassPool classPool;
    private WarningPrinter warningPrinter;
    private ClassFile classFile;

    public MappingKeeper(ClassPool classPool, WarningPrinter warningPrinter) {
        this.classPool = classPool;
        this.warningPrinter = warningPrinter;
    }

    public boolean processClassFileMapping(String string, String string2) {
        String string3 = ClassUtil.internalClassName(string);
        this.classFile = this.classPool.getClass(string3);
        if (this.classFile != null) {
            String string4;
            String string5 = ClassUtil.internalClassName(string2);
            if (this.warningPrinter != null && (string4 = ClassFileObfuscator.newClassName(this.classFile)) != null && !string4.equals(string5)) {
                this.warningPrinter.print("Warning: " + string + " is not being kept as '" + ClassUtil.externalClassName(string4) + "', but remapped to '" + string2 + "'");
            }
            ClassFileObfuscator.setNewClassName(this.classFile, string5);
            return true;
        }
        return false;
    }

    public void processFieldMapping(String string, String string2, String string3, String string4) {
        String string5;
        String string6;
        FieldInfo fieldInfo;
        if (this.classFile != null && (fieldInfo = this.classFile.findField(string6 = string3, string5 = ClassUtil.internalType(string2))) != null) {
            String string7;
            if (this.warningPrinter != null && (string7 = MemberInfoObfuscator.newMemberName(fieldInfo)) != null && !string7.equals(string4)) {
                this.warningPrinter.print("Warning: " + string + ": field '" + string2 + " " + string3 + "' is not being kept as '" + string7 + "', but remapped to '" + string4 + "'");
            }
            MemberInfoObfuscator.setFixedNewMemberName(fieldInfo, string4);
        }
    }

    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4) {
        String string5;
        String string6;
        MethodInfo methodInfo;
        if (this.classFile != null && (methodInfo = this.classFile.findMethod(string6 = ClassUtil.externalMethodName(string3), string5 = ClassUtil.internalMethodDescriptor(string2, string3))) != null) {
            String string7;
            if (this.warningPrinter != null && (string7 = MemberInfoObfuscator.newMemberName(methodInfo)) != null && !string7.equals(string4)) {
                this.warningPrinter.print("Warning: " + string + ": method '" + string2 + " " + string3 + "' is not being kept as '" + string7 + "', but remapped to '" + string4 + "'");
            }
            MemberInfoObfuscator.setFixedNewMemberName(methodInfo, string4);
        }
    }
}

