/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Grammar;
import antlr.Token;
import antlr.Tool;
import antlr.collections.impl.BitSet;
import java.io.IOException;

class LexerGrammar
extends Grammar {
    protected BitSet charVocabulary = new BitSet();
    protected boolean testLiterals = true;
    protected boolean caseSensitiveLiterals = true;
    protected boolean caseSensitive = true;
    protected boolean filterMode = false;
    protected String filterRule = null;

    LexerGrammar(String className_, Tool tool_, String superClass) {
        super(className_, tool_, superClass);
        this.defaultErrorHandler = false;
    }

    public void generate() throws IOException {
        this.generator.gen(this);
    }

    public String getSuperClass() {
        if (this.debuggingOutput) {
            return "debug.DebuggingCharScanner";
        }
        return "CharScanner";
    }

    public boolean getTestLiterals() {
        return this.testLiterals;
    }

    public void processArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-trace")) {
                this.traceRules = true;
                this.antlrTool.setArgOK(i);
                continue;
            }
            if (args[i].equals("-traceLexer")) {
                this.traceRules = true;
                this.antlrTool.setArgOK(i);
                continue;
            }
            if (!args[i].equals("-debug")) continue;
            this.debuggingOutput = true;
            this.antlrTool.setArgOK(i);
        }
    }

    public void setCharVocabulary(BitSet b) {
        this.charVocabulary = b;
    }

    public boolean setOption(String key, Token value) {
        String s = value.getText();
        if (key.equals("buildAST")) {
            this.antlrTool.warning("buildAST option is not valid for lexer", this.getFilename(), value.getLine(), value.getColumn());
            return true;
        }
        if (key.equals("testLiterals")) {
            if (s.equals("true")) {
                this.testLiterals = true;
            } else if (s.equals("false")) {
                this.testLiterals = false;
            } else {
                this.antlrTool.warning("testLiterals option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("interactive")) {
            if (s.equals("true")) {
                this.interactive = true;
            } else if (s.equals("false")) {
                this.interactive = false;
            } else {
                this.antlrTool.error("interactive option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("caseSensitive")) {
            if (s.equals("true")) {
                this.caseSensitive = true;
            } else if (s.equals("false")) {
                this.caseSensitive = false;
            } else {
                this.antlrTool.warning("caseSensitive option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("caseSensitiveLiterals")) {
            if (s.equals("true")) {
                this.caseSensitiveLiterals = true;
            } else if (s.equals("false")) {
                this.caseSensitiveLiterals = false;
            } else {
                this.antlrTool.warning("caseSensitiveLiterals option must be true or false", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("filter")) {
            if (s.equals("true")) {
                this.filterMode = true;
            } else if (s.equals("false")) {
                this.filterMode = false;
            } else if (value.getType() == 24) {
                this.filterMode = true;
                this.filterRule = s;
            } else {
                this.antlrTool.warning("filter option must be true, false, or a lexer rule name", this.getFilename(), value.getLine(), value.getColumn());
            }
            return true;
        }
        if (key.equals("longestPossible")) {
            this.antlrTool.warning("longestPossible option has been deprecated; ignoring it...", this.getFilename(), value.getLine(), value.getColumn());
            return true;
        }
        if (super.setOption(key, value)) {
            return true;
        }
        this.antlrTool.error("Invalid option: " + key, this.getFilename(), value.getLine(), value.getColumn());
        return false;
    }
}

