/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.comm.ConnectorAddress;
import com.sun.jdmk.comm.HttpConnectorAddress;
import com.sun.jdmk.comm.HttpsConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.discovery.DiscoveryMsg;
import java.util.Hashtable;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

class ResponsePDU
extends DiscoveryMsg {
    private static final long serialVersionUID = -1917939025172594153L;
    private Hashtable objectList = new Hashtable();
    private boolean evt = false;
    private int agtState = 1;
    private String mbeanServerId = null;
    private String specificationName = null;
    private String specificationVersion = null;
    private String specificationVendor = null;
    private String implementationName = null;
    private String implementationVersion = null;
    private String implementationVendor = null;
    private byte[] userData = null;
    JMXServiceURL[] serverAddresses;

    public ResponsePDU(String string, String string2, String string3, String string4, String string5, String string6, String string7, byte[] byArray) {
        this.mbeanServerId = string;
        this.specificationName = string2;
        this.specificationVersion = string4;
        this.specificationVendor = string3;
        this.implementationName = string5;
        this.implementationVersion = string7;
        this.implementationVendor = string6;
        this.userData = byArray;
    }

    public String printState() {
        Object object;
        String string = new String();
        string = string + "(TimeStamp=" + this.getTimeStamp() + ")";
        string = string + "(Event=" + this.getEvent() + ")";
        if (this.getEvent()) {
            object = null;
            if (this.getAgentState() == 0) {
                object = "ONLINE";
            }
            if (this.getAgentState() == 1) {
                object = "OFFLINE";
            }
            if (this.getAgentState() == 2) {
                object = "STOPPING";
            }
            string = string + "(Agent State =" + (String)object + ")";
        }
        string = string + "(Ttl=" + this.getTimeToLive() + ")";
        string = string + "(local host = " + this.getHost() + ")";
        string = string + "(mbeanServerId = " + this.mbeanServerId + ")";
        string = string + "(specificationName = " + this.specificationName + ")";
        string = string + "(specificationVersion = " + this.specificationVersion + ")";
        string = string + "(specificationVendor = " + this.specificationVendor + ")";
        string = string + "(implementationName = " + this.implementationName + ")";
        string = string + "(implementationVersion = " + this.implementationVersion + ")";
        string = string + "(implementationVendor = " + this.implementationVendor + ")";
        if (this.objectList != null) {
            string = string + "(objects ";
            object = this.objectList.keys();
            while (object.hasMoreElements()) {
                ObjectName objectName = (ObjectName)object.nextElement();
                string = string + "-  name=" + objectName + " addr=" + this.toString(this.objectList.get(objectName));
            }
            string = string + ")";
        } else {
            string = string + "(No object)";
        }
        return string;
    }

    public String getMbeanServerId() {
        return this.mbeanServerId;
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public void setEvent(boolean bl) {
        this.evt = bl;
    }

    public boolean getEvent() {
        return this.evt;
    }

    public void setAgentState(int n) {
        this.agtState = n;
    }

    public int getAgentState() {
        return this.agtState;
    }

    public Hashtable getObjectList() {
        return this.objectList;
    }

    public void addObjectList(ObjectName objectName, ConnectorAddress connectorAddress) {
        if (connectorAddress != null) {
            this.objectList.put(objectName, connectorAddress);
        } else {
            this.objectList.put(objectName, "Not Relevant");
        }
    }

    private String toString(Object object) {
        if (object instanceof RmiConnectorAddress) {
            RmiConnectorAddress rmiConnectorAddress = (RmiConnectorAddress)object;
            return "type:" + rmiConnectorAddress.getConnectorType() + ";host:" + rmiConnectorAddress.getHost() + ";port:" + rmiConnectorAddress.getPort() + ";name:" + rmiConnectorAddress.getName();
        }
        if (object instanceof HttpConnectorAddress) {
            HttpConnectorAddress httpConnectorAddress = (HttpConnectorAddress)object;
            return "type:" + httpConnectorAddress.getConnectorType() + ";host:" + httpConnectorAddress.getHost() + ";port:" + httpConnectorAddress.getPort();
        }
        if (object instanceof HttpsConnectorAddress) {
            HttpsConnectorAddress httpsConnectorAddress = (HttpsConnectorAddress)object;
            return "type:" + httpsConnectorAddress.getConnectorType() + ";host:" + httpsConnectorAddress.getHost() + ";port:" + httpsConnectorAddress.getPort();
        }
        return object.toString();
    }
}

