/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;
import com.sun.management.snmp.SnmpMessage;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpPduRequest;
import java.net.DatagramPacket;

class SnmpResponseHandler {
    SnmpAdaptorServer adaptor = null;
    SnmpQManager snmpq = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpResponseHandler");

    public SnmpResponseHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpQManager snmpQManager) {
        this.adaptor = snmpAdaptorServer;
        this.snmpq = snmpQManager;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block15: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (logger.finerOn()) {
                logger.finer("processDatagram", "Received from " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMessage.dumpHexBuffer(byArray, 0, n));
            }
            try {
                SnmpMessage snmpMessage = new SnmpMessage();
                snmpMessage.decodeMessage(byArray, n);
                snmpMessage.address = datagramPacket.getAddress();
                snmpMessage.port = datagramPacket.getPort();
                SnmpPduFactory snmpPduFactory = this.adaptor.getPduFactory();
                if (snmpPduFactory == null) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                } else {
                    SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPduFactory.decodeSnmpPdu(snmpMessage);
                    if (snmpPduPacket == null) {
                        if (logger.finestOn()) {
                            logger.finest("processDatagram", "Dropping packet. Pdu factory returned a null value");
                        }
                    } else if (snmpPduPacket instanceof SnmpPduRequest) {
                        SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                        SnmpInformRequest snmpInformRequest = this.snmpq.removeRequest(snmpPduRequest.requestId);
                        if (snmpInformRequest != null) {
                            snmpInformRequest.invokeOnResponse(snmpPduRequest);
                        } else if (logger.finestOn()) {
                            logger.finest("processDatagram", "Dropping packet. Unable to find corresponding request for InformRequestId = " + snmpPduRequest.requestId);
                        }
                    } else if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. The packet does not contain an inform response");
                    }
                    snmpPduPacket = null;
                }
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block15;
                logger.finest("processDatagram", "Exception while processsing");
                logger.finest("processDatagram", exception);
            }
        }
    }
}

