/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jca.cics;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.jca.JCACommareaBasedConnectionManager;
import it.imolinfo.jbi4cics.connection.jca.cics.CICSInteractionDescription;
import it.imolinfo.jbi4cics.exception.ConnectionException;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.service.ServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.InteractionSpec;

public class CICSConnectionManager
extends JCACommareaBasedConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(CICSConnectionManager.class);
    private static final Messages MESSAGES = Messages.getMessages(CICSConnectionManager.class);

    protected ConnectionSpec createConnectionSpec(ServiceContext serviceContext) throws ConnectionException {
        ConnectionSpec eciConnectionSpec = null;
        try {
            eciConnectionSpec = (ConnectionSpec)this.getConnectorClassLoader().loadClass("com.ibm.connector2.cics.ECIConnectionSpec").newInstance();
        }
        catch (InstantiationException e) {
            LOG.error("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
        }
        catch (IllegalAccessException e) {
            LOG.error("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
        }
        if (eciConnectionSpec == null) {
            LOG.error("CIC000404_Connection_spec_not_found");
            throw new ConnectionException(MESSAGES.getString("CIC000404_Connection_spec_not_found", new Object[0]));
        }
        this.invokeMethodWithOneStringParam(eciConnectionSpec, "setUserName", serviceContext.getAccount().getUsername());
        this.invokeMethodWithOneStringParam(eciConnectionSpec, "setPassword", serviceContext.getAccount().getPassword());
        return eciConnectionSpec;
    }

    protected InteractionSpec createInteractionSpec(ServiceContext serviceContext) throws ConnectionException {
        if (!(serviceContext.getInteractionDescription() instanceof CICSInteractionDescription)) {
            LOG.error("CIC000405_Cics_interaction_description_not_found", serviceContext.getInteractionDescription().getClass());
            throw new ConnectionException(MESSAGES.getString("CIC000405_Cics_interaction_description_not_found", serviceContext.getInteractionDescription().getClass()));
        }
        CICSInteractionDescription cicsInteractionDescription = (CICSInteractionDescription)serviceContext.getInteractionDescription();
        InteractionSpec eciInteractionSpec = null;
        try {
            eciInteractionSpec = (InteractionSpec)this.getConnectorClassLoader().loadClass("com.ibm.connector2.cics.ECIInteractionSpec").newInstance();
        }
        catch (InstantiationException e) {
            LOG.error("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
        }
        catch (IllegalAccessException e) {
            LOG.error("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000400_Error_istantiating_connection_spec", new Object[]{e.getMessage()}, e);
        }
        this.invokeMethodWithOneIntParam(eciInteractionSpec, "setExecuteTimeout", cicsInteractionDescription.getTimeout());
        this.invokeMethodWithOneStringParam(eciInteractionSpec, "setFunctionName", cicsInteractionDescription.getProgramName());
        if (cicsInteractionDescription.isTpn()) {
            this.invokeMethodWithOneStringParam(eciInteractionSpec, "setTPNName", cicsInteractionDescription.getTransactionName());
        } else {
            this.invokeMethodWithOneStringParam(eciInteractionSpec, "setTranName", cicsInteractionDescription.getTransactionName());
        }
        this.invokeMethodWithOneIntParam(eciInteractionSpec, "setInteractionVerb", 1);
        if (!(serviceContext.getInputMappingDescriptor() instanceof CommareaBeanMappingDescriptor)) {
            LOG.error("CIC000401_Expected_commarea_bean_mapping_descriptor", new Object[]{serviceContext.getInputMappingDescriptor().getClass()});
            throw new ConnectionException("CIC000401_Expected_commarea_bean_mapping_descriptor", new Object[]{serviceContext.getInputMappingDescriptor().getClass()});
        }
        if (!(serviceContext.getOutputMappingDescriptor() instanceof CommareaBeanMappingDescriptor)) {
            LOG.error("CIC000401_Expected_commarea_bean_mapping_descriptor", new Object[]{serviceContext.getOutputMappingDescriptor().getClass()});
            throw new ConnectionException("CIC000401_Expected_commarea_bean_mapping_descriptor", new Object[]{serviceContext.getOutputMappingDescriptor().getClass()});
        }
        CommareaBeanMappingDescriptor inputMappingDescriptor = (CommareaBeanMappingDescriptor)serviceContext.getInputMappingDescriptor();
        CommareaBeanMappingDescriptor outputMappingDescriptor = (CommareaBeanMappingDescriptor)serviceContext.getOutputMappingDescriptor();
        try {
            if (inputMappingDescriptor.getBufferedLength() >= outputMappingDescriptor.getBufferedLength()) {
                this.invokeMethodWithOneIntParam(eciInteractionSpec, "setCommareaLength", inputMappingDescriptor.getBufferedLength());
            } else {
                this.invokeMethodWithOneIntParam(eciInteractionSpec, "setCommareaLength", outputMappingDescriptor.getBufferedLength());
            }
        }
        catch (FormatException e) {
            LOG.error("CIC000402_Error_setting_commarea_lengths", new Object[]{e.getMessage()}, e);
            throw new ConnectionException("CIC000402_Error_setting_commarea_lengths", new Object[]{e.getMessage()}, e);
        }
        return eciInteractionSpec;
    }

    protected void invokeMethodWithOneStringParam(Object obj, String methodName, String methodParam) throws ConnectionException {
        Class[] parameterTypes = new Class[]{String.class};
        Object[] arguments = new Object[]{methodParam};
        Class<?> objClass = obj.getClass();
        try {
            Method method = objClass.getMethod(methodName, parameterTypes);
            method.invoke(obj, arguments);
        }
        catch (NoSuchMethodException e) {
            LOG.error("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
            throw new ConnectionException("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
        }
        catch (IllegalAccessException e) {
            LOG.error("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
            throw new ConnectionException("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
        }
        catch (InvocationTargetException e) {
            LOG.error("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e.getCause());
            throw new ConnectionException("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e.getCause());
        }
    }

    protected void invokeMethodWithOneIntParam(Object obj, String methodName, int methodParam) throws ConnectionException {
        Class[] parameterTypes = new Class[]{Integer.TYPE};
        Object[] arguments = new Object[]{methodParam};
        Class<?> objClass = obj.getClass();
        try {
            Method method = objClass.getMethod(methodName, parameterTypes);
            method.invoke(obj, arguments);
        }
        catch (NoSuchMethodException e) {
            LOG.error("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
            throw new ConnectionException("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
        }
        catch (IllegalAccessException e) {
            LOG.error("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
            throw new ConnectionException("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e);
        }
        catch (InvocationTargetException e) {
            LOG.error("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e.getCause());
            throw new ConnectionException("CIC000403_Method_invocation_error", new Object[]{methodName, objClass, methodParam}, e.getCause());
        }
    }
}

