/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.runtime;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4ejb.runtime.ByteType;
import it.imolinfo.jbi4ejb.runtime.ProviderServiceInvoker;
import java.util.HashMap;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.Invoker;

public class ProviderServiceCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderServiceCreator.class);

    public Service createJbiService(ProviderServiceDescriptor serviceDescriptor, XFire xfire) {
        LOG.debug("Creating xfire service: " + serviceDescriptor.getServiceName());
        ObjectServiceFactory factory = new ObjectServiceFactory(xfire.getTransportManager(), null);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.portType", serviceDescriptor.getPortTypeName());
        props.put("objectServiceFactory.style", "wrapped");
        props.put("objectServiceFactory.use", "literal");
        props.put("annotations.allow.interface", Boolean.TRUE);
        factory.getSoap11Transports().clear();
        factory.getSoap12Transports().clear();
        factory.getSoap11Transports().add("uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        Service service = null;
        service = factory.create(serviceDescriptor.getEjbProxy().getRemoteInterfaceClass(), serviceDescriptor.getServiceName().getLocalPart(), serviceDescriptor.getServiceName().getNamespaceURI(), props);
        service.setInvoker((Invoker)new ProviderServiceInvoker(serviceDescriptor));
        AegisBindingProvider abp = (AegisBindingProvider)factory.getBindingProvider();
        TypeMapping typeMapping = abp.getTypeMapping(service);
        typeMapping.register((Type)new ByteType());
        return service;
    }
}

