/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.wireio;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class CommonWireIOTestCase
extends CommonProfilerTestCase {
    protected static int PORT = 5140;

    public CommonWireIOTestCase(String name) {
        super(name);
    }

    public WireIO createWireIO(Socket clientSocket) {
        try {
            clientSocket.setTcpNoDelay(true);
            ObjectInputStream socketIn = new ObjectInputStream(clientSocket.getInputStream());
            ObjectOutputStream socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
            WireIO wireIO = new WireIO(socketOut, socketIn);
            return wireIO;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public WireIO createWireIOClient(Socket clientSocket) {
        try {
            clientSocket.setSoTimeout(0);
            clientSocket.setTcpNoDelay(true);
            ObjectOutputStream socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
            ObjectInputStream socketIn = new ObjectInputStream(clientSocket.getInputStream());
            WireIO wireIO = new WireIO(socketOut, socketIn);
            return wireIO;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean simpleLogCommands(WireIO wireIO) {
        try {
            Object o = wireIO.receiveCommandOrResponse();
            if (o == null) {
                this.ref("Connection interrupted.");
                return false;
            }
            if (o instanceof Command) {
                this.ref(" received command " + o.toString());
            } else {
                this.ref(" received object " + o.getClass().getName() + " " + o.toString());
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    protected class LoggingThread
    extends Thread {
        boolean prepared = false;
        private boolean running = true;

        protected LoggingThread() {
        }

        public boolean isPrepared() {
            return this.prepared;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(PORT);
                CommonWireIOTestCase.this.ref("Server start to listen on port " + String.valueOf(PORT));
                this.prepared = true;
                Socket clientSocket = serverSocket.accept();
                WireIO wireIO = CommonWireIOTestCase.this.createWireIO(clientSocket);
                while (this.running) {
                    this.running &= CommonWireIOTestCase.this.simpleLogCommands(wireIO);
                }
                serverSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

