/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.TypeConverter;

public class BasicTypeConverter
implements TypeConverter {
    public boolean canConvert(Object object, Class toType) {
        if (object == null) {
            return true;
        }
        if (toType == Object.class) {
            return true;
        }
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType)) {
            return true;
        }
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        if (toType == String.class) {
            return true;
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE || Number.class.isAssignableFrom(toType)) {
                return true;
            }
        } else if (object instanceof Number) {
            if (toType.isPrimitive() || Number.class.isAssignableFrom(toType)) {
                return true;
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return true;
            }
        } else if (object instanceof String) {
            if (toType.isPrimitive()) {
                return true;
            }
            if (toType == Boolean.class || toType == Character.class || toType == Byte.class || toType == Short.class || toType == Integer.class || toType == Long.class || toType == Float.class || toType == Double.class) {
                return true;
            }
        } else {
            if (fromType.isArray()) {
                if (toType.isArray()) {
                    Class<?> cType = toType.getComponentType();
                    int length = Array.getLength(object);
                    for (int i = 0; i < length; ++i) {
                        Object value = Array.get(object, i);
                        if (this.canConvert(value, cType)) continue;
                        return false;
                    }
                    return true;
                }
                if (Collection.class.isAssignableFrom(toType)) {
                    return BasicTypeConverter.canCreateCollection(toType);
                }
                if (Array.getLength(object) > 0) {
                    Object value = Array.get(object, 0);
                    return this.canConvert(value, toType);
                }
                return this.canConvert("", toType);
            }
            if (object instanceof Collection) {
                if (toType.isArray()) {
                    Class<?> cType = toType.getComponentType();
                    for (Object value : (Collection)object) {
                        if (this.canConvert(value, cType)) continue;
                        return false;
                    }
                    return true;
                }
                if (Collection.class.isAssignableFrom(toType)) {
                    return BasicTypeConverter.canCreateCollection(toType);
                }
                if (((Collection)object).size() > 0) {
                    Object value;
                    if (object instanceof List) {
                        value = ((List)object).get(0);
                    } else {
                        Iterator it = ((Collection)object).iterator();
                        value = it.next();
                    }
                    return this.canConvert(value, toType);
                }
                return this.canConvert("", toType);
            }
            if (object instanceof NodeSet) {
                return this.canConvert(((NodeSet)object).getValues(), toType);
            }
            if (object instanceof Pointer) {
                return this.canConvert(((Pointer)object).getValue(), toType);
            }
        }
        return false;
    }

    public Object convert(Object object, Class toType) {
        Object value;
        if (object == null) {
            if (toType.isPrimitive()) {
                return this.convertNullToPrimitive(toType);
            }
            return null;
        }
        if (toType == Object.class) {
            return object;
        }
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType) || toType.isAssignableFrom(fromType)) {
            return object;
        }
        if (fromType.isArray()) {
            int length = Array.getLength(object);
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                Object array = Array.newInstance(cType, length);
                for (int i = 0; i < length; ++i) {
                    Object value2 = Array.get(object, i);
                    Array.set(array, i, this.convert(value2, cType));
                }
                return array;
            }
            if (Collection.class.isAssignableFrom(toType)) {
                Collection collection = BasicTypeConverter.allocateCollection(toType);
                for (int i = 0; i < length; ++i) {
                    collection.add(Array.get(object, i));
                }
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value3 = Array.get(object, 0);
                return this.convert(value3, toType);
            }
            return this.convert("", toType);
        }
        if (object instanceof Collection) {
            int length = ((Collection)object).size();
            if (toType.isArray()) {
                Class<?> cType = toType.getComponentType();
                Object array = Array.newInstance(cType, length);
                Iterator it = ((Collection)object).iterator();
                for (int i = 0; i < length; ++i) {
                    Object value4 = it.next();
                    Array.set(array, i, this.convert(value4, cType));
                }
                return array;
            }
            if (Collection.class.isAssignableFrom(toType)) {
                Collection collection = BasicTypeConverter.allocateCollection(toType);
                collection.addAll((Collection)object);
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value5;
                if (object instanceof List) {
                    value5 = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value5 = it.next();
                }
                return this.convert(value5, toType);
            }
            return this.convert("", toType);
        }
        if (object instanceof NodeSet) {
            return this.convert(((NodeSet)object).getValues(), toType);
        }
        if (object instanceof Pointer) {
            return this.convert(((Pointer)object).getValue(), toType);
        }
        if (toType == String.class) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE) {
                return object;
            }
            boolean value6 = (Boolean)object;
            return BasicTypeConverter.allocateNumber(toType, value6 ? 1.0 : 0.0);
        }
        if (object instanceof Number) {
            double value7 = ((Number)object).doubleValue();
            if (toType == Boolean.TYPE || toType == Boolean.class) {
                return value7 == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (toType.isPrimitive() || Number.class.isAssignableFrom(toType)) {
                return BasicTypeConverter.allocateNumber(toType, value7);
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return object;
            }
        } else if (object instanceof String && (value = this.convertStringToPrimitive(object, toType)) != null) {
            return value;
        }
        throw new RuntimeException("Cannot convert " + object.getClass() + " to " + toType);
    }

    private Object convertNullToPrimitive(Class toType) {
        if (toType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toType == Character.TYPE) {
            return new Character('\u0000');
        }
        if (toType == Byte.TYPE) {
            return new Byte(0);
        }
        if (toType == Short.TYPE) {
            return new Short(0);
        }
        if (toType == Integer.TYPE) {
            return new Integer(0);
        }
        if (toType == Long.TYPE) {
            return new Long(0L);
        }
        if (toType == BigInteger.class) {
            return new BigInteger("0");
        }
        if (toType == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toType == Double.TYPE) {
            return new Double(0.0);
        }
        if (toType == BigDecimal.class) {
            return new BigDecimal(0.0);
        }
        return null;
    }

    private Object convertStringToPrimitive(Object object, Class toType) {
        if (toType == Boolean.TYPE || toType == Boolean.class) {
            return Boolean.valueOf((String)object);
        }
        if (toType == Character.TYPE || toType == Character.class) {
            return new Character(((String)object).charAt(0));
        }
        if (toType == Byte.TYPE || toType == Byte.class) {
            return new Byte((String)object);
        }
        if (toType == Short.TYPE || toType == Short.class) {
            return new Short((String)object);
        }
        if (toType == Integer.TYPE || toType == Integer.class) {
            return new Integer((String)object);
        }
        if (toType == Long.TYPE || toType == Long.class) {
            return new Long((String)object);
        }
        if (toType == BigInteger.class) {
            return new BigInteger((String)object);
        }
        if (toType == Float.TYPE || toType == Float.class) {
            return new Float((String)object);
        }
        if (toType == Double.TYPE || toType == Double.class) {
            return new Double((String)object);
        }
        if (toType == BigDecimal.class) {
            return new BigDecimal((String)object);
        }
        return null;
    }

    private static Number allocateNumber(Class type, double value) {
        if (type == Byte.class || type == Byte.TYPE) {
            return new Byte((byte)value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return new Short((short)value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new Integer((int)value);
        }
        if (type == BigInteger.class) {
            return new BigInteger(new Integer((int)value).toString());
        }
        if (type == Long.class || type == Long.TYPE) {
            return new Long((long)value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new Float((float)value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return new Double(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        return null;
    }

    private static boolean canCreateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() | 0x400) == 0) {
            return true;
        }
        if (type == List.class) {
            return true;
        }
        return type == Set.class;
    }

    private static Collection allocateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() | 0x400) == 0) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot create collection of type: " + type, ex);
            }
        }
        if (type == List.class) {
            return new ArrayList();
        }
        if (type == Set.class) {
            return new HashSet();
        }
        throw new RuntimeException("Cannot create collection of type: " + type);
    }

    private Collection unmodifiableCollection(Collection collection) {
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        return collection;
    }

    static final class ValuePointer
    implements Pointer {
        private Object bean;

        public ValuePointer(Object object) {
            this.bean = object;
        }

        public Object getValue() {
            return this.bean;
        }

        public Object getNode() {
            return this.bean;
        }

        public Object getRootNode() {
            return this.bean;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }

        public int compareTo(Object object) {
            return 0;
        }

        public String asPath() {
            if (this.bean == null) {
                return "null()";
            }
            if (this.bean instanceof Number) {
                String string = this.bean.toString();
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            if (this.bean instanceof Boolean) {
                return (Boolean)this.bean != false ? "true()" : "false()";
            }
            if (this.bean instanceof String) {
                return "'" + this.bean + "'";
            }
            return "{object of type " + this.bean.getClass().getName() + "}";
        }
    }

    static class ValueNodeSet
    implements NodeSet {
        private List values;
        private List pointers;

        public ValueNodeSet(List values) {
            this.values = values;
        }

        public List getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public List getNodes() {
            return Collections.unmodifiableList(this.values);
        }

        public List getPointers() {
            if (this.pointers == null) {
                this.pointers = new ArrayList();
                for (int i = 0; i < this.values.size(); ++i) {
                    this.pointers.add(new ValuePointer(this.values.get(i)));
                }
                this.pointers = Collections.unmodifiableList(this.pointers);
            }
            return this.pointers;
        }
    }
}

