/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.openide.explorer.propertysheet.InplaceEditor;

public class SheetTableOperator
extends JTableOperator {
    public SheetTableOperator() {
        super((ContainerOperator)Util.getMainWindow(), (ComponentChooser)new SheetTableChooser());
    }

    public SheetTableOperator(ContainerOperator container) {
        super(container, (ComponentChooser)new SheetTableChooser());
    }

    public void setCompareStyle(boolean compareExactly, boolean caseSensitive) {
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(compareExactly, caseSensitive));
    }

    private int findRow(String propName) {
        return this.findCell((JTableOperator.TableCellChooser)new PropertyCellChooser((String)propName), null, (int[])new int[]{0}, (int)0).y;
    }

    public void clickCell(String propName) {
        this.clickOnCell(this.findRow(propName), 1);
        this.clickOnCell(this.findRow(propName), 1);
    }

    public void startEditing(String propName) {
        this.clickCell(propName);
        this.pushKey(32);
    }

    public void pushDotted(String propName) {
        this.clickOnCell(this.findRow(propName), 0);
        TestUtils.wait(2000);
        this.pushKey(32, 2);
    }

    public String getValue(String propName) {
        return ((InplaceEditor)this.getRenderedComponent(this.findRow(propName), 1)).getValue().toString();
    }

    public void setValue(String propName, String value) {
        int row = this.findRow(propName);
        System.out.println("Class: " + ((InplaceEditor)this.getRenderedComponent(row, 1)).getClass());
    }

    public void setTextValue(String propName, String value) {
        this.startEditing(propName);
        new JTextComponentOperator((ContainerOperator)this).enterText(value);
        Util.wait(500);
    }

    public void setButtonValue(String propName, String value) {
        this.clickForEdit(this.findCell((String)propName, (int)2).y, 1);
        this.clickForEdit(this.findCell((String)propName, (int)2).y, 1);
        new JTextComponentOperator((ContainerOperator)this).enterText(value);
    }

    public void setComboBoxValue(String propName, String value) {
        this.clickOnCell(this.findRow(propName), 1);
        new JComboBoxOperator((ContainerOperator)this).selectItem(value);
    }

    public void setCheckBoxValue(String propName, String value) {
        if (!this.getValue(propName).equals(value)) {
            this.switchCheckBox(propName);
        }
    }

    public void switchCheckBox(String propName) {
        this.clickOnCell(this.findRow(propName), 1);
    }

    public void setImage(String componentID, String propertyName, String imagePath) {
        this.pushDotted(propertyName);
        JDialogOperator dialog1 = new JDialogOperator(componentID);
        new JButtonOperator((ContainerOperator)dialog1, Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"PropertySheet_AddFile")).pushNoBlock();
        JDialogOperator dialog2 = new JDialogOperator(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"PropertySheet_AddFile"));
        new JTextFieldOperator((ContainerOperator)dialog2, 0).setText(imagePath);
        Util.wait(1000);
        new JButtonOperator((ContainerOperator)dialog2, Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.gravy.Bundle", (String)"PropertySheet_AddFile")).pushNoBlock();
        dialog2.waitClosed();
        Util.wait(1000);
        new JButtonOperator((ContainerOperator)dialog1, "OK").pushNoBlock();
        dialog1.waitClosed();
    }

    public void selectCombo(String propName, String item) {
        int row = this.findRow(propName);
    }

    public String getSelectedComponentID() {
        this.setCompareStyle(true, true);
        String id = this.getValue("id");
        return id;
    }

    public String printAllProperties() {
        String output = "";
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object currentValue = null;
            String currentStringValue = "";
            String currentName = "";
            Component renderedComponent = null;
            currentName = ((JLabel)this.getRenderedComponent(row, 0)).getText();
            try {
                renderedComponent = this.getRenderedComponent(row, 1);
                currentValue = ((InplaceEditor)renderedComponent).getValue();
                try {
                    currentStringValue = (String)currentValue;
                }
                catch (ClassCastException e) {
                    currentStringValue = "Can't cast class " + currentValue.getClass().getName() + " to String. toString returns: \"" + currentValue.toString() + "\"";
                }
            }
            catch (ClassCastException e) {
                currentStringValue = renderedComponent instanceof TableCellRenderer ? "$TableCellRenderer" : "Can't cast class " + renderedComponent.getClass().getName() + " to InplaceEditor.";
            }
            output = output + "Property: " + currentName + "; Value: " + currentStringValue + "\r\n";
        }
        return output;
    }

    public static SheetTableOperator createInstance() {
        Util.getMainMenu().pushMenuNoBlock("Window|Properties");
        SheetTableOperator props = new SheetTableOperator();
        int propsCnt = props.getRowCount();
        Util.getMainMenu().pushMenuNoBlock("Window|Properties");
        if (propsCnt > props.getRowCount()) {
            Util.getMainMenu().pushMenuNoBlock("Window|Properties");
        }
        return props;
    }

    static class SheetTableChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp.getClass().getName().equals("org.openide.explorer.propertysheet.SheetTable");
        }

        public String getDescription() {
            return "org.openide.explorer.propertysheet.SheetTable";
        }
    }

    protected static class PropertyCellChooser
    implements JTableOperator.TableCellChooser {
        String text;

        public PropertyCellChooser(String text) {
            this.text = text;
        }

        public boolean checkCell(JTableOperator oper, int row, int column) {
            JLabel label = (JLabel)oper.getRenderedComponent(row, column);
            return label != null && oper.getComparator().equals(label.getText(), this.text);
        }

        public String getDescription() {
            return this.text + " property";
        }
    }
}

