/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Version;

@Version(value="@(#)Constants.java\t1.7 07/05/05")
public class Constants {
    public static Object decode(Object value, Type type) {
        if (value instanceof Integer) {
            int i = (Integer)value;
            switch (type.tag) {
                case 8: {
                    return i != 0;
                }
                case 2: {
                    return Character.valueOf((char)i);
                }
                case 1: {
                    return (byte)i;
                }
                case 3: {
                    return (short)i;
                }
            }
        }
        return value;
    }

    public static String format(Object value, Type type) {
        value = Constants.decode(value, type);
        switch (type.tag) {
            case 1: {
                return Constants.formatByte((Byte)value);
            }
            case 5: {
                return Constants.formatLong((Long)value);
            }
            case 6: {
                return Constants.formatFloat(((Float)value).floatValue());
            }
            case 7: {
                return Constants.formatDouble((Double)value);
            }
            case 2: {
                return Constants.formatChar(((Character)value).charValue());
            }
        }
        if (value instanceof String) {
            return Constants.formatString((String)value);
        }
        return value + "";
    }

    public static String format(Object value) {
        if (value instanceof Byte) {
            return Constants.formatByte((Byte)value);
        }
        if (value instanceof Long) {
            return Constants.formatLong((Long)value);
        }
        if (value instanceof Float) {
            return Constants.formatFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Constants.formatDouble((Double)value);
        }
        if (value instanceof Character) {
            return Constants.formatChar(((Character)value).charValue());
        }
        if (value instanceof String) {
            return Constants.formatString((String)value);
        }
        return value + "";
    }

    private static String formatByte(byte b) {
        return String.format("0x%02x", b);
    }

    private static String formatLong(long lng) {
        return lng + "L";
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return d + "";
    }

    private static String formatChar(char c) {
        return '\'' + Convert.quote(c) + '\'';
    }

    private static String formatString(String s) {
        return '\"' + Convert.quote(s) + '\"';
    }
}

