/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.workflow.model;

import com.sun.jbi.workflow.model.ModelElement;
import com.sun.jbi.workflow.model.ModelException;
import com.sun.jbi.workflow.model.XPathInfo;
import com.sun.jbi.workflow.model.xmlbeans.TDeadlineExpr;
import com.sun.jbi.workflow.model.xmlbeans.TDurationExpr;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointer;
import org.apache.commons.jxpath.ri.model.dom.DOMAttributePointer;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlDuration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static Date getDeadlineObject(TDeadlineExpr deadlineExp, JXPathContext jxpathContext) throws ModelException {
        Date deadline = null;
        try {
            Node domNode;
            if (deadlineExp != null && (domNode = deadlineExp.getDomNode()) != null) {
                String plainVal = ModelUtil.getText(domNode);
                String modified = ModelUtil.getStringValue(jxpathContext, plainVal, "");
                XmlDateTime dateTime = null;
                if (plainVal.trim().equals(modified)) {
                    dateTime = XmlDateTime.Factory.parse((Node)domNode);
                } else {
                    Node newNode = ModelUtil.createNewNode(domNode, modified);
                    dateTime = XmlDateTime.Factory.parse((Node)newNode);
                }
                deadline = dateTime.getDateValue();
            }
        }
        catch (Exception ex) {
            throw new ModelException(ex);
        }
        return deadline;
    }

    public static String getText(Node domNode) {
        NodeList children = domNode.getChildNodes();
        StringBuffer buffer = new StringBuffer();
        block4: for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            short type = node.getNodeType();
            switch (type) {
                case 4: {
                    buffer.append(node.getNodeValue());
                    continue block4;
                }
                case 3: {
                    buffer.append(node.getNodeValue());
                }
            }
        }
        return buffer.toString().trim();
    }

    public static GDuration getDurationObject(TDurationExpr durationExp, JXPathContext jxpathContext) throws ModelException {
        GDuration duration = null;
        try {
            Node durationNode;
            if (durationExp != null && (durationNode = durationExp.getDomNode()) != null) {
                String plainVal = ModelUtil.getText(durationNode);
                String modified = ModelUtil.getStringValue(jxpathContext, plainVal, "");
                XmlDuration xmlDuration = null;
                if (plainVal.trim().equals(modified)) {
                    xmlDuration = XmlDuration.Factory.parse((Node)durationNode);
                } else {
                    Node newNode = ModelUtil.createNewNode(durationNode, modified);
                    xmlDuration = XmlDuration.Factory.parse((Node)newNode);
                }
                duration = xmlDuration.getGDurationValue();
            }
        }
        catch (Exception ex) {
            throw new ModelException(ex);
        }
        return duration;
    }

    private static Node createNewNode(Node node, String text) {
        Element newNode = node.getOwnerDocument().createElementNS(node.getNamespaceURI(), node.getNodeName());
        newNode.appendChild(node.getOwnerDocument().createTextNode(text));
        return newNode;
    }

    public static Date getDurationDate(GDuration duration) throws ModelException {
        Calendar date = Calendar.getInstance();
        try {
            if (duration != null) {
                int year = duration.getYear();
                int month = duration.getMonth();
                int dayOfMonth = duration.getDay();
                int hour = duration.getHour();
                int minute = duration.getMinute();
                int second = duration.getSecond();
                BigDecimal fraction = duration.getFraction();
                date.add(1, year);
                date.add(2, month);
                date.add(5, dayOfMonth);
                date.add(11, hour);
                date.add(12, minute);
                date.add(13, second);
                date.add(14, fraction.intValue());
            }
        }
        catch (Exception ex) {
            throw new ModelException(ex);
        }
        return date.getTime();
    }

    public static XPathInfo generateXpathInfo(ModelElement element) {
        String parentXPath = "";
        HashMap<String, String> prefixToNS = new HashMap<String, String>();
        if (element.getParent() != null) {
            XPathInfo parentInfo = ModelUtil.generateXpathInfo(element.getParent());
            parentXPath = parentInfo.getXPath();
        }
        String xpath = parentXPath + "/" + ModelUtil.getLocalXPathName(element, prefixToNS);
        XPathInfo info = new XPathInfo(xpath, prefixToNS);
        return info;
    }

    public static String getLocalXPathName(ModelElement element, Map<String, String> prefixToNS) {
        List<ModelElement> children;
        StringBuffer localXPathBuf = new StringBuffer(50);
        QName elementQName = element.getQualifiedName();
        String localName = elementQName.getLocalPart();
        String namespace = elementQName.getNamespaceURI();
        String prefix = ModelUtil.getExistingPrefix(prefixToNS, namespace);
        if (prefix == null) {
            prefix = ModelUtil.generatePrefix(prefixToNS, namespace);
            prefixToNS.put(prefix, namespace);
        }
        localXPathBuf.append(prefix);
        localXPathBuf.append(":");
        localXPathBuf.append(localName);
        ModelElement parent = element.getParent();
        if (parent != null && (children = parent.getChildren()).size() > 1) {
            int total = children.size();
            int ind = 0;
            int j = 0;
            for (int i = 0; i < total; ++i) {
                ModelElement child = children.get(i);
                if (child == element) {
                    ind = j++;
                    continue;
                }
                if (!child.getQualifiedName().equals(element.getQualifiedName())) continue;
                ++j;
            }
            if (j == 1) {
                return localXPathBuf.toString();
            }
            localXPathBuf.append("[");
            localXPathBuf.append(ind + 1);
            localXPathBuf.append("]");
        }
        return localXPathBuf.toString();
    }

    public static NodeList executeXPath(String expression, Node source, Map<String, String> prefixToNS) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        if (prefixToNS != null) {
            DefaultNamespaceContext context = new DefaultNamespaceContext(prefixToNS);
            xPath.setNamespaceContext(context);
        }
        NodeList nodeList = (NodeList)xPath.evaluate(expression, source, XPathConstants.NODESET);
        return nodeList;
    }

    private static String generatePrefix(Map<String, String> prefixToNS, String namespace) {
        String prefix = null;
        String defaultPrefix = "ns";
        int counter = 1;
        prefix = defaultPrefix + counter;
        while (prefixToNS.keySet().contains(prefix)) {
            prefix = defaultPrefix + ++counter;
        }
        return prefix;
    }

    private static String getExistingPrefix(Map<String, String> prefixToNS, String namespace) {
        String prefix = null;
        for (String p : prefixToNS.keySet()) {
            String ns = prefixToNS.get(prefix);
            if (ns == null || !ns.equals(namespace)) continue;
            prefix = p;
            break;
        }
        return prefix;
    }

    public static String getStringValue(JXPathContext context, String expression, String delim) throws Exception {
        Object ptrObj = ModelUtil.evaluateExpression(expression, context);
        return ModelUtil.getStringValue(ptrObj, delim);
    }

    private static String getStringValue(Object ptr, String delim) {
        Object temp = ModelUtil.getSingleValueObject(ptr);
        String returnStr = null;
        StringBuffer buffer = new StringBuffer();
        if (temp instanceof Text) {
            returnStr = ((Text)temp).getNodeValue();
        } else {
            if (temp instanceof Element) {
                NodeList children = ((Element)temp).getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() == 3) {
                        buffer.append(((Text)child).getNodeValue());
                    }
                    if (i == children.getLength() - 1) continue;
                    buffer.append(delim);
                }
                return buffer.toString().trim();
            }
            if (temp instanceof Iterator) {
                boolean isFirst = true;
                while (((Iterator)temp).hasNext()) {
                    if (isFirst) {
                        buffer.append(ModelUtil.getStringValue(((Iterator)temp).next(), delim));
                        isFirst = false;
                        continue;
                    }
                    buffer.append(delim);
                    buffer.append(ModelUtil.getStringValue(((Iterator)temp).next(), delim));
                }
                return buffer.toString().trim();
            }
            returnStr = temp.toString();
        }
        return returnStr;
    }

    private static Object evaluateExpression(String expr, JXPathContext jxpathContext) throws Exception {
        Iterator it = jxpathContext.iteratePointers(expr);
        Object fromTemp = null;
        int i = 0;
        i = 0;
        while (it.hasNext()) {
            if (i == 0) {
                Pointer sourcePtr = (Pointer)it.next();
                fromTemp = sourcePtr instanceof BeanPointer || sourcePtr instanceof DOMAttributePointer ? sourcePtr.getValue() : sourcePtr.getNode();
            } else {
                it.next();
                fromTemp = null;
            }
            ++i;
        }
        if (fromTemp == null) {
            return jxpathContext.iteratePointers(expr);
        }
        return fromTemp;
    }

    private static Object getSingleValueObject(Object fromVal) {
        Object fromTemp = null;
        if (fromVal instanceof Pointer) {
            Pointer sourcePtr = (Pointer)fromVal;
            fromTemp = sourcePtr instanceof BeanPointer || sourcePtr instanceof DOMAttributePointer ? sourcePtr.getValue() : sourcePtr.getNode();
        }
        if (fromTemp != null) {
            fromVal = fromTemp;
        }
        return fromVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultNamespaceContext
    implements NamespaceContext {
        private Map<String, String> mPrefixToNSMap;

        DefaultNamespaceContext(Map<String, String> prefixToNSMap) {
            this.mPrefixToNSMap = prefixToNSMap;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.mPrefixToNSMap.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            for (String prefix : this.mPrefixToNSMap.keySet()) {
                String ns = this.mPrefixToNSMap.get(prefix);
                if (!namespaceURI.equals(ns)) continue;
                return prefix;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> prefixes = new ArrayList<String>();
            for (String prefix : this.mPrefixToNSMap.keySet()) {
                String ns = this.mPrefixToNSMap.get(prefix);
                if (!namespaceURI.equals(ns)) continue;
                prefixes.add(prefix);
            }
            return prefixes.iterator();
        }
    }
}

