/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Function;
import org.axiondb.Index;
import org.axiondb.IndexFactory;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TransactableTable;
import org.axiondb.constraints.BaseSelectableBasedConstraint;
import org.axiondb.constraints.CheckConstraint;
import org.axiondb.constraints.ForeignKeyConstraint;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.commands.CreateTableCommand;
import org.axiondb.engine.tables.BaseFlatfileTable;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.engine.visitors.TableColumnsUsedInFunctionVisitor;
import org.axiondb.io.FileUtil;
import org.axiondb.jdbc.AxionResultSet;

public class AlterTableCommand
extends BaseAxionCommand {
    private static int _idCounter = 0;
    private String _alterColumn;
    private boolean _cascade = false;
    private List _childCommands = new ArrayList(4);
    private CreateTableCommand _createTempTableCmd;
    private String _newTableName;
    private String _tableName;
    private String _origFlatFileName;
    private String _origFlatFileDir;
    private String _tempFileName;

    public AlterTableCommand(String theTableName, boolean cascade) {
        this._tableName = theTableName;
        this._cascade = cascade;
        this._createTempTableCmd = new CreateTableCommand(AlterTableCommand.generateName());
    }

    public void addChildCommand(AxionCommand cmd) {
        this._childCommands.add(cmd);
    }

    public void addColumn(String name, String type, String precision, String scale, Selectable defaultValue, String generated) {
        this._createTempTableCmd.addColumn(name, type, precision, scale, defaultValue, generated);
    }

    public void alterColumn(String name, String newName, Selectable newDefault, Boolean dropDefault) {
        this._createTempTableCmd.alterColumn(name, newName, newDefault, dropDefault);
        this._alterColumn = newName == null ? null : name;
    }

    public void dropColumn(String colName) {
        this._createTempTableCmd.excludeColumn(colName);
    }

    public boolean execute(Database db) throws AxionException {
        this.executeUpdate(db);
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use execute.");
    }

    public int executeUpdate(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        Table table = db.getTable(this._tableName);
        if (null == table) {
            throw new AxionException("Table " + this._tableName + " not found.");
        }
        List depedentViews = db.getDependentViews(this._tableName);
        if (depedentViews.size() > 0) {
            if (this._cascade) {
                db.dropDependentViews(depedentViews);
            } else {
                throw new AxionException("Can't Atlter Table/View: " + this._tableName + " has reference in another View...");
            }
        }
        if (this._newTableName != null) {
            db.renameTable(this._tableName, this._newTableName);
            this.setEffectedRowCount(0);
            return 0;
        }
        this._createTempTableCmd.setSourceTable(table);
        List indexesToAdd = this.checkAndMigrateIndexes(db, table);
        List constraintToAdd = this.checkAndMigrateConstraints(table);
        this.handleExternalTable(table);
        this._createTempTableCmd.execute(db);
        table.shutdown();
        db.dropTable(this._tableName);
        if (this._origFlatFileDir != null) {
            Properties prop = new Properties();
            prop.put(BaseFlatfileTable.PARAM_KEY_FILE_DIR, this._origFlatFileDir);
            prop.put(BaseFlatfileTable.PARAM_KEY_FILE_NAME, this._origFlatFileName);
            prop.put(BaseFlatfileTable.PARAM_KEY_TEMP_FILE_NAME, this._tempFileName);
            db.renameTable(this._createTempTableCmd.getObjectName(), this._tableName, prop);
        } else {
            db.renameTable(this._createTempTableCmd.getObjectName(), this._tableName);
        }
        table = db.getTable(this._tableName);
        Iterator iter = indexesToAdd.iterator();
        while (iter.hasNext()) {
            db.addIndex((Index)iter.next(), table, true);
        }
        iter = constraintToAdd.iterator();
        while (iter.hasNext()) {
            table.addConstraint((Constraint)iter.next());
        }
        for (AxionCommand cmd : this._childCommands) {
            cmd.execute(db);
        }
        int rowcount = table.getRowCount();
        this.setEffectedRowCount(rowcount);
        return rowcount;
    }

    public void setRenameTo(String newName) {
        this._newTableName = newName;
    }

    private List checkAndMigrateConstraints(Table table) throws AxionException {
        ArrayList constraintToAdd = new ArrayList();
        Iterator iter = table.getConstraints();
        while (iter.hasNext()) {
            Constraint constraint = (Constraint)iter.next();
            if (constraint instanceof ForeignKeyConstraint) {
                ForeignKeyConstraint fk = (ForeignKeyConstraint)constraint;
                List cols = Collections.EMPTY_LIST;
                if (this._tableName.equals(fk.getParentTableName())) {
                    cols = fk.getParentTableColumns();
                } else if (this._tableName.equals(fk.getChildTableName())) {
                    cols = fk.getChildTableColumns();
                }
                this.checkColumnReference(constraintToAdd, (Constraint)fk, cols);
                continue;
            }
            if (constraint instanceof BaseSelectableBasedConstraint) {
                BaseSelectableBasedConstraint c = (BaseSelectableBasedConstraint)constraint;
                int K = c.getSelectableCount();
                for (int k = 0; k < K; ++k) {
                    this.checkColumnReference(table, constraintToAdd, c, c.getSelectable(k));
                }
                continue;
            }
            if (constraint instanceof CheckConstraint) {
                this.checkColumnReference(table, constraintToAdd, constraint, ((CheckConstraint)constraint).getCondition());
                continue;
            }
            if (this._alterColumn == null || this._cascade) continue;
            throw new AxionException("Can't drop/alter Column: " + constraint.getName() + " might have reference ");
        }
        return constraintToAdd;
    }

    private List checkAndMigrateIndexes(Database db, Table table) throws AxionException {
        ArrayList<Index> indexesToAdd = new ArrayList<Index>();
        Iterator iter = table.getIndices();
        while (iter.hasNext()) {
            Index i = (Index)iter.next();
            Column col = i.getIndexedColumn();
            if (this._createTempTableCmd.isColumnEexcluded(col.getName()) && !this._cascade) {
                throw new AxionException("Can't drop Column: Index exist for " + col.getName());
            }
            if (col.getName().equals(this._alterColumn) && !this._cascade) {
                throw new AxionException("Can't alter Column: Index exist for " + col.getName());
            }
            if (this._createTempTableCmd.isColumnEexcluded(col.getName()) || col.getName().equals(this._alterColumn)) continue;
            IndexFactory factory = db.getIndexFactory(i.getType());
            Index index = factory.makeNewInstance(i.getName(), col, i.isUnique(), db.getDBDirectory() == null);
            indexesToAdd.add(index);
        }
        return indexesToAdd;
    }

    private void checkColumnReference(List constraintToAdd, Constraint c, Collection cols) throws AxionException {
        Iterator i = cols.iterator();
        while (i.hasNext()) {
            this.checkColumnReference(constraintToAdd, c, (ColumnIdentifier)i.next());
        }
    }

    private void checkColumnReference(List constraintToAdd, Constraint c, ColumnIdentifier col) throws AxionException {
        if (this._createTempTableCmd.isColumnEexcluded(col.getName()) && !this._cascade) {
            throw new AxionException("Can't drop Column: " + col.getName() + " used in constraint " + c.getName());
        }
        if (col.getName().equals(this._alterColumn) && !this._cascade) {
            throw new AxionException("Can't alter Column: " + col.getName() + " used in constraint " + c.getName());
        }
        if (!this._createTempTableCmd.isColumnEexcluded(col.getName()) && !col.getName().equals(this._alterColumn)) {
            constraintToAdd.add(c);
        }
    }

    private void checkColumnReference(Table table, List constraintToAdd, Constraint c, Selectable sel) throws AxionException {
        if (sel instanceof ColumnIdentifier) {
            this.checkColumnReference(constraintToAdd, c, (ColumnIdentifier)sel);
        } else if (sel instanceof Function) {
            TableColumnsUsedInFunctionVisitor visitor = new TableColumnsUsedInFunctionVisitor();
            visitor.visit((Function)sel, table);
            this.checkColumnReference(constraintToAdd, c, visitor.getColumnsUsedInFunction());
        }
    }

    private void handleExternalTable(Table table) {
        String origDataFilePath = null;
        String dirPath = null;
        if (table instanceof ExternalDatabaseTable) {
            return;
        }
        while (table instanceof TransactableTable) {
            table = ((TransactableTable)table).getTable();
        }
        if (table instanceof ExternalTable) {
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)((ExternalTable)table).getTableProperties());
            origDataFilePath = prop.getProperty("FILENAME");
            if (origDataFilePath != null) {
                dirPath = FileUtil.getDirecoryFromPath(origDataFilePath);
                if (dirPath != null) {
                    prop.put("FILENAME", dirPath + this._createTempTableCmd.getObjectName());
                    this._origFlatFileName = origDataFilePath.substring(dirPath.length());
                    this._origFlatFileDir = dirPath;
                    this._tempFileName = this._createTempTableCmd.getObjectName();
                } else {
                    prop.remove("FILENAME");
                }
            }
            if (this._newTableName == null && prop.get("CREATE_IF_NOT_EXIST") != null) {
                prop.put("CREATE_IF_NOT_EXIST", "TRUE");
            }
            this._createTempTableCmd.setProperties(prop);
            this._createTempTableCmd.setType("EXTERNAL");
        }
    }

    private static String generateName() {
        return "TEMP_" + Long.toHexString(System.currentTimeMillis()).toUpperCase() + _idCounter++;
    }
}

