/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionCommand;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.commands.DMLWhenClause;
import org.axiondb.engine.commands.InsertIntoClause;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.jdbc.AxionResultSet;
import org.axiondb.util.ValuePool;

public class InsertCommand
extends BaseAxionCommand {
    public static final int WHEN_ALL = 1;
    public static final int WHEN_FIRST = 2;
    private ElseClause _elseClause;
    private int _evaluationMode = 1;
    private List _insertIntoList = new ArrayList(2);
    private boolean _resolved = false;
    private InsertSingleRow _simpleInsert;
    private transient RowDecorator _srcDec;
    private Table _source;
    private TableIdentifier _sourceId;
    private SubSelectCommand _subQuery;

    public InsertCommand() {
    }

    public InsertCommand(TableIdentifier table, List columns, AxionCommand subSelect) {
        this(table, columns, (SubSelectCommand)subSelect);
    }

    public InsertCommand(TableIdentifier table, List columns, SubSelectCommand subSelect) {
        this._subQuery = subSelect;
        InsertMultipleRow ip = new InsertMultipleRow(null, table, columns, null);
        this._insertIntoList.add(ip);
    }

    public InsertCommand(TableIdentifier table, List columns, List values) {
        this._simpleInsert = new InsertSingleRow(table, columns, values);
    }

    public InsertCommand(TableIdentifier table, List columns, boolean defaultVAlues) {
        this._simpleInsert = new InsertSingleRow(table, columns, defaultVAlues);
    }

    public void addInsertIntoClause(DMLWhenClause when, TableIdentifier table, List columns, List values) {
        InsertMultipleRow into = new InsertMultipleRow(when, table, columns, values);
        this._insertIntoList.add(into);
    }

    public final boolean isInsertIntoListEmpty() {
        return this._insertIntoList.isEmpty();
    }

    public boolean execute(Database database) throws AxionException {
        this.executeUpdate(database);
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use executeUpdate.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        this.preProcess(db);
        this.resolve(db);
        int count = 0;
        try {
            count = this._insertIntoList.size() != 0 ? this.handleMultiTableInsert(db) : this._simpleInsert.insertRow(db);
        }
        finally {
            if (this._source != null) {
                db.dropTable(this._source.getName());
            }
        }
        this.setEffectedRowCount(count);
        return count;
    }

    public final Iterator getColumnIterator() {
        return this._simpleInsert.getColumnIterator();
    }

    public final TableIdentifier getTable() {
        return this._simpleInsert.getTargetTableId();
    }

    public final Iterator getValueIterator() {
        return this._simpleInsert.getValueIterator();
    }

    public void setElseClause(TableIdentifier table, List tableColumns, List tableValues) {
        this._elseClause = new ElseClause(table, tableColumns, tableValues);
    }

    public void setMultiTableEvaluationMode(int mode) {
        this._evaluationMode = mode;
    }

    public void setSubSelect(SubSelectCommand select) {
        this._subQuery = select;
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        int I = this._insertIntoList.size();
        for (int i = 0; i < I; ++i) {
            this.getBindVariableVisitor().visit((InsertIntoClause)this._insertIntoList.get(i));
        }
        if (this._elseClause != null) {
            this.getBindVariableVisitor().visit(this._elseClause);
        }
        if (this._simpleInsert != null) {
            this.getBindVariableVisitor().visit(this._simpleInsert);
        }
        if (this._subQuery != null) {
            this.getBindVariableVisitor().visit(this._subQuery);
        }
    }

    private RowDecorator buildDecorator() {
        if (this._srcDec == null) {
            int size = this._source.getColumnCount();
            HashMap<ColumnIdentifier, Integer> colToIndexMap = new HashMap<ColumnIdentifier, Integer>(size);
            for (int i = 0; i < size; ++i) {
                Column col = this._source.getColumn(i);
                colToIndexMap.put(new ColumnIdentifier(this._sourceId, col.getName(), null, col.getDataType()), ValuePool.getInt(i));
            }
            this._srcDec = new RowDecorator(colToIndexMap);
        }
        return this._srcDec;
    }

    private final int getMultiTableEvaluationMode() {
        return this._evaluationMode;
    }

    private final TableIdentifier getSourceTableId() {
        return this._sourceId;
    }

    private final Table getSourceTable() {
        return this._source;
    }

    private int handleMultiTableInsert(Database db) throws AxionException {
        RowDecorator dec = this.buildDecorator();
        RowIterator rowItr = this._source.getRowIterator(false);
        while (rowItr.hasNext()) {
            Row row = rowItr.next();
            dec.setRow(row);
            boolean isAtLeastOneMatched = false;
            int I = this._insertIntoList.size();
            for (int i = 0; i < I; ++i) {
                if (((InsertIntoClause)this._insertIntoList.get(i)).insertMatchingRow(db, dec, row)) {
                    isAtLeastOneMatched = true;
                }
                if (isAtLeastOneMatched && this.getMultiTableEvaluationMode() == 2) break;
            }
            if (isAtLeastOneMatched || this._elseClause == null) continue;
            this._elseClause.insertMatchingRow(db, dec, row);
        }
        int count = 0;
        int I = this._insertIntoList.size();
        for (int i = 0; i < I; ++i) {
            InsertIntoClause insertClause = (InsertIntoClause)this._insertIntoList.get(i);
            count += insertClause.getProcessedRowCount();
        }
        return count;
    }

    private void preProcess(Database db) throws AxionException {
        if (null != this._subQuery) {
            this._source = this._subQuery.getTableView(db, null, true);
            this._sourceId = new TableIdentifier(this._source.getName(), this._subQuery.getAlias());
            this._source = db.getTable(this._sourceId);
        }
        int I = this._insertIntoList.size();
        for (int i = 0; i < I; ++i) {
            InsertIntoClause insertClause = (InsertIntoClause)this._insertIntoList.get(i);
            insertClause.preProcess(db);
        }
        if (this._simpleInsert != null) {
            this._simpleInsert.preProcess(db);
        }
        if (this._elseClause != null) {
            this._elseClause.preProcess(db);
        }
    }

    protected void resolve(Database db) throws AxionException {
        if (!this._resolved) {
            if (this._insertIntoList.size() == 0) {
                this._simpleInsert.resolve(db);
            } else {
                if (this._elseClause != null) {
                    this._elseClause.resolve(db);
                }
                int I = this._insertIntoList.size();
                for (int i = 0; i < I; ++i) {
                    ((InsertIntoClause)this._insertIntoList.get(i)).resolve(db);
                }
            }
            this._resolved = true;
        }
    }

    private class InsertSingleRow
    extends InsertIntoClause {
        public InsertSingleRow(TableIdentifier tid, List cols, List vals) {
            super(null, tid, cols, vals);
        }

        public InsertSingleRow(TableIdentifier tid, List cols, boolean defaultValues) {
            super(null, tid, cols, defaultValues);
        }

        public int insertRow(Database db) throws AxionException {
            this.addRowToTable(db, null, this.makeRowDecorator());
            return 1;
        }

        public void resolve(Database db) throws AxionException {
            if (this.getColumnCount() > this.getValueCount() && this.getColumnCount() != 0) {
                throw new IllegalArgumentException("Number of columns and values must match.");
            }
            super.resolve(db);
            this.resolveSelectableList(this.getValues(), db, this.getTargetTableId());
            if (this.getColumnCount() < this.getValueCount()) {
                throw new IllegalArgumentException("Too Many Values...");
            }
        }
    }

    private class InsertMultipleRow
    extends InsertIntoClause {
        private boolean _isTargetPartOfSubQuery;

        public InsertMultipleRow(DMLWhenClause when, TableIdentifier tid, List cols, List vals) {
            super(when, tid, cols, vals);
            this._isTargetPartOfSubQuery = false;
        }

        protected boolean isTargetTablePartOfSubQuery() throws AxionException {
            return this._isTargetPartOfSubQuery;
        }

        protected void resolve(Database db) throws AxionException {
            super.resolve(db);
            DMLWhenClause when = this.getWhenClause();
            if (when != null) {
                when.resolve(db, new TableIdentifier[]{InsertCommand.this.getSourceTableId()});
            }
            this._isTargetPartOfSubQuery = InsertCommand.this._subQuery.getQueryContext().isTablePartOfSelect(this.getTargetTableId());
            this.resolveSelectableList(this.getValues(), db, InsertCommand.this.getSourceTableId());
            this.assertRules(InsertCommand.this.getSourceTable());
        }
    }

    private class ElseClause
    extends InsertMultipleRow {
        public ElseClause(TableIdentifier tid, List cols, List vals) {
            super(null, tid, cols, vals);
        }
    }
}

