/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.io.File;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.Literal;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.BaseAxionCommand;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.jdbc.AxionResultSet;

public class RemountCommand
extends BaseAxionCommand {
    private Object _dir;
    private TableIdentifier _table;
    private boolean _dataFilesOnly = false;

    public void setDirectory(String dir) {
        this._dir = dir;
    }

    public void setDirectory(Literal dir) {
        this._dir = dir;
    }

    public Object getDirectory() {
        return this._dir;
    }

    public void setTable(TableIdentifier table) {
        this._table = table;
    }

    public TableIdentifier getTable() {
        return this._table;
    }

    public void setDataFilesOnly(boolean data) {
        this._dataFilesOnly = data;
    }

    public boolean getDataFilesOnly() {
        return this._dataFilesOnly;
    }

    public boolean execute(Database db) throws AxionException {
        if (null == this._table) {
            this.remountDatabase(db);
        } else {
            this.remountTable(db);
        }
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use execute.");
    }

    public int executeUpdate(Database database) throws AxionException {
        this.execute(database);
        return 0;
    }

    public String toString() {
        return "REMOUNT(" + this._dir + ")";
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        this.getBindVariableVisitor().visit((Selectable)this._dir);
    }

    private void remountDatabase(Database db) throws AxionException {
        if (this._dir == null) {
            throw new AxionException("Usage: REMOUNT [table-name] [DATA] path");
        }
        db.remount(new File(this.getPath()));
    }

    private void remountTable(Database db) throws AxionException {
        Table table = db.getTable(this._table);
        if (null == table) {
            throw new AxionException("Table " + this._table + " not found.");
        }
        if (table instanceof ExternalTable) {
            ((ExternalTable)table).remount();
        } else {
            File path = this._dir == null ? null : new File(this.getPath());
            table.remount(path, this._dataFilesOnly);
        }
    }

    private String getPath() throws AxionException {
        String path = null;
        path = this._dir instanceof Literal ? (String)((Literal)this._dir).evaluate(null) : (String)this._dir;
        return path;
    }
}

