/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;

public class NotFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType BOOLEAN_TYPE = new BooleanType();

    public NotFunction() {
        super("NOT");
    }

    public ConcreteFunction makeNewInstance() {
        return new NotFunction();
    }

    public DataType getDataType() {
        return BOOLEAN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object rawValue = this.getArgument(0).evaluate(row);
        DataType type = this.getArgument(0).getDataType();
        Object val = type.convert(rawValue);
        if (null == val) {
            return null;
        }
        return type.toBoolean(val) ? Boolean.FALSE : Boolean.TRUE;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

