/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;

public class RowNumFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType INT_TYPE = new IntegerType();

    public RowNumFunction() {
        super("ROWNUM");
    }

    public ConcreteFunction makeNewInstance() {
        return new RowNumFunction();
    }

    public DataType getDataType() {
        return INT_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        return new Integer(row.getRowIndex() + 1);
    }

    public boolean isValid() {
        return this.getArgumentCount() == 0;
    }
}

