/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.XMLReaderImpl;
import com.sun.xml.stream.events.AttributeImpl;
import com.sun.xml.stream.events.NamespaceImpl;
import com.sun.xml.stream.xerces.util.NamespaceContextWrapper;
import com.sun.xml.stream.xerces.util.NamespaceSupport;
import com.sun.xml.stream.xerces.util.XMLChar;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamFilterImpl
implements XMLStreamReader {
    private StreamFilter fStreamFilter = null;
    private XMLStreamReader fStreamReader = null;
    private int fCurrentEventType = -1;
    private QName fElementName = null;
    private String fLocalName = null;
    private boolean fHasName = false;
    private boolean fReadNext = true;
    private boolean fHasMoreEvents = true;
    private boolean fReadFromCache = true;
    private ArrayList fCachedAttributes = null;
    private ArrayList fCachedNamespaceAttr = null;
    private NamespaceContextWrapper fCachedNamespaceContext = null;
    private String fCachedElementText = null;
    private int fCachedEventType = -1;
    private String fCachedVersion = null;
    private String fCachedEncoding = null;
    private boolean fCachedStandalone = false;
    private Location fCachedLocation = null;
    private String fCachedTextValue = null;
    private String fCachedPITarget = null;
    private String fCachedPIData = null;
    private String fCachedCharEncoding = null;
    private static boolean DEBUG = false;

    public XMLStreamFilterImpl(XMLStreamReader reader, StreamFilter filter) {
        this.fStreamReader = reader;
        this.fStreamFilter = filter;
        this.fCachedAttributes = new ArrayList();
        this.fCachedNamespaceAttr = new ArrayList();
        try {
            if (!this.fStreamFilter.accept(this.fStreamReader)) {
                this.next();
                this.cache();
            }
        }
        catch (XMLStreamException xs) {
            System.err.println("Error while creating a stream Filter" + xs);
        }
        this.fCurrentEventType = this.fStreamReader.getEventType();
        if (DEBUG) {
            System.out.println("Cached Event" + this.fCachedEventType);
        }
    }

    protected void setStreamFilter(StreamFilter sf) {
        this.fStreamFilter = sf;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.fReadNext) {
            this.fReadNext = false;
            this.cache();
            if (DEBUG) {
                System.out.println("Cached Event in hasNext" + this.fCachedEventType);
            }
            return this.readNext();
        }
        return this.fHasMoreEvents;
    }

    public void close() throws XMLStreamException {
        this.fStreamReader.close();
    }

    public int getAttributeCount() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeCount();
        }
        return this.fCachedAttributes.size();
    }

    public QName getAttributeName(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeName(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getName();
        }
        return null;
    }

    public String getAttributeNamespace(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeNamespace(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getName().getNamespaceURI();
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributePrefix(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getName().getPrefix();
        }
        return null;
    }

    public String getAttributeType(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeType(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getDTDType();
        }
        return null;
    }

    public String getAttributeValue(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeValue(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeValue(namespaceURI, localName);
        }
        if (this.fCachedEventType != 1 || this.fCachedEventType != 10) {
            throw new IllegalStateException("Current event state is " + this.fCachedEventType);
        }
        for (int i = 0; i < this.fCachedAttributes.size(); ++i) {
            AttributeImpl attr = (AttributeImpl)this.fCachedAttributes.get(i);
            if (attr == null || !attr.getName().getLocalPart().equals(localName) || !namespaceURI.equals(attr.getName().getNamespaceURI())) continue;
            return attr.getValue();
        }
        return null;
    }

    public String getCharacterEncodingScheme() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getCharacterEncodingScheme();
        }
        return this.fCachedCharEncoding;
    }

    public String getElementText() throws XMLStreamException {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getElementText();
        }
        if (this.fCachedEventType != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        return this.fCachedElementText;
    }

    public String getEncoding() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getEncoding();
        }
        return this.fCachedEncoding;
    }

    public int getEventType() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getEventType();
        }
        return this.fCachedEventType;
    }

    public String getLocalName() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getLocalName();
        }
        return this.fLocalName;
    }

    public Location getLocation() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getLocation();
        }
        return this.fCachedLocation;
    }

    public QName getName() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getName();
        }
        if (this.fCachedEventType == 1 || this.fCachedEventType == 2) {
            return this.fElementName;
        }
        throw new IllegalArgumentException("Illegal to call getName() when event type is " + this.fCachedEventType);
    }

    public NamespaceContext getNamespaceContext() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceContext();
        }
        return this.fCachedNamespaceContext;
    }

    public int getNamespaceCount() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceCount();
        }
        if (this.fCachedEventType == 1 || this.fCachedEventType == 2 || this.fCachedEventType == 13) {
            return this.fCachedNamespaceAttr.size();
        }
        throw new IllegalStateException("Current event state is " + this.fCachedEventType);
    }

    public String getNamespacePrefix(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespacePrefix(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getName().getPrefix();
        }
        return null;
    }

    public String getNamespaceURI() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceURI();
        }
        if ((this.fCachedEventType == 1 || this.fCachedEventType == 2) && this.fElementName != null) {
            return this.fElementName.getNamespaceURI();
        }
        return null;
    }

    public String getNamespaceURI(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceURI(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.getName().getNamespaceURI();
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getNamespaceURI();
        }
        return this.fCachedNamespaceContext.getNamespaceURI(prefix);
    }

    public String getPIData() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getPIData();
        }
        return this.fCachedPIData;
    }

    public String getPITarget() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getPITarget();
        }
        return this.fCachedPITarget;
    }

    public String getPrefix() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getPrefix();
        }
        if (this.fCachedEventType == 1 || this.fCachedEventType == 2) {
            return this.fElementName.getPrefix();
        }
        return null;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.fStreamReader.getProperty(name);
    }

    public String getText() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getText();
        }
        return this.fCachedTextValue;
    }

    public char[] getTextCharacters() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextCharacters();
        }
        if (this.fCachedTextValue != null) {
            return this.fCachedTextValue.toCharArray();
        }
        return null;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextCharacters(sourceStart, target, targetStart, length);
        }
        if (target == null) {
            throw new NullPointerException("target char array can't be null");
        }
        if (targetStart < 0 || length < 0 || sourceStart < 0 || targetStart >= target.length || targetStart + length > target.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.fCachedTextValue == null) {
            return 0;
        }
        int copiedLength = 0;
        int available = this.fCachedTextValue.length() - sourceStart;
        if (available < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
        }
        copiedLength = available < length ? available : length;
        System.arraycopy(this.fCachedTextValue, sourceStart, target, targetStart, copiedLength);
        return copiedLength;
    }

    public int getTextLength() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextLength();
        }
        if (this.fCachedTextValue != null) {
            return this.fCachedTextValue.length();
        }
        return 0;
    }

    public int getTextStart() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getTextStart();
        }
        return 0;
    }

    public String getVersion() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getVersion();
        }
        return this.fCachedVersion;
    }

    public boolean hasName() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.hasName();
        }
        return this.fCachedEventType == 1 || this.fCachedEventType == 2 || this.fCachedEventType == 9 || this.fCachedEventType == 3;
    }

    public boolean hasText() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.hasText();
        }
        return this.fCachedTextValue != null;
    }

    public boolean isAttributeSpecified(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isAttributeSpecified(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            return attr.isSpecified();
        }
        return false;
    }

    public boolean isCharacters() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isCharacters();
        }
        return this.fCachedEventType == 4;
    }

    public boolean isEndElement() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isEndElement();
        }
        return this.fCachedEventType == 2;
    }

    public boolean isStandalone() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isStandalone();
        }
        return this.fCachedStandalone;
    }

    public boolean isStartElement() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isStartElement();
        }
        return this.fCachedEventType == 1;
    }

    public boolean isWhiteSpace() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.isWhiteSpace();
        }
        if (this.isCharacters() || this.fCachedEventType == 12) {
            if (this.fCachedTextValue == null) {
                return false;
            }
            char[] ch = this.fCachedTextValue.toCharArray();
            int start = 0;
            int length = this.fCachedTextValue.length();
            for (int i = start; i < length; ++i) {
                if (XMLChar.isSpace(ch[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int next() throws XMLStreamException {
        if (this.fReadNext) {
            if (this.readNext()) {
                this.fReadFromCache = false;
            }
        } else {
            this.fReadNext = true;
            this.fReadFromCache = false;
        }
        return this.fCurrentEventType;
    }

    public int nextTag() throws XMLStreamException {
        if (this.fReadNext) {
            if (this.readNextTag()) {
                this.fReadFromCache = false;
            }
        } else {
            this.fReadNext = true;
            if (this.fCurrentEventType != 1 || this.fCurrentEventType != 2) {
                this.fCurrentEventType = this.fStreamReader.nextTag();
                this.fReadFromCache = false;
            }
        }
        return this.fCurrentEventType;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (!this.fReadFromCache) {
            this.fStreamReader.require(type, namespaceURI, localName);
        } else {
            if (type != this.fCachedEventType) {
                throw new XMLStreamException("Event type " + XMLReaderImpl.getEventTypeString(type) + " specified did not match with current parser event");
            }
            if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
                throw new XMLStreamException("Namespace URI " + namespaceURI + " specified did not match with current namespace URI");
            }
            if (localName != null && !localName.equals(this.getLocalName())) {
                throw new XMLStreamException("LocalName " + localName + " specified did not match with current local name");
            }
        }
    }

    public boolean standaloneSet() {
        if (!this.fReadFromCache) {
            return this.fStreamReader.standaloneSet();
        }
        return this.fCachedStandalone;
    }

    public String getAttributeLocalName(int index) {
        if (!this.fReadFromCache) {
            return this.fStreamReader.getAttributeLocalName(index);
        }
        AttributeImpl attr = this.getCachedAttribute(index);
        if (attr != null) {
            attr.getName().getLocalPart();
        }
        return null;
    }

    private void cache() {
        this.fReadFromCache = true;
        this.fCachedEventType = this.fCurrentEventType;
        this.clearCache();
        this.fCachedLocation = this.fStreamReader.getLocation();
        switch (this.fCurrentEventType) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                this.fCachedTextValue = this.fStreamReader.getText();
                break;
            }
            case 11: {
                this.fCachedTextValue = this.fStreamReader.getText();
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                this.fElementName = this.fStreamReader.getName();
                this.fHasName = this.fStreamReader.hasName();
                this.fLocalName = this.fElementName.getLocalPart();
                this.cacheNamespaceContext();
                break;
            }
            case 15: {
                break;
            }
            case 14: {
                break;
            }
            case 9: {
                this.fLocalName = this.fStreamReader.getLocalName();
                this.fCachedTextValue = this.fStreamReader.getText();
                break;
            }
            case 3: {
                this.fCachedPIData = this.fStreamReader.getPIData();
                this.fCachedPITarget = this.fStreamReader.getPITarget();
                break;
            }
            case 7: {
                this.fCachedVersion = this.fStreamReader.getVersion();
                this.fCachedEncoding = this.fStreamReader.getEncoding();
                this.fCachedStandalone = this.fStreamReader.isStandalone();
                this.fCachedCharEncoding = this.fStreamReader.getCharacterEncodingScheme();
                break;
            }
            case 1: {
                try {
                    this.fElementName = this.fStreamReader.getName();
                    this.fHasName = this.fStreamReader.hasName();
                    this.fLocalName = this.fElementName.getLocalPart();
                    if (DEBUG) {
                        System.out.println("Name is " + this.fLocalName);
                        System.out.println("Name is " + this.fElementName);
                    }
                    this.cacheAttributes();
                    this.cacheNamespaceAttributes();
                    this.cacheNamespaceContext();
                    if (!this.fStreamReader.hasText()) break;
                    this.fCachedElementText = this.fStreamReader.getElementText();
                    break;
                }
                catch (Exception ex) {
                    System.err.println("Error occurred while trying to cache START_ELEMENT" + ex.getMessage());
                }
            }
        }
    }

    private boolean readNext() throws XMLStreamException {
        while (this.fStreamReader.hasNext()) {
            this.fStreamReader.next();
            this.fHasMoreEvents = this.fStreamFilter.accept(this.fStreamReader);
            if (!this.fHasMoreEvents) continue;
            this.fCurrentEventType = this.fStreamReader.getEventType();
            return true;
        }
        return false;
    }

    private boolean readNextTag() throws XMLStreamException {
        while (this.fStreamReader.hasNext()) {
            this.fStreamReader.nextTag();
            this.fHasMoreEvents = this.fStreamFilter.accept(this.fStreamReader);
            if (!this.fHasMoreEvents) continue;
            this.fCurrentEventType = this.fStreamReader.getEventType();
            return true;
        }
        return false;
    }

    private void cacheAttributes() {
        int len = this.fStreamReader.getAttributeCount();
        QName qname = null;
        String prefix = null;
        String localpart = null;
        AttributeImpl attr = null;
        this.fCachedAttributes.clear();
        for (int i = 0; i < len; ++i) {
            qname = this.fStreamReader.getAttributeName(i);
            prefix = qname.getPrefix();
            localpart = qname.getLocalPart();
            attr = new AttributeImpl();
            attr.setName(qname);
            attr.setAttributeType(this.fStreamReader.getAttributeType(i));
            attr.setSpecified(this.fStreamReader.isAttributeSpecified(i));
            attr.setValue(this.fStreamReader.getAttributeValue(i));
            this.fCachedAttributes.add(attr);
        }
    }

    protected void cacheNamespaceAttributes() {
        int count = this.fStreamReader.getNamespaceCount();
        String uri = null;
        String prefix = null;
        NamespaceImpl attr = null;
        this.fCachedNamespaceAttr.clear();
        for (int i = 0; i < count; ++i) {
            uri = this.fStreamReader.getNamespaceURI(i);
            prefix = this.fStreamReader.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            attr = new NamespaceImpl(prefix, uri);
            this.fCachedNamespaceAttr.add(attr);
        }
    }

    private void cacheNamespaceContext() {
        NamespaceContextWrapper nc = (NamespaceContextWrapper)this.fStreamReader.getNamespaceContext();
        NamespaceSupport ns = new NamespaceSupport(nc.getNamespaceContext());
        this.fCachedNamespaceContext = new NamespaceContextWrapper(ns);
    }

    private AttributeImpl getCachedAttribute(int index) {
        if (this.fCachedEventType == 1 || this.fCachedEventType == 10) {
            if (index < this.fCachedAttributes.size()) {
                return (AttributeImpl)this.fCachedAttributes.get(index);
            }
        } else {
            throw new IllegalStateException("Current event state is " + this.fCachedEventType);
        }
        return null;
    }

    private void clearCache() {
        this.fCachedAttributes.clear();
        this.fCachedNamespaceAttr.clear();
        this.fCachedNamespaceContext = null;
        this.fCachedElementText = null;
        this.fCachedVersion = null;
        this.fCachedEncoding = null;
        this.fCachedLocation = null;
        this.fCachedTextValue = null;
        this.fCachedPITarget = null;
        this.fCachedPIData = null;
        this.fCachedCharEncoding = null;
        this.fElementName = null;
        this.fHasName = false;
        this.fLocalName = null;
    }
}

