/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.writers;

import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.util.ReadOnlyIterator;
import com.sun.xml.stream.writers.WriterUtility;
import com.sun.xml.stream.xerces.util.NamespaceSupport;
import com.sun.xml.stream.xerces.util.SymbolTable;
import com.sun.xml.stream.xerces.xni.QName;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamWriterImpl
extends WriterUtility
implements XMLStreamWriter {
    private OutputStream fOutputStream;
    private String fEncoding;
    private ElementStack fElementStack = new ElementStack();
    private boolean fStartTagOpened = false;
    private ElementState fCurrentElementState = null;
    private ElementState fillElementState = null;
    private NamespaceSupport fInternalNamespaceContext = null;
    private boolean fIsRepairingNamespace = false;
    private ArrayList fNamespaceDecls = null;
    private Random fPrefixGen = null;
    private PropertyManager fPropertyManager = null;
    private SymbolTable fSymbolTable = new SymbolTable();
    private ArrayList fAttributeCache = null;
    private String DEFAULT_PREFIX = null;
    private static final boolean DEBUG = false;
    private NamespaceContextImpl fNamespaceContext = null;
    private static ReadOnlyIterator fReadOnlyIterator = new ReadOnlyIterator();

    public XMLStreamWriterImpl(OutputStream outputStream, PropertyManager props) {
        this.fOutputStream = outputStream;
        this.fWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.fPropertyManager = props;
        this.init();
    }

    public XMLStreamWriterImpl(OutputStream outputStream, String encoding, PropertyManager props) throws UnsupportedEncodingException {
        this.fOutputStream = outputStream;
        this.fEncoding = encoding;
        this.fWriter = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
        this.fPropertyManager = props;
        this.init();
    }

    public XMLStreamWriterImpl(Writer writer, PropertyManager props) {
        this.fWriter = writer;
        this.fPropertyManager = props;
        this.init();
    }

    private void init() {
        this.fPropertyManager.setProperty("http://apache.org/xml/properties/internal/symbol-table", this.fSymbolTable);
        this.fNamespaceDecls = new ArrayList();
        this.fPrefixGen = new Random();
        if (this.fPropertyManager != null) {
            Boolean ob = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isRepairingNamespaces");
            this.fIsRepairingNamespace = ob;
            ob = (Boolean)this.fPropertyManager.getProperty("escapeCharacters");
            this.setEscapeCharacters(ob);
        }
        this.fAttributeCache = new ArrayList();
        this.fInternalNamespaceContext = new NamespaceSupport();
        this.fInternalNamespaceContext.reset();
        this.fNamespaceContext = new NamespaceContextImpl();
        this.fNamespaceContext.internalContext = this.fInternalNamespaceContext;
        this.DEFAULT_PREFIX = this.fSymbolTable.addSymbol("");
        this.fillElementState = new ElementState();
    }

    public void close() throws XMLStreamException {
        try {
            this.fWriter.close();
        }
        catch (IOException ioexception) {
            throw new XMLStreamException(ioexception);
        }
    }

    public void flush() throws XMLStreamException {
        try {
            this.fWriter.flush();
        }
        catch (IOException ioexception) {
            throw new XMLStreamException(ioexception);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.fNamespaceContext.getPrefix(uri);
    }

    public Object getProperty(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new NullPointerException();
        }
        if (!this.fPropertyManager.containsProperty(str)) {
            throw new IllegalArgumentException(str + " is not supported");
        }
        return this.fPropertyManager.getProperty(str);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (uri != null) {
            uri = this.fSymbolTable.addSymbol(uri);
        }
        if (this.fIsRepairingNamespace) {
            if (this.isDefaultNamespace(uri)) {
                return;
            }
            QName qname = new QName();
            qname.setValues(this.DEFAULT_PREFIX, "xmlns", null, uri);
            this.fNamespaceDecls.add(qname);
            return;
        }
        this.fInternalNamespaceContext.declarePrefix(this.DEFAULT_PREFIX, uri);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fNamespaceContext.userContext = namespaceContext;
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        if (uri == null) {
            throw new XMLStreamException("URI cannot be null");
        }
        prefix = this.fSymbolTable.addSymbol(prefix);
        uri = this.fSymbolTable.addSymbol(uri);
        if (this.fIsRepairingNamespace) {
            String tmpURI = this.fInternalNamespaceContext.getURI(prefix);
            if (tmpURI != null && tmpURI == uri) {
                return;
            }
            if (this.checkUserNamespaceContext(prefix, uri)) {
                return;
            }
            QName qname = new QName();
            qname.setValues(prefix, "xmlns", null, uri);
            this.fNamespaceDecls.add(qname);
            return;
        }
        this.fInternalNamespaceContext.declarePrefix(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                Attribute attr = new Attribute(value);
                attr.setValues(null, localName, null, null);
                this.fAttributeCache.add(attr);
                return;
            }
            this.fWriter.write(" ");
            this.fWriter.write(localName);
            this.fWriter.write("=");
            this.fWriter.write("\"");
            this.writeXMLAttributeValue(value);
            this.fWriter.write("\"");
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            String prefix = this.fInternalNamespaceContext.getPrefix(namespaceURI);
            if (!this.fIsRepairingNamespace) {
                if (prefix == null) {
                    throw new XMLStreamException("Prefix cannot be null");
                }
            } else {
                Attribute attr = new Attribute(value);
                attr.setValues(null, localName, null, namespaceURI);
                this.fAttributeCache.add(attr);
                return;
            }
            this.writeAttributeWithPrefix(prefix, localName, value);
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    private void writeAttributeWithPrefix(String prefix, String localName, String value) throws IOException {
        this.fWriter.write(" ");
        if (prefix != null && prefix != "") {
            this.fWriter.write(prefix);
            this.fWriter.write(":");
        }
        this.fWriter.write(localName);
        this.fWriter.write("=");
        this.fWriter.write("\"");
        this.writeXMLAttributeValue(value);
        this.fWriter.write("\"");
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (localName == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (!this.fIsRepairingNamespace) {
                if (prefix == null) {
                    throw new XMLStreamException("prefix cannot be null");
                }
            } else {
                if (prefix != null) {
                    prefix = this.fSymbolTable.addSymbol(prefix);
                }
                namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
                Attribute attr = new Attribute(value);
                attr.setValues(prefix, localName, null, namespaceURI);
                this.fAttributeCache.add(attr);
                return;
            }
            this.writeAttributeWithPrefix(prefix, localName, value);
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    public void writeCData(String cdata) throws XMLStreamException {
        try {
            if (cdata == null) {
                throw new XMLStreamException("cdata cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write("<![CDATA[");
            this.fWriter.write(cdata);
            this.fWriter.write("]]>");
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    public void writeCharacters(String data) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(data);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeCharacters(char[] data, int start, int len) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(data, start, len);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeComment(String comment) throws XMLStreamException {
        try {
            this.fWriter.write("<!--");
            if (comment != null) {
                this.fWriter.write(comment);
            }
            this.fWriter.write("-->");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(dtd);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Namespace Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                QName qname = new QName();
                qname.setValues("", "xmlns", null, uri);
                this.fNamespaceDecls.add(qname);
                return;
            }
            this.fWriter.write(" ");
            this.fWriter.write("xmlns");
            this.fWriter.write("=");
            this.fWriter.write("\"");
            this.fWriter.write(uri);
            this.fWriter.write("\"");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, localName, null, null, true);
            this.fInternalNamespaceContext.pushContext();
            if (this.fIsRepairingNamespace) {
                return;
            }
            this.fWriter.write(localName);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
        String prefix = this.fNamespaceContext.getPrefix(namespaceURI);
        this.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            if (localName == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (prefix != null) {
                prefix = this.fSymbolTable.addSymbol(prefix);
            }
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(prefix, localName, null, namespaceURI, true);
            this.fInternalNamespaceContext.pushContext();
            if (!this.fIsRepairingNamespace) {
                if (prefix == null) {
                    throw new XMLStreamException("NamespaceURI " + namespaceURI + " has not been bound to any prefix");
                }
            } else {
                return;
            }
            if (prefix != null && prefix != "") {
                this.fWriter.write(prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(localName);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            ElementState elem = null;
            while (!this.fElementStack.empty()) {
                elem = this.fElementStack.pop();
                this.fInternalNamespaceContext.popContext();
                if (elem.isEmpty) continue;
                this.fWriter.write("</");
                if (elem.prefix != null && !elem.prefix.equals("")) {
                    this.fWriter.write(elem.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(elem.localpart);
                this.fWriter.write(62);
            }
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new XMLStreamException("No more elements to write");
        }
    }

    public void writeEndElement() throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fCurrentElementState = this.fElementStack.pop();
            if (this.fCurrentElementState == null) {
                throw new XMLStreamException("No element was found to write");
            }
            if (this.fCurrentElementState.isEmpty) {
                return;
            }
            this.fWriter.write("</");
            if (this.fCurrentElementState.prefix != null && !this.fCurrentElementState.prefix.equals("")) {
                this.fWriter.write(this.fCurrentElementState.prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(this.fCurrentElementState.localpart);
            this.fWriter.write(62);
            this.fInternalNamespaceContext.popContext();
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new XMLStreamException("No element was found to write");
        }
    }

    public void writeEntityRef(String refName) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(38);
            this.fWriter.write(refName);
            this.fWriter.write(59);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        try {
            QName qname = null;
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Namespace Attribute not associated with any element");
            }
            if (prefix == null || prefix.equals("")) {
                this.writeDefaultNamespace(namespaceURI);
                return;
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("Namespace`uri cannot be null");
            }
            prefix = this.fSymbolTable.addSymbol(prefix);
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            if (this.fIsRepairingNamespace) {
                String tmpURI = this.fInternalNamespaceContext.getURI(prefix);
                if (tmpURI != null && tmpURI == namespaceURI) {
                    return;
                }
                qname = new QName();
                qname.setValues(prefix, "xmlns", null, namespaceURI);
                this.fNamespaceDecls.add(qname);
                return;
            }
            String tmp = this.fInternalNamespaceContext.getURI(prefix);
            if (tmp == null || tmp == namespaceURI) {
                this.fInternalNamespaceContext.declarePrefix(prefix, namespaceURI);
            }
            this.writenamespace(prefix, namespaceURI);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    private void writenamespace(String prefix, String namespaceURI) throws IOException {
        this.fWriter.write(" ");
        this.fWriter.write("xmlns");
        if (prefix != null && prefix != "") {
            this.fWriter.write(":");
            this.fWriter.write(prefix);
        }
        this.fWriter.write("=");
        this.fWriter.write("\"");
        this.fWriter.write(namespaceURI);
        this.fWriter.write("\"");
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (target != null) {
                this.fWriter.write("<?");
                this.fWriter.write(target);
                this.fWriter.write("?>");
                return;
            }
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        throw new XMLStreamException("PI target cannot be null");
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (target == null || data == null) {
                throw new XMLStreamException("PI target cannot be null");
            }
            this.fWriter.write("<?");
            this.fWriter.write(target);
            this.fWriter.write(" ");
            this.fWriter.write(data);
            this.fWriter.write("?>");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            this.fWriter.write("<?xml version=\"1.0\" ?>");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        try {
            if (version == null || version.equals("")) {
                this.writeStartDocument();
                return;
            }
            this.fWriter.write("<?xml version=\"");
            this.fWriter.write(version);
            this.fWriter.write("\"");
            this.fWriter.write("?>");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        try {
            if (encoding == null && version == null) {
                this.writeStartDocument();
                return;
            }
            if (encoding == null) {
                this.writeStartDocument(version);
                return;
            }
            this.fWriter.write("<?xml version=\"");
            if (version == null || version.equals("")) {
                this.fWriter.write("1.0");
            } else {
                this.fWriter.write(version);
            }
            if (!encoding.equals("")) {
                this.fWriter.write("\" encoding=\"");
                this.fWriter.write(encoding);
            }
            this.fWriter.write(34);
            this.fWriter.write("?>");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        try {
            if (localName == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, localName, null, null, false);
            this.fInternalNamespaceContext.pushContext();
            if (this.fIsRepairingNamespace) {
                return;
            }
            this.fWriter.write(localName);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (localName == null) {
            throw new XMLStreamException("Local Name cannot be null");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
        String prefix = null;
        if (!this.fIsRepairingNamespace && (prefix = this.fNamespaceContext.getPrefix(namespaceURI)) != null) {
            prefix = this.fSymbolTable.addSymbol(prefix);
        }
        this.writeStartElement(prefix, localName, namespaceURI);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            if (localName == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (!this.fIsRepairingNamespace && prefix == null) {
                throw new XMLStreamException("Prefix cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            if (prefix != null) {
                prefix = this.fSymbolTable.addSymbol(prefix);
            }
            this.fElementStack.push(prefix, localName, null, namespaceURI, false);
            this.fInternalNamespaceContext.pushContext();
            String tmpPrefix = this.fNamespaceContext.getPrefix(namespaceURI);
            if (!(prefix == null || tmpPrefix != null && prefix.equals(tmpPrefix))) {
                this.fInternalNamespaceContext.declarePrefix(prefix, namespaceURI);
            }
            if (this.fIsRepairingNamespace) {
                if (prefix == null || tmpPrefix != null && prefix.equals(tmpPrefix)) {
                    return;
                }
                QName qname = new QName();
                qname.setValues(prefix, "xmlns", null, namespaceURI);
                this.fNamespaceDecls.add(qname);
                return;
            }
            if (prefix != null && prefix != "") {
                this.fWriter.write(prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(localName);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    private void closeStartTag() throws XMLStreamException {
        try {
            this.fCurrentElementState = this.fElementStack.peek();
            if (this.fIsRepairingNamespace) {
                this.repair();
                this.correctPrefix(this.fCurrentElementState);
                if (this.fCurrentElementState.prefix != null && this.fCurrentElementState.prefix != "") {
                    this.fWriter.write(this.fCurrentElementState.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(this.fCurrentElementState.localpart);
                int len = this.fNamespaceDecls.size();
                QName qname = null;
                for (int i = 0; i < len; ++i) {
                    qname = (QName)this.fNamespaceDecls.get(i);
                    if (qname == null) continue;
                    this.fInternalNamespaceContext.declarePrefix(qname.prefix, qname.uri);
                    this.writenamespace(qname.prefix, qname.uri);
                }
                this.fNamespaceDecls.clear();
                Attribute attr = null;
                for (int j = 0; j < this.fAttributeCache.size(); ++j) {
                    String tmp;
                    attr = (Attribute)this.fAttributeCache.get(j);
                    if (attr.prefix != null && attr.uri != null && ((tmp = this.fInternalNamespaceContext.getPrefix(attr.uri)) == null || tmp != attr.prefix)) {
                        this.fInternalNamespaceContext.declarePrefix(attr.prefix, attr.uri);
                        this.writenamespace(attr.prefix, attr.uri);
                    }
                    this.writeAttributeWithPrefix(attr.prefix, attr.localpart, attr.value);
                }
                this.fAttributeCache.clear();
            }
            if (this.fCurrentElementState.isEmpty) {
                this.fElementStack.pop();
                this.fWriter.write("/>");
            } else {
                this.fWriter.write(62);
            }
            this.fStartTagOpened = false;
        }
        catch (IOException ex) {
            this.fStartTagOpened = false;
            throw new XMLStreamException(ex);
        }
    }

    private void openStartTag() throws IOException {
        this.fStartTagOpened = true;
        this.fWriter.write(60);
    }

    private void correctPrefix(QName attr) {
        String tmpPrefix = null;
        String prefix = attr.prefix;
        String uri = attr.uri;
        if (prefix == null) {
            if (uri == null) {
                return;
            }
            uri = this.fSymbolTable.addSymbol(uri);
            QName decl = null;
            for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
                decl = (QName)this.fNamespaceDecls.get(i);
                if (decl == null || decl.uri != attr.uri) continue;
                attr.prefix = decl.prefix;
                return;
            }
            tmpPrefix = this.fNamespaceContext.getPrefix(uri);
            if (tmpPrefix == "") {
                return;
            }
            if (tmpPrefix == null) {
                StringBuffer genPrefix = new StringBuffer("zdef");
                for (int i = 0; i < 1; ++i) {
                    genPrefix.append(this.fPrefixGen.nextInt());
                }
                prefix = genPrefix.toString();
                prefix = this.fSymbolTable.addSymbol(prefix);
            } else {
                prefix = this.fSymbolTable.addSymbol(tmpPrefix);
            }
            if (tmpPrefix == null) {
                QName qname = new QName();
                qname.setValues(prefix, "xmlns", null, uri);
                this.fNamespaceDecls.add(qname);
                this.fInternalNamespaceContext.declarePrefix(this.fSymbolTable.addSymbol(prefix), uri);
            }
        }
        attr.prefix = prefix;
    }

    private boolean isDefaultNamespace(String uri) {
        String defaultNamespace = this.fInternalNamespaceContext.getURI(this.DEFAULT_PREFIX);
        return uri == defaultNamespace;
    }

    private boolean checkUserNamespaceContext(String prefix, String uri) {
        String tmpURI;
        return this.fNamespaceContext.userContext != null && (tmpURI = this.fNamespaceContext.userContext.getNamespaceURI(prefix)) != null && tmpURI.equals(uri);
    }

    protected void repair() {
        int i;
        Attribute attr = null;
        Attribute attr2 = null;
        this.fCurrentElementState = this.fElementStack.peek();
        this.removeDuplicateDecls();
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            if (attr.prefix == null || this.fCurrentElementState.prefix == null) continue;
            this.correctPrefix(this.fCurrentElementState, attr);
        }
        if (!this.isDeclared(this.fCurrentElementState) && this.fCurrentElementState.prefix != null && this.fCurrentElementState.uri != null) {
            this.fNamespaceDecls.add(this.fCurrentElementState);
        }
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            for (int j = i + 1; j < this.fAttributeCache.size(); ++j) {
                attr2 = (Attribute)this.fAttributeCache.get(j);
                if (attr.prefix != null || attr2.prefix == null) continue;
                this.correctPrefix(attr, attr2);
            }
        }
        this.repairNamespaceDecl(this.fCurrentElementState);
        i = 0;
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            this.repairNamespaceDecl(attr);
        }
        QName qname = null;
        for (i = 0; i < this.fNamespaceDecls.size(); ++i) {
            qname = (QName)this.fNamespaceDecls.get(i);
            if (qname == null) continue;
            this.fInternalNamespaceContext.declarePrefix(qname.prefix, qname.uri);
        }
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            this.correctPrefix(attr);
        }
    }

    void correctPrefix(QName attr1, QName attr2) {
        String tmpPrefix = null;
        QName decl = null;
        boolean done = false;
        if (attr1.prefix.equals(attr2.prefix) && !attr1.uri.equals(attr2.uri)) {
            tmpPrefix = this.fNamespaceContext.getPrefix(attr2.uri);
            if (tmpPrefix != null) {
                attr2.prefix = this.fSymbolTable.addSymbol(tmpPrefix);
            } else {
                decl = null;
                for (int n = 0; n < this.fNamespaceDecls.size(); ++n) {
                    decl = (QName)this.fNamespaceDecls.get(n);
                    if (decl.uri != attr2.uri) continue;
                    attr2.prefix = decl.prefix;
                    return;
                }
                StringBuffer genPrefix = new StringBuffer("zdef");
                for (int k = 0; k < 1; ++k) {
                    genPrefix.append(this.fPrefixGen.nextInt());
                }
                tmpPrefix = genPrefix.toString();
                attr2.prefix = tmpPrefix = this.fSymbolTable.addSymbol(tmpPrefix);
                QName qname = new QName();
                qname.setValues(tmpPrefix, "xmlns", null, attr2.uri);
                this.fNamespaceDecls.add(qname);
            }
        }
    }

    void removeDuplicateDecls() {
        for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
            QName decl1 = (QName)this.fNamespaceDecls.get(i);
            for (int j = i + 1; j < this.fNamespaceDecls.size(); ++j) {
                QName decl2 = (QName)this.fNamespaceDecls.get(j);
                if (decl1 == null || !decl1.equals(decl2)) continue;
                this.fNamespaceDecls.set(j, null);
            }
        }
    }

    void repairNamespaceDecl(QName attr) {
        QName decl = null;
        for (int j = 0; j < this.fNamespaceDecls.size(); ++j) {
            String tmpURI;
            decl = (QName)this.fNamespaceDecls.get(j);
            if (decl == null || attr.prefix == null || !attr.prefix.equals(decl.prefix) || attr.uri.equals(decl.uri) || (tmpURI = this.fNamespaceContext.getNamespaceURI(attr.prefix)) == null) continue;
            if (tmpURI.equals(attr.uri)) {
                this.fNamespaceDecls.set(j, null);
                continue;
            }
            decl.uri = attr.uri;
        }
    }

    boolean isDeclared(QName attr) {
        QName decl = null;
        for (int n = 0; n < this.fNamespaceDecls.size(); ++n) {
            decl = (QName)this.fNamespaceDecls.get(n);
            if (attr.prefix == null || attr.prefix != decl.prefix || decl.uri != attr.uri) continue;
            return true;
        }
        return attr.uri != null && this.fNamespaceContext.getPrefix(attr.uri) != null;
    }

    class Attribute
    extends QName {
        String value;

        Attribute(String value) {
            this.value = value;
        }
    }

    protected class ElementStack {
        protected ElementState[] fElements = new ElementState[10];
        protected short fDepth;

        public ElementStack() {
            for (int i = 0; i < this.fElements.length; ++i) {
                this.fElements[i] = new ElementState();
            }
        }

        public ElementState push(ElementState element) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] array = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, array, 0, this.fDepth);
                this.fElements = array;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new ElementState();
                }
            }
            this.fElements[this.fDepth].setValues(element);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState push(String prefix, String localpart, String rawname, String uri, boolean isEmpty) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] array = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, array, 0, this.fDepth);
                this.fElements = array;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new ElementState();
                }
            }
            this.fElements[this.fDepth].setValues(prefix, localpart, rawname, uri, isEmpty);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState pop() {
            this.fDepth = (short)(this.fDepth - 1);
            return this.fElements[this.fDepth];
        }

        public void clear() {
            this.fDepth = 0;
        }

        public ElementState peek() {
            return this.fElements[this.fDepth - 1];
        }

        public boolean empty() {
            return this.fDepth <= 0;
        }
    }

    class ElementState
    extends QName {
        public boolean isEmpty;

        public ElementState() {
            this.isEmpty = false;
        }

        public ElementState(String prefix, String localpart, String rawname, String uri) {
            super(prefix, localpart, rawname, uri);
            this.isEmpty = false;
        }

        public void setValues(String prefix, String localpart, String rawname, String uri, boolean isEmpty) {
            super.setValues(prefix, localpart, rawname, uri);
            this.isEmpty = isEmpty;
        }
    }

    class NamespaceContextImpl
    implements NamespaceContext {
        NamespaceContext userContext = null;
        NamespaceSupport internalContext = null;

        NamespaceContextImpl() {
        }

        public String getNamespaceURI(String prefix) {
            String uri = null;
            if (prefix != null) {
                prefix = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(prefix);
            }
            if (this.internalContext != null && (uri = this.internalContext.getURI(prefix)) != null) {
                return uri;
            }
            if (this.userContext != null) {
                uri = this.userContext.getNamespaceURI(prefix);
                return uri;
            }
            return null;
        }

        public String getPrefix(String uri) {
            String prefix = null;
            if (uri != null) {
                uri = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(uri);
            }
            if (this.internalContext != null && (prefix = this.internalContext.getPrefix(uri)) != null) {
                return prefix;
            }
            if (this.userContext != null) {
                return this.userContext.getPrefix(uri);
            }
            return null;
        }

        public Iterator getPrefixes(String uri) {
            Vector prefixes = null;
            Iterator<String> itr = null;
            if (uri != null) {
                uri = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(uri);
            }
            if (this.userContext != null) {
                itr = this.userContext.getPrefixes(uri);
            }
            if (this.internalContext != null) {
                prefixes = this.internalContext.getPrefixes(uri);
            }
            if (prefixes == null && itr != null) {
                return itr;
            }
            if (prefixes != null && itr == null) {
                return new ReadOnlyIterator(prefixes.iterator());
            }
            if (prefixes != null && itr != null) {
                String ob = null;
                while (itr.hasNext()) {
                    ob = itr.next();
                    if (ob != null) {
                        ob = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(ob);
                    }
                    if (prefixes.contains(ob)) continue;
                    prefixes.add(ob);
                }
                return new ReadOnlyIterator(prefixes.iterator());
            }
            return fReadOnlyIterator;
        }
    }
}

