/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.api;

import org.netbeans.modules.bpel.model.api.events.VetoException;

import com.sun.org.apache.xalan.internal.lib.Extensions;
import java.util.List;


/**
 * <p>
 * Java class for tProcess complex type.
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 *
 * <pre>
 *   &lt;xsd:complexType name="tProcess">
 *       &lt;xsd:complexContent>
 *           &lt;xsd:extension base="tExtensibleElements">
 *               &lt;xsd:sequence>
 *                   &lt;xsd:element ref="extensions" minOccurs="0"/>
 *                   &lt;xsd:element ref="import" minOccurs="0" maxOccurs="unbounded"/>
 *                   &lt;xsd:element ref="partnerLinks" minOccurs="0"/>
 *                   &lt;xsd:element ref="messageExchanges" minOccurs="0"/>
 *                   &lt;xsd:element ref="variables" minOccurs="0"/>
 *                   &lt;xsd:element ref="correlationSets" minOccurs="0"/>
 *                   &lt;xsd:element ref="faultHandlers" minOccurs="0"/>
 *                  &lt;xsd:element ref="eventHandlers" minOccurs="0"/>
 *                   &lt;xsd:group ref="activity" minOccurs="1"/>
 *               &lt;/xsd:sequence>
 *               &lt;xsd:attribute name="name" type="xsd:NCName" use="required"/>
 *               &lt;xsd:attribute name="targetNamespace" type="xsd:anyURI" use="required"/>
 *               &lt;xsd:attribute name="queryLanguage" type="xsd:anyURI" default="urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0"/>
 *               &lt;xsd:attribute name="expressionLanguage" type="xsd:anyURI" default="urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0"/>
 *               &lt;xsd:attribute name="suppressJoinFailure" type="tBoolean" default="no"/>
 *               &lt;xsd:attribute name="exitOnStandardFault" type="tBoolean" default="no"/>
 *           &lt;/xsd:extension>
 *       &lt;/xsd:complexContent>
 *   &lt;/xsd:complexType>
 * </pre>
 */
public interface Process extends JoinFailureSuppressor, NamedElement,
        BaseScope, ExpressionLanguageSpec, QueryLanguageSpec
{

    /**
     * targetNamespace attribute name.
     */
    String TARGET_NAMESPACE = "targetNamespace"; // NOI18N


    /**
     * Gets the value of the targetNamespace property.
     * 
     * @return possible object is {@link String }
     */
    String getTargetNamespace();

    /**
     * Sets the value of the targetNamespace property.
     * 
     * @param value
     *            allowed object is {@link String }
     * @throws VetoException {@link VetoException}
     *             will be thrown if <code>value</code> if not acceptable as
     *             targetNamespace attribute here.
     */
    void setTargetNamespace( String value ) throws VetoException;

    /**
     * Removes expressionLanguage attribute.
     */
    void removeExpressionLanguage();

    /**
     * Gets the "extensions" entity child .
     * 
     * @return possible object is {@link Extensions }
     */
    ExtensionContainer getExtensionContainer();

    /**
     * Sets the "extensions" entity child .
     * 
     * @param value
     *            allowed object is {@link Extensions }
     */
    void setExtensionContainer( ExtensionContainer value );

    /**
     * Removes "extensions" entity as children if it exists.
     */
    void removeExtensionContainer();

    /**
     * @return Array of "import" children in this process.
     */
    Import[] getImports();

    /**
     * Adds new import <code>imp</code> to this parent.
     * 
     * @param imp
     *            New child for addition.
     */
    void addImport( Import imp );

    /**
     * Replace <code>i</code>-th place impport with new import
     * <code>imp</code>.
     * 
     * @param imp
     *            New child for setting.
     * @param i
     *            Index in children list.
     */
    void setImport( Import imp, int i );

    /**
     * Inserts new import <code>imp</code> at the <code>i</code>-th place.
     * 
     * @param imp
     *            New child for addition.
     * @param i
     *            Index in children list.
     */
    void insertImport( Import imp, int i );

    /**
     * Removes <code>i</code>-th import from children list.
     * 
     * @param i Index in children list.
     */
    void removeImport( int i );

    /**
     * Set new list of children of imports.
     * 
     * @param imports
     *            New array of children.
     */
    void setImports( Import[] imports );

    /**
     * @param i Index in children list.
     * @return <code>i</code>-th child in imports array.
     */
    Import getImport( int i );

    /**
     * @return size of "imports" children.
     */
    int sizeOfImports();
    
    /**
     * Get List of XmlComment available under this element.
     * like <!-- comment here -->
     * this could be moved to AbstractDocumentComponent
     * so that any xml element can get a list of comments
     * under that element and add remove comments and set individual
     * comment text.
     * @return list of XmlComment
     */
    List<XmlComment>  getXmlComments();
    
    /**
     * add an XmlComment under this element.
     * like <!-- comment here -->
     * this could  be moved to AbstractDocumentComponent
     * so that any xml element can get a list of comments
     * under that element and add remove comments and set individual
     * comment text.
     * @param comment
     * 
     */
    XmlComment addXmlComment(String comment)throws VetoException;
    
    /**
     * Remove a XmlComment from this element.
     * like <!-- comment here -->
     * this could be moved to AbstractDocumentComponent
     * so that any xml element can get a list of comments
     * under that element and add remove comments and set individual
     * comment text.
     * @param comment
     */
    void removeXmlComment(XmlComment comment) throws VetoException;
}
