/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.compapp.casaeditor.graph.layout;

import java.util.Comparator;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;

/**
 *
 * @author Josh Sandusky
 */
public class YOrderComparator implements Comparator<CasaNodeWidget> {
    
    private CasaModelGraphScene mScene;
    
    
    public YOrderComparator(CasaModelGraphScene scene) {
        mScene = scene;
    }
    
    
    public int compare(CasaNodeWidget w1, CasaNodeWidget w2) {
        if (mScene.findObject(w1) instanceof CasaPort) {    // TMP
            CasaPort port1 = (CasaPort) mScene.findObject(w1);
            CasaPort port2 = (CasaPort) mScene.findObject(w2);
            int y1 = w1.getLocation().y;
            int y2 = w2.getLocation().y;
            if (y1 == y2) {
                int order1 = getOrderNumber(port1);
                int order2 = getOrderNumber(port2);
                if (order1 == order2) {
                    // Just return the top-most widget (z-order).
                    return 
                            w2.getParentWidget().getChildren().indexOf(w2) - 
                            w1.getParentWidget().getChildren().indexOf(w1);
                }
                return order1 - order2;
            } else if (y1 < y2) {
                return -1;
            } else {
                return 1;
            }
            
        } else if (mScene.findObject(w1) instanceof CasaServiceEngineServiceUnit) {
            return w1.getLocation().y - w2.getLocation().y;
            
        } else {
            return -1;
        }
    }
    
    public boolean equals(Object object) {
        return this == object;
    }
    
    private int getOrderNumber(CasaPort port) {
        if (port.getConsumes() != null && port.getProvides() == null) {
            return 1;
        } else if (port.getConsumes() != null && port.getProvides() != null) {
            return 2;
        } else if (port.getConsumes() == null && port.getProvides() != null) {
            return 3;
        } else {
            return -1;
        }
    }
}
