/*
 * DefinitionsNode.java
 * 
 * Created on Jun 11, 2007, 5:51:09 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.node;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

/**
 *
 * @author radval
 */
public class WSDLDefinitionsNode extends AbstractNode {

    public static final String IMPORTS_FOLDER = "IMPORTS_FOLDER"; //NOI18N
    public static final String MESSAGES_FOLDER = "MESSAGES_FOLDER";//NOI18N
    public static final String PORTTYPES_FOLDER = "PORTTYPES_FOLDER";//NOI18N
    public static final String BINDING_FOLDER  = "BINDING_FOLDER";//NOI18N
    public static final String SERVICES_FOLDER = "SERVICES_FOLDER";//NOI18N
    public static final String EXTENSIBILITY_ELEMENTS_FOLDER = "EXTENSIBILITY_ELEMENTS_FOLDER";//NOI18N
    
      private Image ICON = Utilities.loadImage
    ("org/netbeans/modules/worklist/editor/view/resources/wsdl16.png");
  
    private Definitions definitions;
    
    public WSDLDefinitionsNode(Definitions definitions, Children children) {
        super(children);
        this.definitions = definitions;
        
    }
    
    public WSDLDefinitionsNode(Definitions mWSDLDef, List<Class<? extends WSDLComponent>> filters) {
        this(mWSDLDef, new DefinitionsChildren(mWSDLDef, filters));
    }
   
    @Override
    public Image getIcon(int type) {
        return ICON;
    }
    
    @Override
    public Image getOpenedIcon(int type) {
        return ICON;
    }
    
    protected void updateDisplayName() {
        Definitions defs = (Definitions) getWSDLComponent();
        String name = defs.getTargetNamespace();
        if (name == null) {
//            name = NbBundle.getMessage(DefinitionsNode.class,
//                    "LBL_DefinitionsNode_NoTargetNamespace");
            name = "No TargetNamespace";
        }
        setDisplayName(name);
    }
     
    WSDLComponent getWSDLComponent() {
        return this.definitions;
    }
    
     public static final class DefinitionsChildren extends GenericWSDLComponentChildren {
        
        List<Class<? extends WSDLComponent>> filters;
        public DefinitionsChildren(Definitions definitions) {
            super(definitions);
        }
        
        //Hack for creating children with only specific categories
        /**
         * Only top level filters are supported.
         * Message, Import, Types, Documentation, PortType, Binding , Service and ExtensibilityElement are supported.
         * If filters are specified, then only those folders which support that top level component are created.
         * 
         */
        public DefinitionsChildren(Definitions definitions, List<Class<? extends WSDLComponent>> filters) {
            this(definitions);
            this.filters = filters;
        }
        
        @Override
        protected Node[] createNodes(Object key) {
            Node node = null;
           
            if (IMPORTS_FOLDER.equals(key)) {
                
            }
            if (MESSAGES_FOLDER.equals(key)) {
                
            }
            if (PORTTYPES_FOLDER.equals(key)) {
                node = new PortTypeFolderNode((Definitions) getWSDLComponent());
            }
            if (BINDING_FOLDER.equals(key)) {
                
            }
            if (SERVICES_FOLDER.equals(key)) {
                
            }
            
            if (EXTENSIBILITY_ELEMENTS_FOLDER.equals(key)) {
                
            }
            
            
            if(node != null) {
                return new Node[] {node};
            }
            
            return new Node[] {node};
        }
        
   
        protected Collection getKeys() {
            Collection<Object> keys = new ArrayList<Object>();
            
            
            Definitions def = (Definitions) getWSDLComponent();
            
            
            if (filters == null || filters.contains(PortType.class)) {
                keys.add(PORTTYPES_FOLDER);
            }
            

            return keys;
        }

      
        
        
    }

}
