/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;

import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileUtil;

/**
 * @author sgenipudi
 */
public class SchemaManager {

    private static SchemaManager mInstance = null;

    private SchemaManager() {

    }

    public static SchemaManager getInstance() {
        if (mInstance == null )  {
            mInstance = new SchemaManager();
        }
        return mInstance;
    }

    public SchemaModel getSchemaModel(File file) {
        ModelSource ms = getModuleSource(file);
        SchemaModelFactory factory = SchemaModelFactory.getDefault();
        SchemaModel model = factory.getModel(ms);
        try {
            model.sync();
        }catch (Exception ex) {
            throw new RuntimeException("Error during sync operation of Client WSDL file");
        }
        return model;
    }

    public ModelSource getModuleSource(File file) {
        ModelSource source = null;
        try {
            if (WSDLGenerator.isCommandlineMode()) {
                    source = WorkflowCatalogModel.getDefault().createModelSource(file, true);
            } else {
                    source = org.netbeans.modules.xml.retriever.catalog.Utilities.createModelSource(FileUtil.toFileObject(file),true);
            }
        }catch (Exception ex){
            throw new RuntimeException("Error while creating model source for "+file);
        }

        return source;
    }


//    public WSDLOperation getOperation()

}
