/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring;

import java.io.IOException;
import java.util.Enumeration;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.refactoring.safedelete.EntitySafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.JaxWsXmlSafeDeleteRafactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.PersistenceXmlSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.SunJaxWsXmlSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.TldClassSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.WebXmlSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.WebservicesXmlSafeDeleteRefactoring;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbMethodSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbClassSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbCmpFieldSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.BaseRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbQueryMethodSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;
import java.util.Collection;
import org.netbeans.modules.web.taglib.TLDLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;


/**
 * @author pfiala
 */
public class J2EESafeDeleteRefactoringPlugin implements RefactoringPlugin {
    
    /**
     * This one is important creature - makes sure that cycles between plugins won't appear
     */
    private static ThreadLocal semafor = new ThreadLocal();
    
    
    private static ErrorManager err = ErrorManager.getDefault()
    .getInstance("org.netbeans.modules.j2ee.refactoring.safedelete");   // NOI18N;
    private List refactorings = new LinkedList();
    
    private SafeDeleteRefactoring safeDeleteRefactoring;
    
    private Taglib taglib = null;
    
    /**
     * Creates a new instance of J2EERenameRefactoringPlugin
     */
    public J2EESafeDeleteRefactoringPlugin(AbstractRefactoring refactoring) {
        safeDeleteRefactoring = (SafeDeleteRefactoring) refactoring;
    }
    
    /**
     * Checks pre-conditions of the refactoring and returns problems.
     *
     * @return Problems found or null (if no problems were identified)
     */
    public Problem preCheck() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                prepareRefactorings();
                for (Iterator it = refactorings.iterator(); it.hasNext();) {
                    J2EERefactoring refactoring = ((J2EERefactoring) it.next());
                    problem = Utility.addProblemsToEnd(problem, refactoring.preCheck());
                }
                if (safeDeleteRefactoring.getElementsToDelete().length > 0){
                    Element elem = safeDeleteRefactoring.getElementsToDelete()[0];
                    if (Utility.isEjb30(elem) && Utility.hasEjbJar(elem)){
                        Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EESafeDeleteRefactoringPlugin.class, "TXT_EjbJarSafeDeleteWarning"));  //NOI18N
                        problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
                    }
                }
            }finally {
                semafor.set(null);
            }
        }
        return problem;
    }
    
    public Problem fastCheckParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                for (Iterator it = refactorings.iterator(); it.hasNext();) {
                    J2EERefactoring refactoring = ((J2EERefactoring) it.next());
                    problem = Utility.addProblemsToEnd(problem, refactoring.fastCheckParameters());
                }
            } finally {
                semafor.set(null);
            }
        }
        return problem;
    }
    
    /**
     * Checks parameters of the refactoring.
     *
     * @return Problems found or null (if no problems were identified)
     */
    public Problem checkParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                for (Iterator it = refactorings.iterator(); it.hasNext();) {
                    J2EERefactoring refactoring = ((J2EERefactoring) it.next());
                    problem = Utility.addProblemsToEnd(problem, refactoring.checkParameters());
                }
            } finally {
                semafor.set(null);
            }
        }
        return problem;
    }
    
    /**
     * Collects refactoring elements for a given refactoring.
     *
     * @param refactoringElements Collection of refactoring elements - the implementation of this method
     *                            should add refactoring elements to this collections. It should make no assumptions about the collection
     *                            content.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                for (Iterator it = refactorings.iterator(); it.hasNext();) {
                    J2EERefactoring refactoring = ((J2EERefactoring) it.next());
                    problem = Utility.addProblemsToEnd(problem, refactoring.prepare(refactoringElements));
                }
            } finally {
                semafor.set(null);
            }
        }
        return problem;
    }
    
    public void cancelRequest() {
    }
    
    private void prepareRefactorings() {
        refactorings.clear();
        Element[] elementsToDelete = safeDeleteRefactoring.getElementsToDelete();
        for (int i = 0; i < elementsToDelete.length; i++) {
            Element element = elementsToDelete[i];
            preparePersistenceRefactoring(element);
            prepareJaxWsRefactoring(element);
            prepareSunJaxWsRefactoring(element);
            prepareEntityRefactoring(element);
            prepareWebXmlRefactoring(element);
            prepareWebservicesRefactoring(element);
            
            if (!Utility.isEjb30(element)){
                FileObject ejbJarFileObject = Utility.getEjbJarFileObject(element);
                EjbJar ejbJar = Utility.getEjbJar(Utility.getApiEjbJar(element));
                if (ejbJar != null) {
                    // TODO: is this guy expecting really XML FileObject?
                    final BaseRefactoring.EjbHelper helper =
                            new BaseRefactoring.EjbHelper(safeDeleteRefactoring, ejbJarFileObject, ejbJar);
                    prepareRefactoring(helper, element);
                }
            }
            
            // this takes care of tld refactoring
            Collection webModules = Utility.getRelevantWebModules(element);
            Iterator wmIter = webModules.iterator();
            if (wmIter != null) {
                while (wmIter.hasNext()) {
                    WebModule wm = (WebModule)wmIter.next();
                    if (wm != null) {              // the class is in an web module
                        FileObject webInf = wm.getWebInf();
                        Enumeration e = null;
                        if (webInf != null) {
                            e = webInf.getChildren(true);
                        }
                        if (e != null) {
                            while (e.hasMoreElements()) {
                                FileObject tld = (FileObject)e.nextElement();
                                if (isTld(tld)) {
                                    DataObject tldData = null;
                                    try {
                                        tldData = DataObject.find(tld);
                                    } catch (DataObjectNotFoundException dne) {
                                        // ignore
                                    }
                                    if ((tldData != null) && (tldData instanceof TLDDataObject)) {
                                        try {
                                            taglib = ((TLDDataObject)tldData).getTaglib();
                                        } catch (IOException ioe) {}
                                        if (taglib != null) {
                                            final BaseRefactoring.TldHelper helper =
                                                    new BaseRefactoring.TldHelper(safeDeleteRefactoring, tld, taglib);
                                            prepareRefactoring(helper, element);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    private boolean isTld(FileObject fo) {
        boolean isTld = false;
        if (fo != null) {
            String ext = fo.getExt();
            if (TLDLoader.tldExt.equalsIgnoreCase(ext)) {
                isTld = true;
            }
        }
        return isTld;
    }
    
    private void prepareRefactoring(BaseRefactoring.EjbHelper helper, Element element) {
        if (element instanceof Method) {
            prepareMethodRefactoring(helper, (Method) element);
        } else if (element instanceof JavaClass) {
            JavaClass javaClass = ((JavaClass) element);
            Ejb ejb = Utility.getEjb(helper.getEjbJar(), javaClass);
            if (ejb != null) {
                refactorings.add(new EjbClassSafeDeleteRefactoring(helper, ejb, javaClass));
            }
        } else {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "Safe Delete - Unknown Element: " + element);
        }
    }
    
    private void prepareRefactoring(BaseRefactoring.TldHelper helper, Element element) {
        if (element instanceof JavaClass) {
            JavaClass javaClass = ((JavaClass) element);
            if (taglib != null) {
                refactorings.add(new TldClassSafeDeleteRefactoring(helper, taglib, javaClass));
            }
        } else if (element instanceof Resource) {
            List classes = ((Resource)element).getClassifiers();
            if (classes != null) {
                
            }
        } else {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, "Safe Delete - Unknown Element: " + element);
        }
    }
    
    private void prepareMethodRefactoring(BaseRefactoring.EjbHelper helper, Method method) {
        Ejb ejb = Utility.getEjb(helper.getEjbJar(), method.getDeclaringClass());
        if (ejb != null) {
            if (ejb instanceof Entity) {
                final Entity entity = (Entity) ejb;
                if (checkCmpFields(helper, entity, method)) {
                    return;
                }
                if (checkQueries(helper, entity, method)) {
                    return;
                }
            }
            refactorings.add(new EjbMethodSafeDeleteRefactoring(helper, method));
        }
    }
    
    private void preparePersistenceRefactoring(Element element){
        if (!(element instanceof JavaClass)){
            return;
        }
        PersistenceXmlSafeDeleteRefactoring refactoring =
                new PersistenceXmlSafeDeleteRefactoring(element, safeDeleteRefactoring);
        refactorings.add(refactoring);
    }
    
    private void prepareWebservicesRefactoring(Element element){
        if (!(element instanceof JavaClass)){
            return;
        }
        WebservicesXmlSafeDeleteRefactoring refactoring =
                new WebservicesXmlSafeDeleteRefactoring(element, safeDeleteRefactoring);
        refactorings.add(refactoring);
    }
    
    private void prepareJaxWsRefactoring(Element element){
        if (!(element instanceof JavaClass)){
            return;
        }
        JaxWsXmlSafeDeleteRafactoring refactoring = new JaxWsXmlSafeDeleteRafactoring((JavaClass) element);
        refactorings.add(refactoring);
    }
    
    private void prepareSunJaxWsRefactoring(Element element){
        if (!(element instanceof JavaClass)){
            return;
        }
        SunJaxWsXmlSafeDeleteRefactoring refactoring = new SunJaxWsXmlSafeDeleteRefactoring((JavaClass) element);
        refactorings.add(refactoring);
    }
    
    private void prepareEntityRefactoring(Element element){
        if (!(element instanceof Feature)){
            return;
        }
        Feature feature = (Feature) element;
        JavaClass javaClass = (JavaClass) feature.getDeclaringClass();
        if (!PersistenceRefactoringUtil.isEntity(javaClass)){
            return;
        }
        EntitySafeDeleteRefactoring refactoring =
                new EntitySafeDeleteRefactoring(javaClass, feature, safeDeleteRefactoring);
        refactorings.add(refactoring);
    }
    
    private void prepareWebXmlRefactoring(Element element){
        if (!(element instanceof JavaClass)){
            return;
        }
        WebXmlSafeDeleteRefactoring refactoring = new WebXmlSafeDeleteRefactoring(safeDeleteRefactoring, (JavaClass) element);
        refactorings.add(refactoring);
    }
    
    private boolean checkCmpFields(BaseRefactoring.EjbHelper helper, Entity entity, Method method) {
        final String fieldName = Utility.getFieldName(method);
        if (fieldName != null) {
            final CmpField[] cmpField = entity.getCmpField();
            for (int i = 0; i < cmpField.length; i++) {
                CmpField field = cmpField[i];
                if (fieldName.equals(field.getFieldName())) {
                    final Collection accessMethods = Utility.getAccessMethods(entity, fieldName);
                    if (accessMethods.remove(method)) {
                        final Method[] additionalMethods = new Method[accessMethods.size()];
                        accessMethods.toArray(additionalMethods);
                        final BaseRefactoring refactoring = new EjbCmpFieldSafeDeleteRefactoring(helper, entity, field);
                        refactoring.addChildRefactoring(new SafeDeleteRefactoring(additionalMethods));
                        refactorings.add(refactoring);
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }
    
    private boolean checkQueries(BaseRefactoring.EjbHelper helper, Entity entity, Method method) {
        final String methodName = method.getName();
        final Query[] queries = entity.getQuery();
        for (int i = 0; i < queries.length; i++) {
            Query query = queries[i];
            if (methodName.equals(query.getQueryMethod().getMethodName())) {
                final Collection queryMethods = Utility.getQueryMethods(entity, query);
                if (queryMethods.remove(method)) {
                    final Method[] additionalMethods = new Method[queryMethods.size()];
                    queryMethods.toArray(additionalMethods);
                    final BaseRefactoring refactoring =
                            new EjbQueryMethodSafeDeleteRefactoring(helper, entity, query);
                    refactoring.addChildRefactoring(new SafeDeleteRefactoring(additionalMethods));
                    refactorings.add(refactoring);
                    return true;
                }
                break;
            }
        }
        return false;
    }
    
}