/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.utils;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/**
 *
 * @author Jan Horvath
 */
public class PersistenceUtilsFactory implements ObjectFactory{
    private Logger LOG = Logger.getLogger(PersistenceUtilsFactory.class.getName());
    
    /*
     * Default PU can be changed by adding pu attribute to the reesource definition:
     * 
     * <Resource name="bean/Utils" auth="Container"
     *       type="org.netbeans.modules.exceptions.utils.PersistenceUtils"
     *       factory="org.netbeans.modules.exceptions.utils.PersistenceUtilsFactory" pu="DerbyPU"/>
     * 
     */
    
    private static PersistenceUtils persUtils = null;
    
    public PersistenceUtilsFactory() {
    }

    public Object getObjectInstance(Object obj, Name name1, Context nameCtx,
                                    Hashtable environment) throws Exception {
        synchronized (PersistenceUtilsFactory.class) {
            if (persUtils == null) {
                try {
                    Class<?> test = org.netbeans.modules.exceptions.entity.Issue.class;
                    Class.forName(test.getName(), true, test.getClassLoader());
                } catch (Throwable t) {
                    LOG.log(Level.WARNING, t.getMessage(), t);
                }

                Reference ref = (Reference) obj;
                RefAddr pu = ref.get("pu");
                if (pu != null) {
                    PersistenceUtils.setDefault((String) pu.getContent());
                    PersistenceUtils.LOG.log(Level.WARNING, "Changing default pursistence unit to {0}", (String) pu.getContent());
                }
                persUtils = PersistenceUtils.getInstance();
                RefAddr settingsDir = ref.get("settingsDir");
                if (settingsDir != null) {
                    Object dir = settingsDir.getContent();
                    if (dir != null) {
                        PersistenceUtils.setSettingsDirectory((String) dir);
                    }
                    PersistenceUtils.LOG.log(Level.WARNING, "Changing settings directory to {0}", (String) settingsDir.getContent());
                } 
                persUtils = PersistenceUtils.getInstance();
            }
        }
        return persUtils;
    }

}
