/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.mobility.deployment.ricoh;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author  Lukas Waldmann
 */
public class DeploymentPanels extends javax.swing.JPanel
{
    /** Creates new form DeploymentPanels */
    DeploymentPanels()
    {
        initComponents();
        add(sdCardConfigPanel,DeploymentComboBoxModel.SD_CARD_DEPLOY);
        add(httpPostConfigPanel,DeploymentComboBoxModel.HTTP_DEPLOY);
        
        //input verification
        PortVerifier verifier = new PortVerifier();
        httpServerPort.setInputVerifier(verifier);
    }
    
    
    void setEditable(boolean b)
    {
        for (Component c1 : getComponents())
        {
            if (c1 instanceof Container)
            {
                for (Component comp : ((Container)c1).getComponents())
                {
                    if (comp instanceof JTextComponent)
                    {
                        ((JTextComponent)comp).setEditable(b);
                    }
                    else if (comp instanceof JButton)
                    {
                        comp.setVisible(b);
                    }
                    else if (comp instanceof JRadioButton)
                    {
                        ((JRadioButton)comp).setEnabled(b);
                    }
                }
            }
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        sdCardConfigPanel = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        sdPathField = new javax.swing.JTextField();
        sdPathBrowse = new javax.swing.JButton();
        httpPostConfigPanel = new javax.swing.JPanel();
        jLabel30 = new javax.swing.JLabel();
        httpServerPort = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        sdkjV1_4RadioButton = new javax.swing.JRadioButton();
        sdkjV2_0RadioButton = new javax.swing.JRadioButton();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        usernameTextField = new javax.swing.JTextField();
        passwordField = new javax.swing.JPasswordField();
        serverTextField = new javax.swing.JTextField();
        sdkGroup = new javax.swing.ButtonGroup();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/mobility/deployment/ricoh/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel15, bundle.getString("LBL_SDCardPath")); // NOI18N

        sdPathField.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_SDCARD_PATH);

        org.openide.awt.Mnemonics.setLocalizedText(sdPathBrowse, bundle.getString("LBL_SDCardBrowse")); // NOI18N
        sdPathBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sdPathBrowseActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout sdCardConfigPanelLayout = new org.jdesktop.layout.GroupLayout(sdCardConfigPanel);
        sdCardConfigPanel.setLayout(sdCardConfigPanelLayout);
        sdCardConfigPanelLayout.setHorizontalGroup(
            sdCardConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(sdCardConfigPanelLayout.createSequentialGroup()
                .add(jLabel15)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sdPathField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 270, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sdPathBrowse))
        );
        sdCardConfigPanelLayout.setVerticalGroup(
            sdCardConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, sdCardConfigPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(sdCardConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel15)
                    .add(sdPathBrowse)
                    .add(sdPathField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(0, 0, Short.MAX_VALUE))
        );

        org.openide.awt.Mnemonics.setLocalizedText(jLabel30, bundle.getString("LBL_HttpServerPort")); // NOI18N

        httpServerPort.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_HTTP_PORT);

        jLabel16.setText(bundle.getString("LBL_HttpPlatformType")); // NOI18N

        sdkGroup.add(sdkjV1_4RadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(sdkjV1_4RadioButton, bundle.getString("RADIO_SDKJ_1.X")); // NOI18N
        sdkjV1_4RadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sdkjV1_4RadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        sdkjV1_4RadioButton.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_HTTP_PLATFORM);

        sdkGroup.add(sdkjV2_0RadioButton);
        sdkjV2_0RadioButton.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(sdkjV2_0RadioButton, bundle.getString("RADIO_SDKJ_2.X")); // NOI18N
        sdkjV2_0RadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sdkjV2_0RadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        sdkjV2_0RadioButton.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_HTTP_PLATFORM);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, bundle.getString("LBL_Username")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, bundle.getString("LBL_Password")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, bundle.getString("LBL_TargetServer")); // NOI18N

        usernameTextField.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_HTTP_USERNAME);

        passwordField.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_HTTP_PASSWORD);

        serverTextField.setName(RicohDeploymentProperties.PROP_RICOH_DEPLOY_HTTP_SERVER);

        org.jdesktop.layout.GroupLayout httpPostConfigPanelLayout = new org.jdesktop.layout.GroupLayout(httpPostConfigPanel);
        httpPostConfigPanel.setLayout(httpPostConfigPanelLayout);
        httpPostConfigPanelLayout.setHorizontalGroup(
            httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(httpPostConfigPanelLayout.createSequentialGroup()
                .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel16)
                    .add(httpPostConfigPanelLayout.createSequentialGroup()
                        .add(sdkjV1_4RadioButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(sdkjV2_0RadioButton))
                    .add(httpPostConfigPanelLayout.createSequentialGroup()
                        .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel3)
                            .add(jLabel5)
                            .add(jLabel4)
                            .add(jLabel30))
                        .add(14, 14, 14)
                        .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(httpServerPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 61, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(org.jdesktop.layout.GroupLayout.TRAILING, usernameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)
                                .add(org.jdesktop.layout.GroupLayout.TRAILING, passwordField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)
                                .add(serverTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)))))
                .addContainerGap(20, Short.MAX_VALUE))
        );
        httpPostConfigPanelLayout.setVerticalGroup(
            httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(httpPostConfigPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(usernameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(7, 7, 7)
                .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(passwordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(serverTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel30)
                    .add(httpServerPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel16)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(httpPostConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sdkjV1_4RadioButton)
                    .add(sdkjV2_0RadioButton))
                .addContainerGap(19, Short.MAX_VALUE))
        );

        setLayout(new java.awt.CardLayout());
    }// </editor-fold>//GEN-END:initComponents

    private void sdPathBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_sdPathBrowseActionPerformed
    {//GEN-HEADEREND:event_sdPathBrowseActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        String workDir = sdPathField.getText();
        if (workDir.equals(""))
        {
            //workDir = FileUtil.toFile(getProject().getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(DeploymentPanels.class, "TITLE_BrowseForSDCardFolder")); //NOI18N
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this))
        { //NOI18N
            File file = FileUtil.normalizeFile(chooser.getSelectedFile());
            sdPathField.setText(file.getAbsolutePath());
        }
    }//GEN-LAST:event_sdPathBrowseActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel httpPostConfigPanel;
    private javax.swing.JTextField httpServerPort;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    javax.swing.JPasswordField passwordField;
    private javax.swing.JPanel sdCardConfigPanel;
    private javax.swing.JButton sdPathBrowse;
    private javax.swing.JTextField sdPathField;
    private javax.swing.ButtonGroup sdkGroup;
    private javax.swing.JRadioButton sdkjV1_4RadioButton;
    private javax.swing.JRadioButton sdkjV2_0RadioButton;
    javax.swing.JTextField serverTextField;
    javax.swing.JTextField usernameTextField;
    // End of variables declaration//GEN-END:variables
}
