// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base/stack_manipulation_ia32.cpp,v 1.5 2001/12/07 00:16:00 xli18 Exp $
//



#include "platform.h"
#include <assert.h>
#include <iostream.h>
#include "environment.h"
#include "object_layout.h"
#include "Class.h"
#include "jit_intf.h"
#include "jit_intf_cpp.h"
#include "orp_threads.h"
#include "orp_synch.h"
#include "jit_runtime_support.h"
#include "method_lookup.h"
#include "root_set_enum.h"
#include "orp_utils.h"
#include "orp_stats.h"

#include "stack_manipulation.h"

#include "nogc.h"
#include "../x86/x86.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

#ifdef ORP_VTUNE_SUPPORT
//M: 
#include "orp_vtune.h"
#endif


//////////////////////////////////////////////////////////////////////////
// begin ljf stuff

J2N_Saved_State ** get_addr_of_orp_last_java_frame()
{
#ifdef ORP_STATS
    orp_stats_total.num_get_addr_of_orp_last_java_frame++;
#endif
    return &(p_TLS_orpthread->last_java_frame);
} //get_addr_of_orp_last_java_frame



J2N_Saved_State *get_orp_last_java_frame()
{
    return p_TLS_orpthread->last_java_frame;
} //get_orp_last_java_frame



void set_orp_last_java_frame(J2N_Saved_State *ljf)
{
    assert(p_TLS_orpthread);
    p_TLS_orpthread->last_java_frame = ljf;
} //set_orp_last_java_frame


void * getaddress__setup_java_to_native_frame()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = call(ss, (char *)get_addr_of_orp_last_java_frame);
    
    ss = pop(ss, &ecx_opnd);

    ss = push(ss, &ebp_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);
    
    ss = push(ss, &Imm_Opnd(0));
    
    ss = push(ss, &eax_opnd);
    ss = push(ss, &M_Base_Opnd(eax_reg, +0));
    ss = mov(ss, &M_Base_Opnd(eax_reg, +0), &esp_opnd );

    ss = jump(ss, &ecx_opnd);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__setup_java_to_native_frame",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__setup_java_to_native_frame


void * getaddress__pop_java_to_native_frame()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;
    
    ss = pop(ss, &ecx_opnd);

    ss = pop(ss, &esi_opnd);
    ss = pop(ss, &ebx_opnd);

    ss = mov(ss, &M_Base_Opnd(ebx_reg, +0), &esi_opnd );
    
    ss = alu(ss, add_opc, &esp_opnd, &Imm_Opnd(+4));

    ss = pop(ss, &edi_opnd);
    ss = pop(ss, &esi_opnd);
    ss = pop(ss, &ebx_opnd);
    ss = pop(ss, &ebp_opnd);
   
    ss = jump(ss, &ecx_opnd);

    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__pop_java_to_native_frame",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__pop_java_to_native_frame
// end ljf stuff
//////////////////////////////////////////////////////////////////////////




//
// Unwind a sequence of native stack frames all the way to the next Java
// frame on the stack.
// Returns FALSE if there are no Java frames left on the stack (the return
// value is used by stack walking/unwinding loops as a termination condition).
//
Boolean ro_unwind_native_stack_frame(Frame_Context *context     // in out
                                     )
{
#ifdef ORP_STATS
    orp_stats_total.num_unwind_native_frames_all++;
#endif
    // Assume that our stub has saved callee-saved registers in the
    // following format:
    // 
    // |       return eip         |
    // |          ebp             |
    // |          ebx             |
    // |          esi             |
    // |          edi             |
    // |   local_object_handle    | (optional)
    // |     address of ljf       |
    // | prev orp_last_java_frame |  <--- current orp_last_java_frame
    // 


    J2N_Saved_State *ljf = (J2N_Saved_State *)context->ljf;
    if(!ljf)
        return FALSE;

    context->ljf   = ljf->prev_ljf;
    context->p_edi = &(ljf->edi);
    context->p_esi = &(ljf->esi);
    context->p_ebx = &(ljf->ebx);
    context->p_ebp = &(ljf->ebp);
    context->p_eip = &(ljf->eip);

    context->esp   = ((uint32)context->p_eip) + 4;

    return TRUE;
} //ro_unwind_native_stack_frame



ORPExport unsigned
orp_get_stack_depth_from_native_new(Class **class_info,
                                    void  **ret_eip_array,
                                    int     array_length
                                    )
{
    Frame_Context context;

    // Force an unwind from a native in the first iteration
    context.ljf   = (uint32)get_orp_last_java_frame();
    context.eip   = 0;
    context.p_eip = &(context.eip);

    // orp_get_stack_depth assumes that ip addresses can be stored in an uint32.
    assert(sizeof(void *) == sizeof(uint32));

    bool prev_state = orp_disable_gc();      //----------------v

    unsigned depth = orp_get_stack_depth(&context, class_info, ret_eip_array, array_length, FALSE);

    if(prev_state) {
        orp_enable_gc();        //-----------------------------^
    }

    return depth;
} //orp_get_stack_depth_from_native_new


unsigned
orp_get_stack_depth(Frame_Context *ro_context,
                    Class        **class_info,
                    void         **ret_eip_array,
                    int            array_length,
                    Boolean        is_first
                    )
{

#ifdef INTERPRETER
    interp_frame *p_cursor = 0;
    if (p_TLS_orpthread->p_current_frame) {
        assert(p_TLS_orpthread->p_lif == 0);
        p_cursor = p_TLS_orpthread->p_current_frame;
    }
    else {
        if (p_TLS_orpthread->p_lif) {
            assert(p_TLS_orpthread->p_current_frame == 0);
            p_cursor = p_TLS_orpthread->p_lif;
        }
    }
    unsigned depth = 0;

    while (p_cursor) {
        if(depth < (unsigned)array_length) {
            if(class_info) {
                class_info[depth] = p_cursor->p_current_method->get_class();
            }
        }
        if (p_cursor->p_lif) {
            assert(p_cursor->p_prev == 0);
            p_cursor = p_cursor->p_lif;
        }
        else p_cursor = p_cursor->p_prev;
        depth++;
    }
    return depth;

#else // INTERPRETER

    Frame_Context local_context;
    orp_copy_frame_context(&local_context, ro_context);
    Frame_Context *context = &local_context;

    unsigned depth = 0;

    JIT_Specific_Info *jit_info = 0;
#ifdef _DEBUG
    Method *prev_meth;
#endif
    while(1) {
#ifdef _DEBUG
        prev_meth = jit_info ? jit_info->get_method() : 0;
#endif
        jit_info = methods.find((void *)*(context->p_eip));
        ORP_Code_Type orpct = orp_identify_eip((void *)*(context->p_eip));
        if(orpct == ORP_TYPE_JAVA) {
#if 0
            printf("debug info ---->> eip %p, %s.%s\n", *(context->p_eip), 
                jit_info->get_method()->get_class()->name->bytes,
                jit_info->get_method()->get_name()->bytes);
            orp_cout << endl;
#endif
            if(depth < (unsigned)array_length) {
                if(class_info) {
                    class_info[depth] = jit_info->get_method()->get_class();
                }
                if(ret_eip_array) {
                    ret_eip_array[depth] = (void *)*(context->p_eip);
                }
            }
            assert(jit_info->get_jit());
#ifdef ORP_STATS
            orp_stats_total.num_unwind_java_frames_non_gc++;
            jit_info->num_unwind_java_frames_non_gc++;
#endif

            jit_info->get_jit()->unwind_stack_frame(jit_info->get_method(),
                                                    context,
                                                    is_first);
            depth++;
        } else {
            Boolean ok = ro_unwind_native_stack_frame(context);
            if(!ok) {
#ifdef _DEBUG
                if(prev_meth){
                const char *name = prev_meth->get_name()->bytes;
#ifdef CLI_TESTING
                assert(!(   strcmp("exit", name)
                         && strcmp("main", name)
                         && strcmp("Main", name) 
                         && strcmp("initializeSystemClass", name)
                         && strcmp("run", name) && name[0] != '<'));
#else
                assert(!(   strcmp("exit", name)
                         && strcmp("main", name)
                         && strcmp("initializeSystemClass", name)
                         && strcmp("run", name) && name[0] != '<'));
#endif
                }
#endif
                return depth;
            }
        }
        is_first = FALSE;
    }
#endif  // INTERPRETER
} //orp_get_stack_depth


#define OPTIMISTIC_DEPTH  128


//
// We should return "JavaArrayOfInt *", but that would include too many header files.
//
void *
orp_create_stack_trace(Frame_Context *context,
                       Boolean        is_first
                       )
{
    void *optimistic_trace[OPTIMISTIC_DEPTH];
    unsigned depth =
        orp_get_stack_depth(context, 0, optimistic_trace, OPTIMISTIC_DEPTH, is_first);

    JavaArrayOfInt *eip_array = (JavaArrayOfInt *)orp_newarray(10, depth);
    if(depth <= OPTIMISTIC_DEPTH) {
#ifdef ORP_STATS
        orp_stats_total.num_optimistic_depth_success++;
#endif
        memcpy(&(eip_array->body[0]),
               optimistic_trace,
               depth * sizeof(optimistic_trace[0]));
    } else {
#ifdef ORP_STATS
        orp_stats_total.num_optimistic_depth_failure++;
#endif
        Frame_Context local_context;
        orp_copy_frame_context(&local_context, context);
        orp_get_stack_depth(&local_context,
                            0,
                            (void **)&(eip_array->body[0]), 
                            -1,
                            is_first);
    }

    return eip_array;
} //orp_create_stack_trace



bool orp_caller_name_is(const char *name) {
    void *short_trace;
    unsigned depth =
        orp_get_stack_depth_from_native_new(0, &short_trace, 1);
    assert(depth);
    assert(orp_identify_eip(short_trace) == ORP_TYPE_JAVA);
    JIT_Specific_Info *jit_info = methods.find(short_trace);
    return strcmp(jit_info->get_method()->get_name()->bytes, name) == 0;
} //orp_caller_name_is



void orp_print_stack_trace_debug(unsigned max_depth)
{
    void *optimistic_trace[OPTIMISTIC_DEPTH];
    unsigned depth =
        orp_get_stack_depth_from_native_new(0, optimistic_trace, OPTIMISTIC_DEPTH);
    unsigned depth1;
    if(depth <= OPTIMISTIC_DEPTH) {
        depth1 = depth;
    } else {
        depth1 = OPTIMISTIC_DEPTH;
    }
    depth1 = depth1 > max_depth ? max_depth : depth1;

    printf("------- begin stack trace\n");
    for(unsigned i = 0; i < depth1; i++) {
        void *eip = optimistic_trace[i];
        assert(orp_identify_eip(eip) == ORP_TYPE_JAVA);
        JIT_Specific_Info *jit_info = methods.find(eip);
        Method *method = jit_info->get_method();
        Class *clss    = method->get_class();
        printf("at eip 0x%08x  in  %s.%s%s\n",
               eip,
               method->get_class()->name->bytes,
               method->get_name()->bytes,
               method->get_descriptor());
    }
    printf("------- end stack trace\n");
} //orp_print_stack_trace_debug



Boolean unwind_to_next_java_frame(Frame_Context      *context,  
                                  Boolean             is_first, 
                                  Boolean             destructive
                                  )
{
    uint32 eip_var = *(context->p_eip);
    JIT_Specific_Info *jit_info = methods.find((void *)eip_var);
    ORP_Code_Type orpct = orp_identify_eip((void *)eip_var);

    while(1) {
        if(orpct == ORP_TYPE_JAVA) {
            assert(jit_info->get_jit());

            if(destructive && jit_info->get_method()->is_synchronized()) {
                if(jit_info->get_method()->is_static()) {
                    orp_monitor_exit((Java_java_lang_Object *)jit_info->get_method()->get_class());
                } else {
                    void **p_this =
                        (void **)jit_info->get_jit()->get_address_of_this(jit_info->get_method(),
                                                                           context,
                                                                           is_first);
                    orp_monitor_exit((Java_java_lang_Object *)*p_this);
                }
            }

            jit_info->get_jit()->unwind_stack_frame(jit_info->get_method(),
                                                    context,
                                                    is_first);
        } else {
            Boolean ok = ro_unwind_native_stack_frame(context);
            if(destructive) {
                set_orp_last_java_frame((J2N_Saved_State *)context->ljf);
            }
            if(!ok) {
                return FALSE;
            }
        }
        eip_var = *(context->p_eip);
        jit_info = methods.find((void *)eip_var);
        orpct = orp_identify_eip((void *)eip_var);
        if(orpct == ORP_TYPE_JAVA)
            return TRUE;
    }

    return FALSE;
} //unwind_to_next_java_frame




Boolean unwind_to_next_java_frame(Frame_Context      *context, 
                                  ORP_thread         *p_thr,       
                                  Boolean             is_first 
                                  )
{
    context->ljf = (uint32)p_thr->last_java_frame;
    uint32 eip_var = *(context->p_eip);
    JIT_Specific_Info *jit_info = methods.find_deadlock_free((void *)eip_var);
    ORP_Code_Type orpct = orp_identify_eip((void *)eip_var);

    while(1) {
        if(orpct == ORP_TYPE_JAVA) {
            assert(jit_info->get_method()->get_jit());

            jit_info->get_jit()->unwind_stack_frame(jit_info->get_method(),
                                                    context,
                                                    is_first);
        } else {
            Boolean ok = ro_unwind_native_stack_frame(context);

            if(!ok) {
                return FALSE;
            }
        }
        eip_var = *(context->p_eip);
        jit_info = methods.find((void *)eip_var);
        orpct = orp_identify_eip((void *)eip_var);
        if(orpct == ORP_TYPE_JAVA)
            return TRUE;
    }

    return FALSE;
} //unwind_to_next_java_frame





void *get_last_j2n_saved_ip()
{
    void *short_trace;
    unsigned depth =
        orp_get_stack_depth_from_native_new(0, &short_trace, 1);
    assert(depth);
    assert(sizeof(short_trace) == sizeof(void *));
    return short_trace;
} //get_last_j2n_saved_ip



void print_context(FILE *f, Frame_Context *fc)
{
} //print_context


