// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/recompilation_intf.cpp,v 1.6 2001/12/07 00:16:00 xli18 Exp $
//

#include "defines.h"
#include <iostream.h>
#include "jit_intf.h"
#include "internal_jit_intf.h"
#include "stack_manipulation.h"
#include "jit.h"
#include "Mem_Manager.h"
#include "profiling.h"
#include "nogc.h"

#ifdef ORP_VTUNE_SUPPORT
//M:
#include "orp_vtune.h"
#endif


#define SMALL_METHOD_SIZE 20 
//
// the following declaration is important for gcc to compile
// trigger_recompilation() using callee-pop calling convention
//
static void __stdcall trigger_recompilation(Method_Handle m_handle,
                                            JIT_Handle    jit_handle) stdcall__;

//
// determine if we want to recompile 
//
static void __stdcall trigger_recompilation(Method_Handle m_handle,
                                            JIT_Handle    jit_handle) {
    Class_Handle c_handle = method_get_class(m_handle);
    Small_Method_Info *smi = (Small_Method_Info *)method_get_info_block(m_handle,jit_handle);
    Profile_Rec *prof_rec = smi->prof_rec;

#ifdef TRACE_LEVEL1A
    cout << "determine recompilation " 
             << class_get_name(c_handle) << "." << method_get_name(m_handle) << endl;
#endif
    //
    // If the method has no loops and is a small method, then recompilation the 
    // method may not gain us anything.
    //
#if 0
    if (prof_rec->been_recompiled || 
        (prof_rec->n_back_edge == 0 && 
        smi->code_len <= SMALL_METHOD_SIZE))
        return;
#endif
    if (prof_rec->been_recompiled)
        return;
    prof_rec->been_recompiled = true;
#ifdef TRACE_LEVEL1A
    cout << "trigger recompilation "
             << class_get_name(c_handle) << "." << method_get_name(m_handle) << endl;
#endif
    assert(o3_jit != NULL);
    method_recompile(m_handle, o3_jit);
}


void *getaddress__orp_trigger_recompilation_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 128;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif

    char *ss = stub;
    ss = gen_setup_j2n_frame(ss);
    ss = push(ss, &M_Base_Opnd(esp_reg, (sizeof(J2N_Saved_State)+4)) );
    ss = push(ss, &M_Base_Opnd(esp_reg, (sizeof(J2N_Saved_State)+4)) );
    ss = call(ss, (char *)trigger_recompilation);
    ss = gen_pop_j2n_frame(ss);
    ss = ret(ss,&Imm_Opnd(8));
    assert(ss - stub < stub_size);

    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_trigger_recompilation_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_trigger_recompilation_naked

char *addr_of_trigger_recompilation() {

    return (char*)getaddress__orp_trigger_recompilation_naked();
}

//
// The routine analyzes all method info and find out hot methods that are
// not yet recompiled, then it triggers recompilation.
//
void analyze_method_infos_for_recompilation(unsigned multiplier) {
    if (o1_jit == NULL) return;
    //
    // go over all method info
    //
    for (Method_Iterator mi = method_get_first_method_jit(o1_jit); 
         mi != JAVA_METHOD_END;
         mi = method_get_next_method_jit(mi)) {
        Method_Handle m = method_get_method_jit(mi);
        // retrieve method info
        Small_Method_Info *smi = (Small_Method_Info*)method_get_info_block(m,o1_jit);
        Profile_Rec *prof_rec = smi->prof_rec;
        if (prof_rec == NULL || prof_rec->been_recompiled) continue;
        //
        // check if the method has been executed above the threshold
        //
        bool is_hot = false;
        PROF_COUNTER cnt = 0;
        if (prof_rec->m_entry > recompilation_policy_method)
            cnt = ((unsigned)-1) - prof_rec->m_entry + recompilation_policy_method;
        if (cnt > multiplier*recompilation_policy_method)
            is_hot = true;
        else {
            for (unsigned i = 0; i < prof_rec->n_back_edge; i++) {
                cnt = 0;
                if (prof_rec->back_edge[i] > recompilation_policy_loop)
                    cnt = ((unsigned)-1) - prof_rec->back_edge[i] + recompilation_policy_loop;
                if (cnt > multiplier*recompilation_policy_loop) {
                    is_hot = true;
                    break;
                }
            }
        }
        if (is_hot) {
#ifdef TRACE_LEVEL1A
            cout << class_get_name(method_get_class(m)) << "."
                     << method_get_name(m)
                     << method_get_descriptor(m) 
                     << " is hot" << endl;
#endif
            prof_rec->been_recompiled = true;

#ifdef ORP_POSIX
            assert(0);
#endif
            method_recompile(m, o3_jit);

        } else {
#if 1
            //
            // reset counters so that the counters don't accumulate among
            // different recompilation intervals
            //
            prof_rec->m_entry = recompilation_policy_method;
            for (unsigned i = 0; i < prof_rec->n_back_edge; i++)
                prof_rec->back_edge[i] = recompilation_policy_loop;
#endif
        }
    }
}

void l1a_thread_recompile_methods(void *dummy) {
#ifdef ORP_POSIX
#else
    HANDLE event = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            E_H_RECOMP
        ); 
    DWORD stat;
    int iteration = 0;
    while (true) {
#ifdef TRACE_LEVEL1A
        cout << "Recompilation starts " << endl;
#endif
        iteration++;
        unsigned multiplier = (iteration > 8)? 8 : iteration;
        stat = WaitForSingleObject(event, multiplier*1000);
        assert(stat == WAIT_TIMEOUT);
        analyze_method_infos_for_recompilation(multiplier);
    }
#endif
}
