// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common/object_manager.cpp,v 1.4 2001/11/20 20:09:22 rlhudson Exp $
//

#ifndef  OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "orp_types.h"
#include "Class.h"
#include "stack_manipulation.h"
#include "exceptions.h"
#include "environment.h"
#include "object_layout.h"
#include "orp_threads.h"
#include "nogc.h"
#include "root_set_enum.h"
#include "orp_utils.h"
#include "orp_synch.h"
#include "sync_bits.h"
#include "object_manager.h"

#include "orp_stats.h"

#ifdef OBJECT_SPLITTING
#include "gc_interface.h"
#endif // OBJECT_SPLITTING


#ifdef ORP_POSIX
#include "platform2.h"
#ifdef __linux__
#include <asm/bitops.h>
#endif
#endif

///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_object_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void start_of_object_manager_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}




#ifdef _DEBUG

void queue_verifier(volatile Java_java_lang_Object *p_obj)
{
    volatile POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_obj);

    if ( (*p_header & SLOW_LOCKING) != SLOW_LOCKING)
        return;

    Lock_Block *p_lock_chain = 
        (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK );

    bool lock_held = false;
    if( (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) > 0
     && (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) <=
                QUICK_RECURSION_ABOUT_TO_OVERFLOW                       )
    {
        assert(p_lock_chain->lock_or_wait_state != holding_the_lock);
        lock_held = true;
    }
    else if ( (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) == 
                                            QUICK_RECURSION_ABOUT_TO_OVERFLOW)
    {
        assert(p_lock_chain->lock_or_wait_state == holding_the_lock);
        assert(p_lock_chain->lock_recursion_count_shifted_left >=
                                            QUICK_RECURSION_ABOUT_TO_OVERFLOW);
        lock_held = true;
    }
    else
        assert(p_lock_chain->lock_or_wait_state == waiting_for_the_notify);

    lock_or_wait scan_state = zilch;
    while(true) {
        assert(p_lock_chain->lock_recursion_count_shifted_left != 0);
        assert(p_lock_chain->p_orp_thread->event_handle_monitor);
        assert(p_lock_chain->p_orp_thread->event_handle_sleep);
        assert(p_lock_chain->lock_or_wait_state != 
            owning_thread_needs_to_call_free_routine);

        if (p_lock_chain->lock_or_wait_state < scan_state)
            assert(0);
        if (  (p_lock_chain->lock_or_wait_state == waiting_for_the_lock) &&
            (!lock_held)  )
                assert(0);

        if (p_lock_chain->p_forward_link)
            assert(p_lock_chain->p_forward_link->p_back_link == p_lock_chain);

        scan_state = p_lock_chain->lock_or_wait_state;
        p_lock_chain = p_lock_chain->p_forward_link;
        if (!p_lock_chain) 
            break;
    }
}
#endif  // _DEBUG




Lock_Block *get_a_block(ORP_thread *p_orpthread)
{
    Lock_Block *p_block;
    if (p_orpthread->p_free_lock_blocks)  {
        p_block = p_orpthread->p_free_lock_blocks;
        p_orpthread->p_free_lock_blocks =
            p_orpthread->p_free_lock_blocks->p_active_or_free;
    }
    else {
#ifdef _DEBUG
        p_orpthread->number_of_lock_blocks_allocated++;
#endif
        POINTER_SIZE_INT xx;
        xx = (POINTER_SIZE_INT)gc_malloc_fixed_data_C( sizeof(Lock_Block) + 32); 
        memset( (void *)xx, 0, ( sizeof(Lock_Block) + 32) );
        // next, align so that the 5 address LSB's are zero
        // ASSUMPTION: we never call free() on this malloc'ed memory
        xx = xx + 31;
        xx = xx & ~31;
        assert((xx & 31) == 0);
        p_block = (Lock_Block *)xx;

        //printf("get_a_block:: p_orpthread = 0x%x  p_block = 0x%x\n", p_orpthread, p_block);
    }
    p_block->p_object_header = 0;
    p_block->old_object_header = 0;
    p_block->p_forward_link = 0;
    p_block->p_back_link = 0;
    p_block->lock_or_wait_state = zilch;
    p_block->lock_recursion_count_shifted_left = 0;
    p_block->p_orp_thread = p_orpthread; 
    p_block->discriminator = normal_lock_block;
    p_block->p_active_or_free = p_orpthread->p_active_lock_blocks;
    p_orpthread->p_active_lock_blocks = p_block;

    return p_block;
}


void free_this_block(ORP_thread *p_orpthread, Lock_Block *p_block)
{
    assert(p_block == p_orpthread->p_active_lock_blocks);
    p_orpthread->p_active_lock_blocks = p_block->p_active_or_free;

    p_block->p_active_or_free = p_orpthread->p_free_lock_blocks;
    p_orpthread->p_free_lock_blocks = p_block;

    p_block->p_object_header = 0;
    p_block->old_object_header = 0;
    p_block->p_forward_link = 0;
    p_block->p_back_link = 0;
    p_block->lock_or_wait_state = zilch;
    p_block->lock_recursion_count_shifted_left = 0;
    p_block->p_orp_thread = p_orpthread; 
}


void orp_fixup_monitor_lock(void *p_old_hdr, void *p_new_hdr)
{
    // Input is a pointer to the obj_info field (header) field in the object.
    // It might not be the start of the object.
    POINTER_SIZE_INT *p_old_header = (POINTER_SIZE_INT *)p_old_hdr;

    POINTER_SIZE_INT *p_new_header = (POINTER_SIZE_INT *)p_new_hdr;

	if ((*p_old_header & SLOW_LOCKING) == SLOW_LOCKING ) {

		Lock_Block *p_lock_chain = 
			(Lock_Block *)(*p_old_header & LOCK_BLOCK_POINTER_MASK);

		p_lock_chain->p_object_header = p_new_header;		
	}
}



///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_object_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_object_manager_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}

#endif //#ifndef  OBJECT_LOCK_V2

 
