// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/find_natives_array.cpp,v 1.20 2002/01/16 11:15:02 xli18 Exp $
//



#include "platform.h"
#include <assert.h>
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"
#include "jni.h"

#include "java_io_File.h"
#include "java_io_FileInputStream.h"
#include "java_io_FileOutputStream.h"
#include "java_io_ObjectInputStream.h" 
#include "java_io_ObjectOutputStream.h" 
#include "java_io_RandomAccessFile.h"

#include "java_io_FileDescriptor.h"
#include "java_lang_Class.h"
#include "java_lang_Double.h"
#include "java_lang_Float.h"

#include "java_lang_Math.h"

#include "java_lang_Object.h"

#include "java_lang_reflect_Array.h" 
#include "java_lang_reflect_Field.h"
#include "java_lang_reflect_Constructor.h"
#include "java_lang_reflect_Method.h" 
#include "java_lang_Runtime.h"
#include "java_lang_StringBuffer.h"
#include "java_lang_System.h"
#include "java_lang_VMObject.h"
#include "java_lang_VMSystem.h"
#include "java_lang_VMClassLoader.h"
#include "java_lang_VMSecurityManager.h"
#include "java_lang_Thread.h"
#include "java_lang_Throwable.h"
#include "java_lang_PlatformProcess.h"
#include "java_net_InetAddress.h"
#include "java_net_PlainSocketImpl.h"
#include "java_net_PlainDatagramSocketImpl.h"
#include "java_util_Date.h"
#include "java_util_GregorianCalendar.h"
#include "java_util_ResourceBundle.h"
#include "java_util_TimeZone.h"
#include "java_lang_VMObject.h"

#ifdef USE_IA64_JIT
#define IA64_HACK_NO_JAVA_NET
#endif

#ifndef OBJECT_LOCK_V2
#include "object_generic.h"
#include "find_natives.h"
#else
#include "object_generic_olv2.h"
#include "find_natives_olv2.h"
#endif



///////////////////////////////////////////////////////////////////////////
// NOTE: This array must be sorted by method name!
///////////////////////////////////////////////////////////////////////////


Built_In_Method_Entry _built_ins_base [] = {
#ifdef OLD_VERSION_CLASSPATH
    { "gnu_vm_stack_StackTrace_copyCurrentStackTrace", (void *) Java_gnu_vm_stack_StackTrace_copyCurrentStackTrace, NI_IS_JNI },
#endif

// java.lang.Class native methods
	{ "java_lang_Class_forName", (void *) java_lang_Class_forName, NI_IS_RNI },
	{ "java_lang_Class_getClassLoader", (void *) Java_java_lang_Class_getClassLoader, NI_IS_JNI }, 
	//?? for running jBoss
	{ "java_lang_Class_getClassLoader0", (void *) Java_java_lang_Class_getClassLoader, NI_IS_JNI }, 
	{ "java_lang_Class_getClasses", (void *) Java_java_lang_Class_getClasses, NI_IS_JNI },
	// Class.getComponentType is replaced by Classpath using java implementation
	//{ "java_lang_Class_getComponentType", (void *) Java_java_lang_Class_getComponentType, NI_IS_JNI },
	{ "java_lang_Class_getConstructor", (void *) Java_java_lang_Class_getConstructor, NI_IS_JNI },
	{ "java_lang_Class_getConstructors", (void *) Java_java_lang_Class_getConstructors, NI_IS_JNI },
	{ "java_lang_Class_getDeclaredClasses", (void *) Java_java_lang_Class_getDeclaredClasses, NI_IS_JNI },
	{ "java_lang_Class_getDeclaredConstructor", (void *) Java_java_lang_Class_getDeclaredConstructor, NI_IS_JNI }, 
	{ "java_lang_Class_getDeclaredConstructors", (void *) Java_java_lang_Class_getDeclaredConstructors, NI_IS_JNI }, 
	{ "java_lang_Class_getDeclaredField", (void *) Java_java_lang_Class_getDeclaredField, NI_IS_JNI }, 
	{ "java_lang_Class_getDeclaredFields", (void *) Java_java_lang_Class_getDeclaredFields, NI_IS_JNI },
	{ "java_lang_Class_getDeclaredMethod", (void *) Java_java_lang_Class_getDeclaredMethod, NI_IS_JNI },
	{ "java_lang_Class_getDeclaredMethods", (void *) Java_java_lang_Class_getDeclaredMethods, NI_IS_JNI },
	{ "java_lang_Class_getDeclaringClass", (void *) Java_java_lang_Class_getDeclaringClass, NI_IS_JNI },
	{ "java_lang_Class_getField", (void *) Java_java_lang_Class_getField, NI_IS_JNI },
	{ "java_lang_Class_getFields", (void *) Java_java_lang_Class_getFields, NI_IS_JNI },
	{ "java_lang_Class_getInterfaces", (void *) Java_java_lang_Class_getInterfaces, NI_IS_JNI },
	{ "java_lang_Class_getMethod", (void *) Java_java_lang_Class_getMethod, NI_IS_JNI },
	{ "java_lang_Class_getMethods", (void *) Java_java_lang_Class_getMethods, NI_IS_JNI },
	{ "java_lang_Class_getModifiers", (void *) Java_java_lang_Class_getModifiers, NI_IS_JNI },
	{ "java_lang_Class_getName", (void *) Java_java_lang_Class_getName, NI_IS_JNI }, 
	{ "java_lang_Class_getSuperclass", (void *) Java_java_lang_Class_getSuperclass, NI_IS_JNI },
	{ "java_lang_Class_isAssignableFrom", (void *) Java_java_lang_Class_isAssignableFrom, NI_IS_JNI },
	{ "java_lang_Class_isInstance", (void *) Java_java_lang_Class_isInstance, NI_IS_JNI },
	{ "java_lang_Class_isInterface", (void *) Java_java_lang_Class_isInterface, NI_IS_JNI },
	{ "java_lang_Class_isPrimitive", (void *) Java_java_lang_Class_isPrimitive, NI_IS_JNI },

//java.lang.Object native methods
    { "java_lang_Object_getClass", (void *) Java_java_lang_Object_getClass, NI_IS_JNI },
    { "java_lang_Object_hashCode", (void *) Java_java_lang_Object_hashCode, NI_IS_JNI },

//java.lang.PlatformProcess: classpath doesn't support this so far
   	{"java_lang_PlatformProcess_destroy", (void *)Java_java_lang_PlatformProcess_destroy, NI_IS_JNI },
	{"java_lang_PlatformProcess_exitValue", (void *)Java_java_lang_PlatformProcess_exitValue, NI_IS_JNI },
	{"java_lang_PlatformProcess_spawn", (void *)Java_java_lang_PlatformProcess_spawn, NI_IS_JNI },
	{"java_lang_PlatformProcess_waitFor", (void *)Java_java_lang_PlatformProcess_waitFor, NI_IS_JNI },

//java.lang.Runtime native methods
	{ "java_lang_Runtime_execInternal", (void *) Java_java_lang_Runtime_execInternal, NI_IS_JNI },
	{ "java_lang_Runtime_exitInternal", (void *) Java_java_lang_Runtime_exitInternal, NI_IS_JNI },
	{ "java_lang_Runtime_freeMemory", (void *) Java_java_lang_Runtime_freeMemory, NI_IS_JNI },
	{ "java_lang_Runtime_gc", (void *) Java_java_lang_Runtime_gc, NI_IS_JNI },
	{ "java_lang_Runtime_getLibraryPath", (void *) Java_java_lang_Runtime_getLibraryPath, NI_IS_JNI },
 //loadLibrary is just for new classpath
#ifndef OLD_VERSION_CLASSPATH
    { "java_lang_Runtime_loadLibrary", (void *)Java_java_lang_Runtime_loadLibrary, NI_IS_JNI },
#endif
	{ "java_lang_Runtime_nativeGetLibname", (void *) Java_java_lang_Runtime_nativeGetLibname, NI_IS_JNI },
	{ "java_lang_Runtime_nativeLoad", (void *) Java_java_lang_Runtime_nativeLoad, NI_IS_JNI },
	{ "java_lang_Runtime_runFinalization", (void *) Java_java_lang_Runtime_runFinalization, NI_IS_JNI },
	{ "java_lang_Runtime_runFinalizersOnExitInternal", (void *) Java_java_lang_Runtime_runFinalizersOnExitInternal, NI_IS_JNI },
	{ "java_lang_Runtime_totalMemory", (void *) Java_java_lang_Runtime_totalMemory, NI_IS_JNI },
	{ "java_lang_Runtime_traceInstructions", (void *) Java_java_lang_Runtime_traceInstructions, NI_IS_JNI },
	{ "java_lang_Runtime_traceMethodCalls", (void *) Java_java_lang_Runtime_traceMethodCalls, NI_IS_JNI },

//java.lang.String native methods
	{ "java_lang_String_intern", (void *)java_lang_String_intern, NI_IS_RNI },

//java.lang.System native methods
    { "java_lang_System_arraycopy", (void  *)java_lang_System_arraycopy,  NI_IS_RNI },

//java.lang.Thread native methods
    { "java_lang_Thread_countStackFrames", (void  *)java_lang_Thread_countStackFrames,  NI_IS_RNI },
    { "java_lang_Thread_currentThread", (void  *)java_lang_Thread_currentThread,  NI_IS_RNI },
    { "java_lang_Thread_isAlive", (void  *)java_lang_Thread_isAlive,  NI_IS_RNI },
	{ "java_lang_Thread_isInterrupted", (void  *)java_lang_Thread_isInterrupted,  NI_IS_RNI },
    { "java_lang_Thread_join", (void  *)java_lang_Thread_join,  NI_IS_RNI },
    { "java_lang_Thread_nativeDestroy", (void  *)java_lang_Thread_nativeDestroy,  NI_IS_RNI },
    { "java_lang_Thread_nativeInit", (void  *)java_lang_Thread_nativeInit,  NI_IS_RNI },
    { "java_lang_Thread_nativeInterrupt", (void  *)java_lang_Thread_nativeInterrupt,  NI_IS_RNI },
    { "java_lang_Thread_nativeResume", (void  *)java_lang_Thread_nativeResume,  NI_IS_RNI },
    { "java_lang_Thread_nativeSetPriority", (void  *)java_lang_Thread_nativeSetPriority,  NI_IS_RNI },
    { "java_lang_Thread_nativeStop", (void  *)java_lang_Thread_nativeStop,  NI_IS_RNI },
    { "java_lang_Thread_nativeSuspend", (void  *)java_lang_Thread_nativeSuspend,  NI_IS_RNI },

    { "java_lang_Thread_sleep", (void *)java_lang_Thread_sleep, NI_IS_RNI },
    { "java_lang_Thread_start", (void  *)java_lang_Thread_start,  NI_IS_RNI },
    { "java_lang_Thread_yield", (void  *)java_lang_Thread_yield,  NI_IS_RNI },

//java.lang.Throwable native methods
	//{ "java_lang_Throwable_fillInStackTrace", (void *) java_lang_Throwable_fillInStackTrace, NI_IS_RNI },
	//{ "java_lang_Throwable_printStackTrace0", (void *) java_lang_Throwable_printStackTrace0, NI_IS_RNI },
    { "java_lang_Throwable_fillInStackTrace", (void *) Java_java_lang_Throwable_fillInStackTrace, NI_IS_JNI },
    { "java_lang_Throwable_printStackTrace0", (void *) Java_java_lang_Throwable_printStackTrace0, NI_IS_JNI },

//java.lang.VMClassLoader native methods
	{ "java_lang_VMClassLoader_defineClass", (void *)Java_java_lang_VMClassLoader_defineClass , NI_IS_JNI }, 
#ifndef NON_ORP_NATIVE_LIBS
    //?? for running jBoss
	{ "java_lang_VMClassLoader_defineClass1", (void *)Java_java_lang_VMClassLoader_defineClass1 , NI_IS_JNI }, 
	{ "java_lang_VMClassLoader_findLoadedClass", (void *)Java_java_lang_VMClassLoader_findLoadedClass, NI_IS_JNI },
#endif
	{ "java_lang_VMClassLoader_getPrimitiveClass", (void *)Java_java_lang_VMClassLoader_getPrimitiveClass , NI_IS_JNI },
	{ "java_lang_VMClassLoader_resolveClass", (void *)Java_java_lang_VMClassLoader_resolveClass , NI_IS_JNI }, 
    
//java.lang.VMObject native methods
	{ "java_lang_VMObject_clone", (void *) Java_java_lang_VMObject_clone , NI_IS_JNI },
	{ "java_lang_VMObject_getClass", (void *) Java_java_lang_VMObject_getClass, NI_IS_JNI },
    { "java_lang_VMObject_notify", (void  *)java_lang_VMObject_notify,  NI_IS_RNI },
    { "java_lang_VMObject_notifyAll", (void  *)java_lang_VMObject_notifyAll,  NI_IS_RNI },
    { "java_lang_VMObject_registerNatives", (void  *)java_lang_VMObject_registerNatives,  NI_IS_RNI },
    { "java_lang_VMObject_wait", (void  *)java_lang_VMObject_wait,  NI_IS_RNI },

//java.lang.VMSecurityManager native methods
	{ "java_lang_VMSecurityManager_currentClassLoader", (void *) Java_java_lang_VMSecurityManager_currentClassLoader, NI_IS_JNI },
	{ "java_lang_VMSecurityManager_getClassContext", (void *) Java_java_lang_VMSecurityManager_getClassContext, NI_IS_JNI },

//java.lang.VMSystem native methods
	{ "java_lang_VMSystem_arraycopy", (void *)java_lang_System_arraycopy , NI_IS_RNI },
    { "java_lang_VMSystem_identityHashCode", (void *) Java_java_lang_VMSystem_identityHashCode, NI_IS_JNI },
    { "java_lang_VMSystem_insertSystemProperties", (void *)Java_java_lang_VMSystem_insertSystemProperties , NI_IS_JNI },

//java.lang.reflect.Constructor native methods
	{ "java_lang_reflect_Constructor_constructNative", (void *)Java_java_lang_reflect_Constructor_constructNative , NI_IS_JNI },
	{ "java_lang_reflect_Constructor_getModifiers", (void *)Java_java_lang_reflect_Constructor_getModifiers , NI_IS_JNI },

//java.lang.reflect.Field native methods
	{ "java_lang_reflect_Field_get", (void *) Java_java_lang_reflect_Field_get, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getBoolean", (void *) Java_java_lang_reflect_Field_getBoolean, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getByte", (void *) Java_java_lang_reflect_Field_getByte, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getChar", (void *) Java_java_lang_reflect_Field_getChar, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getDouble", (void *) Java_java_lang_reflect_Field_getDouble, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getFloat", (void *) Java_java_lang_reflect_Field_getFloat, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getInt", (void *) Java_java_lang_reflect_Field_getInt, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getLong", (void *) Java_java_lang_reflect_Field_getLong, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getModifiers", (void *) Java_java_lang_reflect_Field_getModifiers, NI_IS_JNI }, 
	// Field.getName is replaced by Classpath using java implementation
    //{ "java_lang_reflect_Field_getName", (void *) Java_java_lang_reflect_Field_getName, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getShort", (void *) Java_java_lang_reflect_Field_getShort, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_getType", (void *) Java_java_lang_reflect_Field_getType, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_set", (void *) Java_java_lang_reflect_Field_set, NI_IS_JNI },
    { "java_lang_reflect_Field_setBoolean", (void *) Java_java_lang_reflect_Field_setBoolean, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setByte", (void *) Java_java_lang_reflect_Field_setByte, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setChar", (void *) Java_java_lang_reflect_Field_setChar, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setDouble", (void *) Java_java_lang_reflect_Field_setDouble, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setFloat", (void *) Java_java_lang_reflect_Field_setFloat, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setInt", (void *) Java_java_lang_reflect_Field_setInt, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setLong", (void *) Java_java_lang_reflect_Field_setLong, NI_IS_JNI }, 
	{ "java_lang_reflect_Field_setShort", (void *) Java_java_lang_reflect_Field_setShort, NI_IS_JNI }, 

//java.lang.reflect.Method native methods
	{ "java_lang_reflect_Method_getExceptionTypes", (void *) Java_java_lang_reflect_Method_getExceptionTypes, NI_IS_JNI }, 
	{ "java_lang_reflect_Method_getModifiers", (void *) Java_java_lang_reflect_Method_getModifiers, NI_IS_JNI }, 
	{ "java_lang_reflect_Method_getParameterTypes", (void *) Java_java_lang_reflect_Method_getParameterTypes, NI_IS_JNI }, 
	{ "java_lang_reflect_Method_getReturnType", (void *) Java_java_lang_reflect_Method_getReturnType, NI_IS_JNI }, 
	{ "java_lang_reflect_Method_invokeNative", (void *) Java_java_lang_reflect_Method_invokeNative, NI_IS_JNI }, 

};


int sizeof_built_ins_base = sizeof(_built_ins_base) / sizeof(_built_ins_base[0]) ;


#ifndef NON_ORP_NATIVE_LIBS
Built_In_Method_Entry _built_ins_extra [] = {

	{ "_Java_java_lang_Math_abs__D@16",	(void *) Java_java_lang_Math_abs__D, NI_IS_JNI },
	{ "_Java_java_lang_Math_abs__F@12",	(void *) Java_java_lang_Math_abs__F, NI_IS_JNI },
	{ "_Java_java_lang_Math_max__DD@24",(void *) Java_java_lang_Math_max__FF, NI_IS_JNI },
	{ "_Java_java_lang_Math_max__FF@16",(void *) Java_java_lang_Math_max__FF, NI_IS_JNI },
	{ "_Java_java_lang_Math_min__DD@24",(void *) Java_java_lang_Math_min__DD, NI_IS_JNI }, 
	{ "_Java_java_lang_Math_min__FF@16",(void *) Java_java_lang_Math_min__FF, NI_IS_JNI },

    { "java_io_FileDescriptor_syncInternal", (void *) Java_java_io_FileDescriptor_syncInternal, NI_IS_JNI }, 
    { "java_io_FileDescriptor_validInternal", (void *) Java_java_io_FileDescriptor_validInternal, NI_IS_JNI },

    { "java_io_FileInputStream_closeInternal", (void *) Java_java_io_FileInputStream_closeInternal, NI_IS_JNI },
    { "java_io_FileInputStream_getFileLength", (void *) Java_java_io_FileInputStream_getFileLength, NI_IS_JNI },
    { "java_io_FileInputStream_open", (void *) Java_java_io_FileInputStream_open, NI_IS_JNI },
    { "java_io_FileInputStream_readInternal", (void *) java_io_FileInputStream_readInternal, NI_IS_RNI },
    
    { "java_io_FileInputStream_skipInternal", (void *) Java_java_io_FileInputStream_skipInternal, NI_IS_JNI },

    { "java_io_FileOutputStream_closeInternal", (void *) Java_java_io_FileOutputStream_closeInternal, NI_IS_JNI },
    { "java_io_FileOutputStream_open", (void *) Java_java_io_FileOutputStream_open, NI_IS_JNI },
    { "java_io_FileOutputStream_writeInternal", (void *) Java_java_io_FileOutputStream_writeInternal, NI_IS_JNI },

	{ "java_io_File_canReadInternal", (void *) Java_java_io_File_canReadInternal, NI_IS_JNI },
	{ "java_io_File_canWriteInternal", (void *) Java_java_io_File_canWriteInternal, NI_IS_JNI },
	{ "java_io_File_createInternal", (void *) Java_java_io_File_createInternal, NI_IS_JNI },
	{ "java_io_File_deleteInternal", (void *) Java_java_io_File_deleteInternal, NI_IS_JNI },
	{ "java_io_File_existsInternal", (void *) Java_java_io_File_existsInternal, NI_IS_JNI },
	{ "java_io_File_isDirectoryInternal", (void *) Java_java_io_File_isDirectoryInternal, NI_IS_JNI },
	{ "java_io_File_isFileInternal", (void *) Java_java_io_File_isFileInternal, NI_IS_JNI },
	{ "java_io_File_lastModifiedInternal", (void *) Java_java_io_File_lastModifiedInternal, NI_IS_JNI },
	{ "java_io_File_lengthInternal", (void *) Java_java_io_File_lengthInternal, NI_IS_JNI },
	{ "java_io_File_listInternal", (void *) Java_java_io_File_listInternal, NI_IS_JNI },
	{ "java_io_File_mkdirInternal", (void *) Java_java_io_File_mkdirInternal, NI_IS_JNI },
	{ "java_io_File_renameToInternal", (void *) Java_java_io_File_renameToInternal, NI_IS_JNI },
	{ "java_io_File_setLastModifiedInternal", (void *) Java_java_io_File_setLastModifiedInternal, NI_IS_JNI },
	{ "java_io_File_setReadOnlyInternal", (void *) Java_java_io_File_setReadOnlyInternal, NI_IS_JNI },

	{ "java_io_ObjectInputStream_allocateObject", (void *)Java_java_io_ObjectInputStream_allocateObject, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_callConstructor", (void *)Java_java_io_ObjectInputStream_callConstructor, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_callReadMethod", (void *)Java_java_io_ObjectInputStream_callReadMethod, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_currentClassLoader", (void *)Java_java_io_ObjectInputStream_currentClassLoader, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setBooleanField", (void *)Java_java_io_ObjectInputStream_setBooleanField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setByteField", (void *)Java_java_io_ObjectInputStream_setByteField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setCharField", (void *)Java_java_io_ObjectInputStream_setCharField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setDoubleField", (void *)Java_java_io_ObjectInputStream_setDoubleField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setFloatField", (void *)Java_java_io_ObjectInputStream_setFloatField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setIntField", (void *)Java_java_io_ObjectInputStream_setIntField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setLongField", (void *)Java_java_io_ObjectInputStream_setLongField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setObjectField", (void *)Java_java_io_ObjectInputStream_setObjectField, NI_IS_JNI }, 
	{ "java_io_ObjectInputStream_setShortField", (void *)Java_java_io_ObjectInputStream_setShortField, NI_IS_JNI }, 

	{ "java_io_ObjectOutputStream_callWriteMethod", (void *)Java_java_io_ObjectOutputStream_callWriteMethod, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getBooleanField", (void *)Java_java_io_ObjectOutputStream_getBooleanField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getByteField", (void *)Java_java_io_ObjectOutputStream_getByteField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getCharField", (void *)Java_java_io_ObjectOutputStream_getCharField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getDoubleField", (void *)Java_java_io_ObjectOutputStream_getDoubleField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getFloatField", (void *)Java_java_io_ObjectOutputStream_getFloatField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getIntField", (void *)Java_java_io_ObjectOutputStream_getIntField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getLongField", (void *)Java_java_io_ObjectOutputStream_getLongField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getObjectField", (void *)Java_java_io_ObjectOutputStream_getObjectField, NI_IS_JNI }, 
	{ "java_io_ObjectOutputStream_getShortField", (void *)Java_java_io_ObjectOutputStream_getShortField, NI_IS_JNI }, 

	{ "java_io_RandomAccessFile_closeInternal", (void *) Java_java_io_RandomAccessFile_closeInternal, NI_IS_JNI },
	{ "java_io_RandomAccessFile_getFilePointerInternal", (void *)Java_java_io_RandomAccessFile_getFilePointerInternal, NI_IS_JNI },
	{ "java_io_RandomAccessFile_lengthInternal", (void *) Java_java_io_RandomAccessFile_lengthInternal, NI_IS_JNI },
	{ "java_io_RandomAccessFile_open", (void *) Java_java_io_RandomAccessFile_open, NI_IS_JNI },
	{ "java_io_RandomAccessFile_readInternal", (void *) Java_java_io_RandomAccessFile_readInternal, NI_IS_JNI },
	{ "java_io_RandomAccessFile_seekInternal", (void *) Java_java_io_RandomAccessFile_seekInternal, NI_IS_JNI },
	{ "java_io_RandomAccessFile_skipInternal", (void *) Java_java_io_RandomAccessFile_skipInternal, NI_IS_JNI },
	{ "java_io_RandomAccessFile_writeInternal", (void *) Java_java_io_RandomAccessFile_writeInternal, NI_IS_JNI },

//It seems Classpath hasn't implemented these methods and Brian Jones leave them here
	{ "java_lang_Class_hackRunInitializers", (void *) Java_java_lang_Class_hackRunInitializers, NI_IS_JNI },
	{ "java_lang_Class_initializeClass", (void *) Java_java_lang_Class_initializeClass, NI_IS_JNI },
	{ "java_lang_Class_isArray", (void *) Java_java_lang_Class_isArray, NI_IS_JNI },
	{ "java_lang_Class_newInstance", (void *) java_lang_Class_newInstance, NI_IS_RNI },

	{ "java_lang_Double_doubleToLongBits", (void *) Java_java_lang_Double_doubleToLongBits, NI_IS_JNI },
	{ "java_lang_Double_initIDs", (void *) Java_java_lang_Double_initIDs, NI_IS_JNI }, 
	{ "java_lang_Double_longBitsToDouble", (void *) Java_java_lang_Double_longBitsToDouble, NI_IS_JNI },
//#ifdef OLD_VERSION_CLASSPATH
    { "java_lang_Double_parseDouble", (void *) Java_java_lang_Double_parseDouble, NI_IS_JNI },
//#else
    { "java_lang_Double_parseDouble0", (void *) Java_java_lang_Double_parseDouble, NI_IS_JNI },
//#endif
	{ "java_lang_Double_toString", (void *) Java_java_lang_Double_toString, NI_IS_JNI },

	{ "java_lang_Float_floatToIntBits", (void *) Java_java_lang_Float_floatToIntBits, NI_IS_JNI },
	{ "java_lang_Float_intBitsToFloat", (void *) Java_java_lang_Float_intBitsToFloat, NI_IS_JNI },
	{ "java_lang_Float_parseFloat", (void *) Java_java_lang_Float_parseFloat, NI_IS_JNI },
	{ "java_lang_Float_toString", (void *) Java_java_lang_Float_toString, NI_IS_JNI },

    { "java_lang_Math_IEEEremainder", (void *) Java_java_lang_Math_IEEEremainder, NI_IS_JNI },
	{ "java_lang_Math_acos",(void *) Java_java_lang_Math_acos, NI_IS_JNI },
	{ "java_lang_Math_asin",(void *) Java_java_lang_Math_asin, NI_IS_JNI },
	{ "java_lang_Math_atan",(void *) Java_java_lang_Math_atan, NI_IS_JNI },
	{ "java_lang_Math_ceil",(void *) Java_java_lang_Math_ceil, NI_IS_JNI },
	{ "java_lang_Math_cos",(void *) Java_java_lang_Math_cos, NI_IS_JNI  },	
	{ "java_lang_Math_exp",	(void *) Java_java_lang_Math_exp, NI_IS_JNI },
	{ "java_lang_Math_floor",(void *) Java_java_lang_Math_floor, NI_IS_JNI },
	{ "java_lang_Math_log",	(void *) Java_java_lang_Math_log, NI_IS_JNI  },
	{ "java_lang_Math_pow",(void *) Java_java_lang_Math_pow, NI_IS_JNI },
	{ "java_lang_Math_sin",	(void *) Java_java_lang_Math_sin, NI_IS_JNI },
	{ "java_lang_Math_sqrt",(void *) Java_java_lang_Math_sqrt, NI_IS_JNI },
	{ "java_lang_Math_tan",	(void *) Java_java_lang_Math_tan, NI_IS_JNI },

	{ "java_lang_StringBuffer_green", (void *) Java_java_lang_StringBuffer_green, NI_IS_JNI },

	//{ "java_lang_System_currentTimeMillis", (void *) Java_java_lang_System_currentTimeMillis, NI_IS_JNI },
	{ "java_lang_System_currentTimeMillis", (void *) Java_java_lang_System_currentTimeMillis_no_extra_args, NI_IS_DIRECT },
    { "java_lang_System_isWordsBigEndian", (void *) Java_java_lang_System_isWordsBigEndian, NI_IS_JNI },
	{ "java_lang_System_setErr", (void *) Java_java_lang_System_setErr, NI_IS_JNI },
	{ "java_lang_System_setIn", (void *) Java_java_lang_System_setIn, NI_IS_JNI },
	{ "java_lang_System_setOut", (void *) Java_java_lang_System_setOut, NI_IS_JNI },

	{ "java_lang_reflect_Array_createObjectArray", (void *)Java_java_lang_reflect_Array_createObjectArray , NI_IS_JNI },
	{ "java_lang_reflect_Array_getLength", (void *)Java_java_lang_reflect_Array_getLength , NI_IS_JNI },
    
    { "java_net_InetAddress_getHostByAddr", (void *) Java_java_net_InetAddress_getHostByAddr, NI_IS_JNI },
   	{ "java_net_InetAddress_getHostByName", (void *) Java_java_net_InetAddress_getHostByName, NI_IS_JNI },
	{ "java_net_InetAddress_getLocalHostName", (void *) Java_java_net_InetAddress_getLocalHostName, NI_IS_JNI }, 
	{ "java_net_InetAddress_lookupInaddrAny", (void *) Java_java_net_InetAddress_lookupInaddrAny, NI_IS_JNI },

   	{ "java_net_PlainDatagramSocketImpl_bind", (void *) Java_java_net_PlainDatagramSocketImpl_bind, NI_IS_JNI }, 
	{ "java_net_PlainDatagramSocketImpl_close", (void *) Java_java_net_PlainDatagramSocketImpl_close, NI_IS_JNI },  
	{ "java_net_PlainDatagramSocketImpl_create", (void *) Java_java_net_PlainDatagramSocketImpl_create, NI_IS_JNI }, 
	{ "java_net_PlainDatagramSocketImpl_getOption", (void *) Java_java_net_PlainDatagramSocketImpl_getOption, NI_IS_JNI }, 
	{ "java_net_PlainDatagramSocketImpl_join", (void *) Java_java_net_PlainDatagramSocketImpl_join, NI_IS_JNI }, 
	{ "java_net_PlainDatagramSocketImpl_leave", (void *) Java_java_net_PlainDatagramSocketImpl_leave, NI_IS_JNI }, 
	{ "java_net_PlainDatagramSocketImpl_receive", (void *) Java_java_net_PlainDatagramSocketImpl_receive, NI_IS_JNI }, 
	{ "java_net_PlainDatagramSocketImpl_sendto", (void *) Java_java_net_PlainDatagramSocketImpl_sendto, NI_IS_JNI },
	{ "java_net_PlainDatagramSocketImpl_setOption", (void *) Java_java_net_PlainDatagramSocketImpl_setOption, NI_IS_JNI },
    
	{ "java_net_PlainSocketImpl_accept", (void *) Java_java_net_PlainSocketImpl_accept, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_available", (void *) Java_java_net_PlainSocketImpl_available, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_bind", (void *) Java_java_net_PlainSocketImpl_bind, NI_IS_JNI },
    { "java_net_PlainSocketImpl_close", (void *) Java_java_net_PlainSocketImpl_close, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_connect", (void *) Java_java_net_PlainSocketImpl_connect, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_create", (void *) Java_java_net_PlainSocketImpl_create, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_getOption", (void *) Java_java_net_PlainSocketImpl_getOption, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_listen", (void *) Java_java_net_PlainSocketImpl_listen, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_read", (void *) Java_java_net_PlainSocketImpl_read, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_setOption", (void *) Java_java_net_PlainSocketImpl_setOption, NI_IS_JNI },
	{ "java_net_PlainSocketImpl_write", (void *) Java_java_net_PlainSocketImpl_write, NI_IS_JNI },

	{ "java_util_Date_toString", (void *) Java_java_util_Date_toString, NI_IS_JNI },

	{ "java_util_GregorianCalendar_computeFields", (void *) Java_java_util_GregorianCalendar_computeFields, NI_IS_JNI },

    { "java_util_ResourceBundle_getClassContext", (void *) Java_java_util_ResourceBundle_getClassContext, NI_IS_JNI },

    { "java_util_TimeZone_getDefaultTimeZoneId", (void *) Java_java_util_TimeZone_getDefaultTimeZoneId, NI_IS_JNI },


}; //_built_ins

int sizeof_built_ins_extra = sizeof(_built_ins_extra) / sizeof(_built_ins_extra[0]) ;
#endif //NON_ORP_NATIVE_LIBS













