// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/jni_field.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include "Class.h"
#include "environment.h"
#include "orp_utils.h"
#include "orp_threads.h"
#include "root_set_enum.h"
#include "ini.h"


#include "jni.h"
#include "jni_direct.h"



jfieldID JNICALL GetFieldID(JNIEnv *env,
                            jclass clazz,
                            const char *name,
                            const char *sig)
{
    Object_Handle h = (Object_Handle)clazz;

    Class *clss = (Class *)h->java_reference;
    if(clss->state != ST_Initialized) {
        class_initialize_from_jni(clss, false);
        if(clss->state == ST_Error) {
            ThrowNew_Quick(env, "java/lang/ExceptionInInitializerError", clss->name->bytes);
            return 0;
        }
    }

    Field *field = class_lookup_field_recursive(clss, name, sig);
    if(!field) {
        ThrowNew_Quick(env, "java/lang/NoSuchFieldError", name);
        return 0;
    }

    assert(!field->is_static());
    return (jfieldID)field;
} //GetFieldID



// non-standard
jfieldID JNICALL GetFieldID_Quick(JNIEnv *env,
                                  const char *class_name,
                                  const char *field_name,
                                  const char *sig)
{
    Loader_Exception ld_exc;
    String *class_string = ORP_Global_State::loader_env->string_pool.lookup(class_name);
    Class *clss =
        class_load_verify_prepare_from_jni(ORP_Global_State::loader_env, class_string, &ld_exc);
    if(!clss) {
        return 0;
    }
    Field *field = class_lookup_field_recursive(clss, field_name, sig);
    return (jfieldID)field;
} //GetFieldID_Quick



jfieldID JNICALL GetStaticFieldID(JNIEnv *env,
                                  jclass clazz,
                                  const char *name,
                                  const char *sig)
{
    Object_Handle h = (Object_Handle)clazz;

    Class *clss = (Class *)h->java_reference;
    if(clss->state != ST_Initialized) {
        class_initialize_from_jni(clss, false);
        if(clss->state == ST_Error) {
            ThrowNew_Quick(env, "java/lang/ExceptionInInitializerError", clss->name->bytes);
            return 0;
        }
    }

    Field *field = class_lookup_field_recursive(clss, name, sig);
    if(!field) {
        ThrowNew_Quick(env, "java/lang/NoSuchFieldError", name);
        return 0;
    }

    assert(field->is_static());
    return (jfieldID)field;
} //GetStaticFieldID



// non-standard
jfieldID JNICALL GetStaticFieldID_Quick(JNIEnv *env,
                                        const char *class_name,
                                        const char *field_name,
                                        const char *sig)
{
    return GetFieldID_Quick(env, class_name, field_name, sig);
} //GetStaticFieldID_Quick



/////////////////////////////////////////////////////////////////////////////
// begin Get<Type>Field functions



jobject JNICALL GetObjectField(JNIEnv *env,
                               jobject obj,
                               jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;
    Object_Handle new_handle;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    Java_java_lang_Object **field_ptr = (Java_java_lang_Object **)(java_ref + offset);

    Java_java_lang_Object *val = *field_ptr;
    if(val) {
        new_handle = orp_create_local_object_handle();
        new_handle->java_reference = val;
    } else {
        new_handle = 0;
    }

    orp_enable_gc();        //---------------------------------^

    return new_handle;
} //GetObjectField



jboolean JNICALL GetBooleanField(JNIEnv *env,
                                 jobject obj,
                                 jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jboolean val = *(jboolean *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetBooleanField



jbyte JNICALL GetByteField(JNIEnv *env,
                           jobject obj,
                           jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jbyte val = *(jbyte *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetByteField



jchar JNICALL GetCharField(JNIEnv *env,
                           jobject obj,
                           jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jchar val = *(jchar *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetCharField



jshort JNICALL GetShortField(JNIEnv *env,
                             jobject obj,
                             jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jshort val = *(jshort *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetShortField



jint JNICALL GetIntField(JNIEnv *env,
                         jobject obj,
                         jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jint val = *(jint *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetIntField



jlong JNICALL GetLongField(JNIEnv *env,
                           jobject obj,
                           jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jlong val = *(jlong *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetLongField



jfloat JNICALL GetFloatField(JNIEnv *env,
                             jobject obj,
                             jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jfloat val = *(jfloat *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetFloatField



jdouble JNICALL GetDoubleField(JNIEnv *env,
                               jobject obj,
                               jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    jdouble val = *(jdouble *)(java_ref + offset);

    orp_enable_gc();        //---------------------------------^

    return val;
} //GetDoubleField



// end Get<Type>Field functions
/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// begin Set<Type>Field functions



void JNICALL SetObjectField(JNIEnv *env,
                            jobject obj,
                            jfieldID fieldID,
                            jobject value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;
    Object_Handle v = (Object_Handle)value;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    Java_java_lang_Object **field_ptr = (Java_java_lang_Object **)(java_ref + offset);

    Java_java_lang_Object *val;
    if(v) {
        val = v->java_reference;
    } else {
        val = 0;
    }
//        *field_ptr = val;
    gc_heap_slot_write_ref ((Java_java_lang_Object *)java_ref, 
        (Java_java_lang_Object **)field_ptr, 
        (Java_java_lang_Object *)val);

    orp_enable_gc();        //---------------------------------^
} //SetObjectField



void JNICALL SetBooleanField(JNIEnv *env,
                             jobject obj,
                             jfieldID fieldID,
                             jboolean value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jboolean *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetBooleanField



void JNICALL SetByteField(JNIEnv *env,
                          jobject obj,
                          jfieldID fieldID,
                          jbyte value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jbyte *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetByteField



void JNICALL SetCharField(JNIEnv *env,
                          jobject obj,
                          jfieldID fieldID,
                          jchar value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jchar *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetCharField



void JNICALL SetShortField(JNIEnv *env,
                           jobject obj,
                           jfieldID fieldID,
                           jshort value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jshort *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetShortField



void JNICALL SetIntField(JNIEnv *env,
                         jobject obj,
                         jfieldID fieldID,
                         jint value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jint *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetIntField



void JNICALL SetLongField(JNIEnv *env,
                          jobject obj,
                          jfieldID fieldID,
                          jlong value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jlong *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetLongField



void JNICALL SetFloatField(JNIEnv *env,
                           jobject obj,
                           jfieldID fieldID,
                           jfloat value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jfloat *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetFloatField



void JNICALL SetDoubleField(JNIEnv *env,
                            jobject obj,
                            jfieldID fieldID,
                            jdouble value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(!f->is_static());
    unsigned offset = f->get_offset();
    Object_Handle h = (Object_Handle)obj;

    orp_disable_gc();       //---------------------------------v

    Byte *java_ref = (Byte *)h->java_reference;
    *(jdouble *)(java_ref + offset) = value;

    orp_enable_gc();        //---------------------------------^
} //SetDoubleField



// end Set<Type>Field functions
/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// begin GetStatic<Type>Field functions



jobject JNICALL GetStaticObjectField(JNIEnv *env,
                                     jclass clazz,
                                     jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    Java_java_lang_Object **addr = (Java_java_lang_Object **)f->get_address();
    Object_Handle new_handle;

    orp_disable_gc();       //---------------------------------v

    Java_java_lang_Object *val = *addr;
    if(val) {
        new_handle = orp_create_local_object_handle();
        new_handle->java_reference = val;
    } else {
        new_handle = 0;
    }

    orp_enable_gc();        //---------------------------------^

    return new_handle;
} //GetStaticObjectField



jboolean JNICALL GetStaticBooleanField(JNIEnv *env,
                                       jclass clazz,
                                       jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jboolean *addr = (jboolean *)f->get_address();
    return *addr;
} //GetStaticBooleanField



jbyte JNICALL GetStaticByteField(JNIEnv *env,
                                 jclass clazz,
                                 jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jbyte *addr = (jbyte *)f->get_address();
    return *addr;
} //GetStaticByteField



jchar JNICALL GetStaticCharField(JNIEnv *env,
                                 jclass clazz,
                                 jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jchar *addr = (jchar *)f->get_address();
    return *addr;
} //GetStaticCharField



jshort JNICALL GetStaticShortField(JNIEnv *env,
                                   jclass clazz,
                                   jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jshort *addr = (jshort *)f->get_address();
    return *addr;
} //GetStaticShortField



jint JNICALL GetStaticIntField(JNIEnv *env,
                               jclass clazz,
                               jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jint *addr = (jint *)f->get_address();
    return *addr;
} //GetStaticIntField



jlong JNICALL GetStaticLongField(JNIEnv *env,
                                 jclass clazz,
                                 jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jlong *addr = (jlong *)f->get_address();
    return *addr;
} //GetStaticLongField



jfloat JNICALL GetStaticFloatField(JNIEnv *env,
                                  jclass clazz,
                                  jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jfloat *addr = (jfloat *)f->get_address();
    return *addr;
} //GetStaticFloatField



jdouble JNICALL GetStaticDoubleField(JNIEnv *env,
                                     jclass clazz,
                                     jfieldID fieldID)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jdouble *addr = (jdouble *)f->get_address();
    return *addr;
} //GetStaticDoubleField



// end GetStatic<Type>Field functions
/////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////
// begin SetStatic<Type>Field functions



void JNICALL SetStaticObjectField(JNIEnv *env,
                                  jclass clazz,
                                  jfieldID fieldID,
                                  jobject value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    Java_java_lang_Object **addr = (Java_java_lang_Object **)f->get_address();

    if(!value) {
        // No need to disable GC for null pointers.
        *addr = 0;
    } else {
        Object_Handle v = (Object_Handle)value;

        orp_disable_gc();       //---------------------------------v

        *addr = v->java_reference;

        orp_enable_gc();        //---------------------------------^
    }
} //SetStaticObjectField



void JNICALL SetStaticBooleanField(JNIEnv *env,
                                   jclass clazz,
                                   jfieldID fieldID,
                                   jboolean value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jboolean *addr = (jboolean *)f->get_address();
    *addr = value;
} //SetStaticBooleanField



void JNICALL SetStaticByteField(JNIEnv *env,
                                jclass clazz,
                                jfieldID fieldID,
                                jbyte value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jbyte *addr = (jbyte *)f->get_address();
    *addr = value;
} //SetStaticByteField



void JNICALL SetStaticCharField(JNIEnv *env,
                                jclass clazz,
                                jfieldID fieldID,
                                jchar value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jchar *addr = (jchar *)f->get_address();
    *addr = value;
} //SetStaticCharField



void JNICALL SetStaticShortField(JNIEnv *env,
                                 jclass clazz,
                                 jfieldID fieldID,
                                 jshort value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jshort *addr = (jshort *)f->get_address();
    *addr = value;
} //SetStaticShortField



void JNICALL SetStaticIntField(JNIEnv *env,
                               jclass clazz,
                               jfieldID fieldID,
                               jint value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jint *addr = (jint *)f->get_address();
    *addr = value;
} //SetStaticIntField



void JNICALL SetStaticLongField(JNIEnv *env,
                                jclass clazz,
                                jfieldID fieldID,
                                jlong value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jlong *addr = (jlong *)f->get_address();
    *addr = value;
} //SetStaticLongField



void JNICALL SetStaticFloatField(JNIEnv *env,
                                 jclass clazz,
                                 jfieldID fieldID,
                                 jfloat value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jfloat *addr = (jfloat *)f->get_address();
    *addr = value;
} //SetStaticFloatField



void JNICALL SetStaticDoubleField(JNIEnv *env,
                                  jclass clazz,
                                  jfieldID fieldID,
                                  jdouble value)
{
    Field *f = (Field *)fieldID;
    assert(f);
    assert(f->is_static());
    jdouble *addr = (jdouble *)f->get_address();
    *addr = value;
} //SetStaticDoubleField



// end SetStatic<Type>Field functions
/////////////////////////////////////////////////////////////////////////////




